/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyExtension;

public class ClasspathDependencyExtensionManager {
    private static ClasspathDependencyExtensionManager instance;
    private List<ElementEntry> entries = new ArrayList<ElementEntry>();

    private ClasspathDependencyExtensionManager() {
    }

    public static ClasspathDependencyExtensionManager instance() {
        if (instance == null) {
            instance = new ClasspathDependencyExtensionManager();
            instance.load();
        }
        return instance;
    }

    public boolean doesProjectHandleExport(IProject project, IClasspathEntry entry) {
        boolean result = false;
        for (ElementEntry listEntry : this.entries) {
            IClasspathDependencyExtension extension;
            if (!listEntry.isEnabled(project) || (extension = listEntry.getExtensionClass()) == null || !extension.projectHandlesExport(project, entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getDependencyValue(IProject project, IClasspathEntry entry) {
        String result = null;
        for (ElementEntry listEntry : this.entries) {
            IClasspathDependencyExtension extension;
            if (listEntry.isEnabled(project) && (extension = listEntry.getExtensionClass()) != null && (result = extension.getClasspathdependencyAttribute(project, entry)) != null) break;
        }
        return result;
    }

    private void load() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.jst.j2ee.ClasspathDependencyExtension");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("classpathdependency")) {
                IConfigurationElement[] childElements = element.getChildren();
                ElementEntry elementEntry = new ElementEntry();
                elementEntry.element = element;
                IConfigurationElement[] iConfigurationElementArray2 = childElements;
                int n3 = childElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement childElement = iConfigurationElementArray2[n4];
                    String elementName = childElement.getName();
                    if (elementName.equals("enablement")) {
                        try {
                            elementEntry.enablementExpression = ExpressionConverter.getDefault().perform(childElement);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n4;
                }
                this.entries.add(elementEntry);
            }
            ++n2;
        }
    }

    private class ElementEntry {
        public Expression enablementExpression;
        public IConfigurationElement element;
        private IClasspathDependencyExtension extension;

        private ElementEntry() {
        }

        public IClasspathDependencyExtension getExtensionClass() {
            if (this.element == null) {
                return null;
            }
            if (this.extension == null) {
                try {
                    this.extension = (IClasspathDependencyExtension)this.element.createExecutableExtension("class");
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            return this.extension;
        }

        public boolean isEnabled(IProject project) {
            if (this.enablementExpression == null) {
                return true;
            }
            boolean result = false;
            EvaluationContext context = new EvaluationContext(null, (Object)project);
            context.setAllowPluginActivation(true);
            try {
                EvaluationResult expResult = this.enablementExpression.evaluate((IEvaluationContext)context);
                if (expResult != EvaluationResult.FALSE) {
                    result = true;
                }
            }
            catch (CoreException coreException) {
                result = false;
            }
            return result;
        }
    }
}

