/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class JAXWSHandlerUtils {
    public static final String HANDLER_CHAINS = "handler-chains";
    public static final String HANDLER_CHAIN = "handler-chain";
    public static final String HANDLER = "handler";
    public static final String HANDLER_NAME = "handler-name";
    public static final String HANDLER_CLASS = "handler-class";
    public static final Namespace JAVAEE_NS = Namespace.getNamespace((String)"http://java.sun.com/xml/ns/javaee");

    private JAXWSHandlerUtils() {
    }

    public static void createHandlerChainFile(IPath path, String handlerName, String handlerClass) {
        IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!handlerChainFile.exists()) {
            try {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                handlerChainFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)progressMonitor);
                Element handlerChainsElement = new Element(HANDLER_CHAINS);
                handlerChainsElement.setNamespace(JAVAEE_NS);
                Element handlerChainElement = new Element(HANDLER_CHAIN, JAVAEE_NS);
                Element handlerElement = new Element(HANDLER, JAVAEE_NS);
                Element handlerNameElement = new Element(HANDLER_NAME, JAVAEE_NS);
                handlerNameElement.setText(handlerName);
                Element handlerClassElement = new Element(HANDLER_CLASS, JAVAEE_NS);
                handlerClassElement.setText(handlerClass);
                handlerElement.addContent((Content)handlerNameElement);
                handlerElement.addContent((Content)handlerClassElement);
                handlerChainElement.addContent((Content)handlerElement);
                handlerChainsElement.addContent((Content)handlerChainElement);
                Document document = new Document(handlerChainsElement);
                FileOutputStream outputStream = new FileOutputStream(handlerChainFile.getLocation().toFile());
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(document, (OutputStream)outputStream);
                handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce);
            }
            catch (FileNotFoundException fnfe) {
                JAXWSCorePlugin.log(fnfe);
            }
            catch (IOException ioe) {
                JAXWSCorePlugin.log(ioe);
            }
        }
    }

    public static void createHandlerChainFile(IPath path) {
        IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!handlerChainFile.exists()) {
            try {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                handlerChainFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)progressMonitor);
                Element handlerChainsElement = new Element(HANDLER_CHAINS);
                handlerChainsElement.setNamespace(JAVAEE_NS);
                Document document = new Document(handlerChainsElement);
                FileOutputStream outputStream = new FileOutputStream(handlerChainFile.getLocation().toFile());
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(document, (OutputStream)outputStream);
                handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce);
            }
            catch (FileNotFoundException fnfe) {
                JAXWSCorePlugin.log(fnfe);
            }
            catch (IOException ioe) {
                JAXWSCorePlugin.log(ioe);
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void addHandlerToHandlerChain(IPath path, String handlerName, String handlerClass) throws CoreException {
        IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (handlerChainFile.exists() && handlerChainFile.isAccessible()) {
            try {
                try {
                    FileInputStream handlerInputStream = new FileInputStream(handlerChainFile.getLocation().toFile());
                    SAXBuilder builder = new SAXBuilder();
                    Document document = builder.build((InputStream)handlerInputStream);
                    Element root = document.getRootElement();
                    Element handlerChainElement = root.getChild(HANDLER_CHAIN, JAVAEE_NS);
                    if (handlerChainElement == null) {
                        handlerChainElement = new Element(HANDLER_CHAIN, JAVAEE_NS);
                        root.addContent((Content)handlerChainElement);
                    }
                    Element handlerElement = new Element(HANDLER, JAVAEE_NS);
                    Element handlerNameElement = new Element(HANDLER_NAME, JAVAEE_NS);
                    handlerNameElement.setText(handlerName);
                    Element handlerClassElement = new Element(HANDLER_CLASS, JAVAEE_NS);
                    handlerClassElement.setText(handlerClass);
                    handlerElement.addContent((Content)handlerNameElement);
                    handlerElement.addContent((Content)handlerClassElement);
                    handlerChainElement.addContent((Content)handlerElement);
                    FileOutputStream outputStream = new FileOutputStream(handlerChainFile.getLocation().toFile());
                    XMLOutputter outputter = new XMLOutputter();
                    outputter.output(document, (OutputStream)outputStream);
                }
                catch (FileNotFoundException fnfe) {
                    JAXWSCorePlugin.log(fnfe);
                    handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
                }
                catch (IOException ioe) {
                    JAXWSCorePlugin.log(ioe);
                    handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
                }
                catch (JDOMException jdome) {
                    JAXWSCorePlugin.log(jdome);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
                }
            }
            finally {
                handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
            }
        }
    }

    public static void writeDocumentToFile(IPath filePath, Document document) throws CoreException {
        block7: {
            IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
            if (handlerChainFile.exists()) {
                try {
                    if (!JAXWSHandlerUtils.isHandlerChainFile(handlerChainFile)) break block7;
                    FileOutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(handlerChainFile.getLocation().toFile());
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.output(document, (OutputStream)outputStream);
                    }
                    finally {
                        handlerChainFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        JAXWSHandlerUtils.formatXMLFile(handlerChainFile);
                        if (outputStream != null) {
                            ((OutputStream)outputStream).close();
                        }
                    }
                }
                catch (IOException ioe) {
                    JAXWSCorePlugin.log(ioe);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isHandlerDefined(IFile handlerChainFile, String handlerName, String handlerClass) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isHandlerChainFile(IFile handlerChainFile) throws IOException {
        FileInputStream handlerChainInputStream;
        if (handlerChainFile.exists() && (handlerChainInputStream = new FileInputStream(handlerChainFile.getLocation().toFile())).available() > 0) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build((InputStream)handlerChainInputStream);
                Element root = doc.getRootElement();
                if (root.getName().equals(HANDLER_CHAINS) && root.getNamespace().equals((Object)JAVAEE_NS)) {
                    return true;
                }
            }
            catch (JDOMException jdome) {
                JAXWSCorePlugin.log(jdome);
            }
            finally {
                handlerChainInputStream.close();
            }
        }
        return false;
    }

    public static void formatXMLFile(IFile file) {
        if (file != null) {
            try {
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription == null) {
                    return;
                }
                IContentType contentType = contentDescription.getContentType();
                IStructuredFormatProcessor formatProcessor = FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentType.getId());
                if (formatProcessor != null) {
                    formatProcessor.formatFile(file);
                }
            }
            catch (CoreException ce) {
                JAXWSCorePlugin.log(ce.getStatus());
            }
            catch (IOException ioe) {
                JAXWSCorePlugin.log(ioe);
            }
        }
    }
}

