/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.nsedit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class CommonNamespaceInfoTable
extends TableViewer {
    protected static final int COLUMN_CHECKBOX = 1;
    protected static final int COLUMN_LOCATION_HINT = 4;
    protected static final int COLUMN_NAMESPACE_URI = 2;
    protected static final int COLUMN_PREFIX = 3;
    protected static final String LABEL_CHECKBOX = "";
    protected static final String LABEL_LOCATION_HINT = XMLUIMessages._UI_LABEL_LOCATION_HINT;
    protected static final String LABEL_NAMESPACE_URI = XMLUIMessages._UI_LABEL_NAMESPACE_NAME;
    protected static final String LABEL_PREFIX = XMLUIMessages._UI_LABEL_PREFIX;
    protected List checkedList = new ArrayList();
    protected int[] columnIndexMap;
    protected boolean showCheckBoxes = true;
    private boolean showLocationText = false;
    private Table table;
    protected int visibleRows = -1;

    public CommonNamespaceInfoTable(Composite parent, int visibleRows) {
        this(parent, 67586, visibleRows, false);
    }

    public CommonNamespaceInfoTable(Composite parent, int visibleRows, boolean showLocationText) {
        this(parent, 67586, visibleRows, showLocationText);
    }

    public CommonNamespaceInfoTable(Composite parent, int style, int visibleRows) {
        this(parent, 0x10802 | style, visibleRows, false);
    }

    public CommonNamespaceInfoTable(Composite parent, int style, int visibleRows, boolean showLocationText) {
        super(new Table(parent, style));
        this.getTable().setLinesVisible(true);
        this.showCheckBoxes = (style & 0x20) != 0;
        this.columnIndexMap = this.createColumnIndexMap();
        this.showLocationText = showLocationText;
        Provider provider = new Provider();
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        String[] columnPropertiesArray = this.createColumnPropertiesArray();
        this.setColumnProperties(columnPropertiesArray);
        this.table = this.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnPropertiesArray.length) {
            TableColumn column = new TableColumn(this.table, i);
            if (columnPropertiesArray[i].equals(LABEL_LOCATION_HINT)) {
                if (showLocationText) {
                    column.setText(columnPropertiesArray[i]);
                }
            } else {
                column.setText(columnPropertiesArray[i]);
            }
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.getColumnWidth(i), true));
            ++i;
        }
        this.table.setLayout((Layout)layout);
        this.visibleRows = visibleRows;
    }

    protected int[] createColumnIndexMap() {
        int[] result = new int[this.showCheckBoxes ? 4 : 3];
        int i = 0;
        if (this.showCheckBoxes) {
            result[i++] = 1;
        }
        result[i++] = 3;
        result[i++] = 2;
        if (!this.showCheckBoxes) {
            result[i++] = 4;
        }
        return result;
    }

    protected String[] createColumnPropertiesArray() {
        String[] result = new String[3];
        int i = 0;
        if (this.showCheckBoxes) {
            result[i++] = LABEL_CHECKBOX;
        }
        result[i++] = LABEL_PREFIX;
        result[i++] = LABEL_NAMESPACE_URI;
        if (!this.showCheckBoxes) {
            result[i++] = LABEL_LOCATION_HINT;
        }
        return result;
    }

    protected int getColumnCode(int column) {
        int result = 0;
        if (column < this.columnIndexMap.length) {
            result = this.columnIndexMap[column];
        }
        return result;
    }

    protected int getColumnWidth(int column) {
        int result = 0;
        switch (this.getColumnCode(column)) {
            case 3: {
                result = 5;
                break;
            }
            case 2: {
                if (this.showLocationText) {
                    result = 10;
                    break;
                }
                result = 20;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 4: {
                result = this.showLocationText ? 10 : 2;
            }
        }
        return result;
    }

    protected class Provider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        Viewer viewer;

        protected Provider() {
        }

        public Image getColumnImage(Object object, int columnIndex) {
            Image result = null;
            int columnCode = CommonNamespaceInfoTable.this.getColumnCode(columnIndex);
            if (columnCode == 4) {
                NamespaceInfo info = (NamespaceInfo)object;
                if (info.locationHint != null) {
                    info.locationHint.trim().equals(CommonNamespaceInfoTable.LABEL_CHECKBOX);
                }
            }
            return result;
        }

        public String getColumnText(Object object, int column) {
            NamespaceInfo info = (NamespaceInfo)object;
            String result = null;
            int columnCode = CommonNamespaceInfoTable.this.getColumnCode(column);
            switch (columnCode) {
                case 3: {
                    result = info.prefix;
                    break;
                }
                case 2: {
                    result = info.uri;
                    break;
                }
                case 1: {
                    result = CommonNamespaceInfoTable.LABEL_CHECKBOX;
                    break;
                }
                case 4: {
                    result = info.locationHint;
                }
            }
            String string = result = result != null ? result : CommonNamespaceInfoTable.LABEL_CHECKBOX;
            if (result.equals(CommonNamespaceInfoTable.LABEL_CHECKBOX)) {
                switch (columnCode) {
                    case 3: {
                        result = XMLUIMessages._UI_NO_PREFIX;
                        break;
                    }
                    case 2: {
                        result = XMLUIMessages._UI_NO_NAMESPACE_NAME;
                    }
                }
            }
            return result;
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)this.viewer.getInput();
            return list != null ? list.toArray() : null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
        }
    }

    class TableItemChecker
    extends MouseAdapter {
        TableItemChecker() {
        }

        public void mouseDown(MouseEvent e) {
            Object obj;
            TableItem item = CommonNamespaceInfoTable.this.getTable().getItem(new Point(e.x, e.y));
            if (item != null && (obj = item.getData()) != null) {
                NamespaceInfo info = (NamespaceInfo)obj;
                TableColumn col = CommonNamespaceInfoTable.this.getTable().getColumn(0);
                if (e.x < col.getWidth()) {
                    String currentState = (String)info.getProperty("checked");
                    System.out.println("currentState" + currentState);
                    if (currentState == null || currentState.equals("false")) {
                        info.setProperty("checked", (Object)"true");
                    } else {
                        info.setProperty("checked", (Object)"false");
                    }
                    CommonNamespaceInfoTable.this.refresh();
                }
            }
        }
    }
}

