/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AbstractSupertypesValidator {
    private static ITypeHierarchy typeHierarchyCache = null;

    protected static String getSuperclass(IDataModel dataModel) {
        return dataModel.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
    }

    protected static List getInterfaces(IDataModel dataModel) {
        return (List)dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
    }

    protected static IJavaProject getJavaProject(IDataModel dataModel) {
        return JavaCore.create((IProject)((IProject)dataModel.getProperty("NewJavaClassDataModel.PROJECT")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean hasSuperclass(IDataModel dataModel, String typeName, String superTypeName) {
        try {
            IType type = AbstractSupertypesValidator.getJavaProject(dataModel).findType(typeName);
            if (type == null) return false;
            ITypeHierarchy typeHierarchy = AbstractSupertypesValidator.getTypeHierarchy(type);
            IType[] iTypeArray = typeHierarchy.getAllSuperclasses(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superTypeName.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            WebPlugin.log((Exception)((Object)e));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean hasSuperInterface(IDataModel dataModel, String typeName, String superTypeName) {
        try {
            IType type = AbstractSupertypesValidator.getJavaProject(dataModel).findType(typeName);
            if (type == null) return false;
            ITypeHierarchy typeHierarchy = AbstractSupertypesValidator.getTypeHierarchy(type);
            IType[] iTypeArray = typeHierarchy.getAllSuperInterfaces(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (superTypeName.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            WebPlugin.log((Exception)((Object)e));
        }
        return false;
    }

    private static ITypeHierarchy getTypeHierarchy(IType type) throws JavaModelException {
        if (typeHierarchyCache == null || !type.equals(typeHierarchyCache.getType())) {
            typeHierarchyCache = type.newTypeHierarchy(null);
        }
        return typeHierarchyCache;
    }
}

