/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.ExternalModule;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Publisher;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.PublishOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerBehaviourDelegate {
    private Server server;
    public static final int NO_CHANGE = 0;
    public static final int ADDED = 1;
    public static final int CHANGED = 2;
    public static final int REMOVED = 3;
    private IAdaptable info2;

    final void initialize(Server newServer, IProgressMonitor monitor) {
        this.server = newServer;
        this.initialize(monitor);
    }

    protected void initialize(IProgressMonitor monitor) {
    }

    public final IServer getServer() {
        return this.server;
    }

    protected final void setServerState(int state) {
        this.server.setServerState(state);
    }

    protected final void setMode(String mode) {
        this.server.setMode(mode);
    }

    public final void setLaunch(ILaunch launch) {
        this.server.setLaunch(launch);
    }

    protected final void setServerRestartState(boolean state) {
        this.server.setServerRestartState(state);
    }

    protected final void setServerPublishState(int state) {
        this.server.setServerPublishState(state);
    }

    protected final void setModuleState(IModule[] module, int state) {
        this.server.setModuleState(module, state);
    }

    protected final void setModulePublishState(IModule[] module, int state) {
        this.server.setModulePublishState(module, state);
    }

    protected final void setModuleRestartState(IModule[] module, boolean state) {
        this.server.setModuleRestartState(module, state);
    }

    protected final void setExternalModules(IModule[] modules) {
        this.server.setExternalModules(modules);
    }

    protected final IModule createExternalModule(String id, String name, String type, String version, ModuleDelegate moduleDelegate) {
        ExternalModule module = new ExternalModule(id, name, type, version, moduleDelegate);
        this.setModulePublishState(new IModule[]{module}, 1);
        return module;
    }

    public void dispose() {
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        this.setModulePublishState(module, 1);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
    }

    public void restart(String launchMode) throws CoreException {
        throw new CoreException((IStatus)new Status(2, "org.eclipse.wst.server.core", -1, "Restart not supported", null));
    }

    public boolean canControlModule(IModule[] module) {
        return false;
    }

    public boolean canRestartModule(IModule[] module) {
        return this.canControlModule(module);
    }

    public boolean canPublishModule(IModule[] module) {
        return this.canControlModule(module);
    }

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public IStatus canRestart(String mode) {
        return Status.OK_STATUS;
    }

    public IStatus canStop() {
        return Status.OK_STATUS;
    }

    public IStatus canPublish() {
        return Status.OK_STATUS;
    }

    public void startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
    }

    public void stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
    }

    public void restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        this.stopModule(module, monitor);
        this.startModule(module, monitor);
    }

    public abstract void stop(boolean var1);

    protected IModuleResource[] getResources(IModule[] module) {
        return this.server.getResources(module);
    }

    protected IModuleResource[] getPublishedResources(IModule[] module) {
        return this.server.getPublishedResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return this.server.getPublishedResourceDelta(module);
    }

    protected IPath getTempDirectory() {
        return this.server.getTempDirectory();
    }

    protected IPath getTempDirectory(boolean recycle) {
        return this.server.getTempDirectory(recycle);
    }

    protected final void setServerStatus(IStatus status) {
        this.server.setServerStatus(status);
    }

    protected final void setModuleStatus(IModule[] module, IStatus status) {
        this.server.setModuleStatus(module, status);
    }

    public void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.info2 = info;
        IStatus status = this.publish(kind, monitor);
        if (status != null && status.getSeverity() != 0 && status.getSeverity() != 8) {
            throw new CoreException(status);
        }
    }

    private List<Integer> computeDelta(List<IModule[]> moduleList) {
        ArrayList<Integer> deltaKindList = new ArrayList<Integer>();
        for (IModule[] module : moduleList) {
            if (this.hasBeenPublished(module)) {
                IModule m = module[module.length - 1];
                if (m.getProject() != null && !m.getProject().isAccessible() || this.getPublishedResourceDelta(module).length == 0) {
                    deltaKindList.add(new Integer(0));
                    continue;
                }
                deltaKindList.add(new Integer(2));
                continue;
            }
            deltaKindList.add(new Integer(1));
        }
        this.addRemovedModules(moduleList, null);
        while (deltaKindList.size() < moduleList.size()) {
            deltaKindList.add(new Integer(3));
        }
        return deltaKindList;
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        MultiStatus tempMulti;
        block91: {
            long previousPublishActionTime;
            long publishStartTime;
            block89: {
                long currentTime;
                List<Integer> deltaKindList;
                List<IModule[]> moduleList;
                block88: {
                    String mainTaskMsg;
                    block87: {
                        PublishOperation[] tasks;
                        block86: {
                            if (Trace.FINEST) {
                                Trace.trace("/finest", "-->-- Publishing to server: " + this.getServer().toString() + " -->--");
                            }
                            if (this.getServer().getServerType().hasRuntime() && this.getServer().getRuntime() == null) {
                                return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishNoRuntime, null);
                            }
                            moduleList = this.getAllModules();
                            deltaKindList = this.computeDelta(moduleList);
                            tasks = this.getTasks(kind, moduleList, deltaKindList);
                            int size = 2000 + 3500 * moduleList.size() + 500 * tasks.length;
                            monitor = ProgressUtil.getMonitorFor(monitor);
                            mainTaskMsg = NLS.bind((String)Messages.publishing, (Object)this.getServer().getName());
                            monitor.beginTask(mainTaskMsg, size);
                            tempMulti = new MultiStatus("org.eclipse.wst.server.core", 0, "", null);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            previousPublishActionTime = publishStartTime = 0L;
                            if (Trace.PERFORMANCE) {
                                previousPublishActionTime = publishStartTime = System.currentTimeMillis();
                            }
                            if (Trace.PERFORMANCE) {
                                Trace.trace("/performance", "ServerBehaviourDelegate.publish(): start");
                            }
                            if (Trace.FINEST) {
                                Trace.trace("/finest", "Starting publish");
                            }
                            this.publishStart(ProgressUtil.getSubMonitorFor(monitor, 1000));
                            currentTime = 0L;
                            if (Trace.PERFORMANCE) {
                                currentTime = System.currentTimeMillis();
                                Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish start <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                                previousPublishActionTime = currentTime;
                            }
                            if (!monitor.isCanceled()) break block86;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            try {
                                this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                                if (Trace.PERFORMANCE) {
                                    long currentTime2 = System.currentTimeMillis();
                                    Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime2 - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                                    previousPublishActionTime = currentTime2;
                                }
                            }
                            catch (CoreException ce) {
                                if (Trace.INFO) {
                                    Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                                }
                                tempMulti.add(ce.getStatus());
                            }
                            catch (Exception e) {
                                if (Trace.SEVERE) {
                                    Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                                }
                                tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                            }
                            if (Trace.PERFORMANCE) {
                                Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                            }
                            return iStatus;
                        }
                        MultiStatus taskStatus = this.performTasks(tasks, monitor);
                        monitor.setTaskName(mainTaskMsg);
                        if (taskStatus != null && !taskStatus.isOK()) {
                            tempMulti.addAll((IStatus)taskStatus);
                        }
                        taskStatus = this.executePublishers(kind, moduleList, deltaKindList, monitor, this.info2);
                        if (Trace.PERFORMANCE) {
                            currentTime = System.currentTimeMillis();
                            Trace.trace("/performance", "ServerBehaviourDelegate.publish(): run publishers <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                            previousPublishActionTime = currentTime;
                        }
                        monitor.setTaskName(mainTaskMsg);
                        if (taskStatus != null && !taskStatus.isOK()) {
                            tempMulti.addAll((IStatus)taskStatus);
                        }
                        if (!monitor.isCanceled()) break block87;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        try {
                            this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                            if (Trace.PERFORMANCE) {
                                long currentTime3 = System.currentTimeMillis();
                                Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime3 - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                                previousPublishActionTime = currentTime3;
                            }
                        }
                        catch (CoreException ce) {
                            if (Trace.INFO) {
                                Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                            }
                            tempMulti.add(ce.getStatus());
                        }
                        catch (Exception e) {
                            if (Trace.SEVERE) {
                                Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                            }
                            tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                        }
                        if (Trace.PERFORMANCE) {
                            Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                        }
                        return iStatus;
                    }
                    this.publishServer(kind, ProgressUtil.getSubMonitorFor(monitor, 1000));
                    monitor.setTaskName(mainTaskMsg);
                    if (Trace.PERFORMANCE) {
                        currentTime = System.currentTimeMillis();
                        Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publisher server <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                        previousPublishActionTime = currentTime;
                    }
                    if (!monitor.isCanceled()) break block88;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    try {
                        this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                        if (Trace.PERFORMANCE) {
                            long currentTime4 = System.currentTimeMillis();
                            Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime4 - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                            previousPublishActionTime = currentTime4;
                        }
                    }
                    catch (CoreException ce) {
                        if (Trace.INFO) {
                            Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                        }
                        tempMulti.add(ce.getStatus());
                    }
                    catch (Exception e) {
                        if (Trace.SEVERE) {
                            Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                        }
                        tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                    }
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                    }
                    return iStatus;
                }
                this.publishModules(kind, moduleList, deltaKindList, tempMulti, monitor);
                if (Trace.PERFORMANCE) {
                    currentTime = System.currentTimeMillis();
                    Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish modules <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                    previousPublishActionTime = currentTime;
                }
                if (!monitor.isCanceled()) break block89;
                IStatus iStatus = Status.CANCEL_STATUS;
                try {
                    this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                    if (Trace.PERFORMANCE) {
                        long currentTime5 = System.currentTimeMillis();
                        Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime5 - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                        previousPublishActionTime = currentTime5;
                    }
                }
                catch (CoreException ce) {
                    if (Trace.INFO) {
                        Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                    }
                    tempMulti.add(ce.getStatus());
                }
                catch (Exception e) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                    }
                    tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                }
                if (Trace.PERFORMANCE) {
                    Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                }
                return iStatus;
            }
            try {
                monitor.done();
            }
            catch (CoreException ce) {
                if (Trace.INFO) {
                    Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                }
                IStatus iStatus = ce.getStatus();
                try {
                    this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                    if (Trace.PERFORMANCE) {
                        long currentTime = System.currentTimeMillis();
                        Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                        previousPublishActionTime = currentTime;
                    }
                }
                catch (CoreException ce2) {
                    if (Trace.INFO) {
                        Trace.trace("/info", "CoreException publishing to " + this.toString(), ce2);
                    }
                    tempMulti.add(ce2.getStatus());
                }
                catch (Exception e) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                    }
                    tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                }
                if (Trace.PERFORMANCE) {
                    Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                }
                return iStatus;
            }
            catch (Exception e) {
                try {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error publishing  to " + this.toString(), e);
                    }
                    tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
                    break block91;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                        if (Trace.PERFORMANCE) {
                            long currentTime = System.currentTimeMillis();
                            Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                            previousPublishActionTime = currentTime;
                        }
                    }
                    catch (CoreException ce) {
                        if (Trace.INFO) {
                            Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                        }
                        tempMulti.add(ce.getStatus());
                    }
                    catch (Exception e2) {
                        if (Trace.SEVERE) {
                            Trace.trace("/severe", "Error stopping publish to " + this.toString(), e2);
                        }
                        tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e2));
                    }
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
                    }
                }
            }
            try {
                this.publishFinish(ProgressUtil.getSubMonitorFor(monitor, 500));
                if (Trace.PERFORMANCE) {
                    long currentTime = System.currentTimeMillis();
                    Trace.trace("/performance", "ServerBehaviourDelegate.publish(): publish finish <" + (currentTime - previousPublishActionTime) + "> " + this.getServer().getServerType().getId());
                    previousPublishActionTime = currentTime;
                }
            }
            catch (CoreException ce) {
                if (Trace.INFO) {
                    Trace.trace("/info", "CoreException publishing to " + this.toString(), ce);
                }
                tempMulti.add(ce.getStatus());
            }
            catch (Exception e) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Error stopping publish to " + this.toString(), e);
                }
                tempMulti.add((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e));
            }
            if (Trace.PERFORMANCE) {
                Trace.trace("/performance", "ServerBehaviourDelegate.publish(): <" + (previousPublishActionTime - publishStartTime) + "> " + this.getServer().getServerType().getId());
            }
        }
        if (Trace.FINEST) {
            Trace.trace("/finest", "--<-- Done publishing --<--");
        }
        if (tempMulti.getChildren().length == 1) {
            return tempMulti.getChildren()[0];
        }
        MultiStatus multi = null;
        if (tempMulti.getSeverity() == 0) {
            return Status.OK_STATUS;
        }
        if (tempMulti.getSeverity() == 1) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusInfo, null);
        } else if (tempMulti.getSeverity() == 2) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusWarning, null);
        } else if (tempMulti.getSeverity() == 4) {
            multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.publishingStatusError, null);
        }
        if (multi != null) {
            multi.addAll((IStatus)tempMulti);
        }
        return multi;
    }

    protected IStatus publishModule(int kind, IModule[] module, int deltaKind, IProgressMonitor monitor) {
        if (Trace.FINEST) {
            Trace.trace("/finest", "-->-- Publishing module");
        }
        int size = module.length;
        IModule m = module[size - 1];
        if (Trace.FINEST) {
            Trace.trace("/finest", "Module: " + m);
        }
        monitor.beginTask(NLS.bind((String)Messages.publishingModule, (Object)m.getName()), 1000);
        try {
            this.publishModule(kind, deltaKind, module, monitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
            if (Trace.FINEST) {
                Trace.trace("/finest", "--<-- Done publishing module");
            }
        }
    }

    protected boolean hasBeenPublished(IModule[] module) {
        return this.server.getServerPublishInfo().hasModulePublishInfo(module);
    }

    protected void addRemovedModules(List<IModule[]> moduleList, List<Integer> kindList) {
        this.server.getServerPublishInfo().addRemovedModules(moduleList);
    }

    protected void updatePublishInfo(int deltaKind, IModule[] module) {
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        if (modules == null) {
            return;
        }
        int size = modules.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return;
            }
            IModule[] module = (IModule[])modules.get(i);
            IModule m = module[module.length - 1];
            if (!this.shouldIgnorePublishRequest(m)) {
                IStatus status;
                int kind2 = kind;
                if (this.getServer().getModulePublishState(module) == 0) {
                    kind2 = 2;
                }
                if ((status = this.publishModule(kind2, module, (Integer)deltaKind2.get(i), ProgressUtil.getSubMonitorFor(monitor, 3000))) != null && !status.isOK()) {
                    multi.add(status);
                }
            }
            ++i;
        }
    }

    protected boolean shouldIgnorePublishRequest(IModule m) {
        return m.getProject() != null && !m.getProject().isAccessible();
    }

    protected final PublishOperation[] getTasks(int kind, List moduleList, List kindList) {
        return this.server.getTasks(kind, moduleList, kindList);
    }

    protected MultiStatus executePublishers(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        return this.executePublishers(kind, modules, null, monitor, info);
    }

    protected MultiStatus executePublishers(int kind, List<IModule[]> modules, List<Integer> deltaKinds, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        Publisher[] publishers = ((Server)this.getServer()).getEnabledPublishers();
        int size = publishers.length;
        if (Trace.FINEST) {
            Trace.trace("/finest", "Executing publishers: " + size);
        }
        if (size == 0) {
            return null;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.taskPerforming, null);
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("server", this.getServer());
        taskModel.putObject("modules", modules);
        if (deltaKinds != null) {
            taskModel.putObject("deltaKinds", deltaKinds);
        }
        boolean publisherModifiedCode = false;
        int i = 0;
        while (i < size) {
            Publisher pub = publishers[i];
            monitor.subTask(NLS.bind((String)Messages.taskPerforming, (Object)pub.getName()));
            try {
                pub.setTaskModel(taskModel);
                IStatus pubStatus = pub.execute(kind, ProgressUtil.getSubMonitorFor(monitor, 500), info);
                if (!publisherModifiedCode) {
                    publisherModifiedCode = pub.isModifyModules();
                }
                multi.add(pubStatus);
            }
            catch (CoreException ce) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Publisher failed", ce);
                }
                throw ce;
            }
            if (monitor.isCanceled()) {
                return multi;
            }
            ++i;
        }
        if (publisherModifiedCode) {
            deltaKinds = this.computeDelta(modules);
        }
        monitor.subTask("");
        return multi;
    }

    protected final List<IModule[]> getAllModules() {
        return this.server.getAllModules();
    }

    protected MultiStatus performTasks(PublishOperation[] tasks, IProgressMonitor monitor) {
        int size = tasks.length;
        if (Trace.FINEST) {
            Trace.trace("/finest", "Performing tasks: " + size);
        }
        if (size == 0) {
            return null;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.wst.server.core", 0, Messages.taskPerforming, null);
        int i = 0;
        while (i < size) {
            PublishOperation task = tasks[i];
            monitor.subTask(NLS.bind((String)Messages.taskPerforming, (Object)task.toString()));
            try {
                task.execute(ProgressUtil.getSubMonitorFor(monitor, 500), null);
            }
            catch (CoreException ce) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Task failed", ce);
                }
                multi.add(ce.getStatus());
            }
            if (monitor.isCanceled()) {
                return multi;
            }
            ++i;
        }
        monitor.subTask("");
        return multi;
    }

    public void handleResourceChange() {
    }
}

