/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.db.DatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DTPDatabaseObjectWrapper<P extends DTPDatabaseObject>
implements DTPDatabaseObject {
    final P parent;
    private final ICatalogObjectListener catalogObjectListener;

    DTPDatabaseObjectWrapper(P parent) {
        this.parent = parent;
        if (this.getConnectionProfile().isConnected()) {
            this.catalogObjectListener = this.buildCatalogObjectListener();
            if (this.getConnectionProfile().hasAnyListeners()) {
                this.startListening();
            }
        } else {
            this.catalogObjectListener = null;
        }
    }

    @Override
    public String getIdentifier(String defaultName) {
        return this.getDTPDriverAdapter().convertNameToIdentifier(this.getName(), defaultName);
    }

    @Override
    public String getIdentifier() {
        return this.convertNameToIdentifier(this.getName());
    }

    String convertNameToIdentifier(String name) {
        return this.getDTPDriverAdapter().convertNameToIdentifier(name);
    }

    private ICatalogObjectListener buildCatalogObjectListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject dmElement, int eventType) {
                if (dmElement == DTPDatabaseObjectWrapper.this.getCatalogObject()) {
                    DTPDatabaseObjectWrapper.this.catalogObjectChanged();
                }
            }
        };
    }

    abstract ICatalogObject getCatalogObject();

    void catalogObjectChanged() {
        this.clear();
    }

    abstract void clear();

    void startListening() {
        this.checkListener();
        RefreshManager.getInstance().AddListener(this.getCatalogObject(), this.catalogObjectListener);
    }

    void stopListening() {
        this.checkListener();
        RefreshManager.getInstance().removeListener(this.getCatalogObject(), this.catalogObjectListener);
    }

    private void checkListener() {
        if (this.catalogObjectListener == null) {
            throw new IllegalStateException("the catalog listener is null");
        }
    }

    @Override
    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this.parent.getConnectionProfile();
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this.parent.getDatabase();
    }

    DTPDriverAdapter getDTPDriverAdapter() {
        return this.getDatabase().getDTPDriverAdapter();
    }

    <T extends DatabaseObject> T selectDatabaseObjectNamed(Iterable<T> databaseObjects, String name) {
        for (DatabaseObject databaseObject : databaseObjects) {
            if (!databaseObject.getName().equals(name)) continue;
            return (T)databaseObject;
        }
        return null;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }
}

