/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.IOrdered;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class ModuleFactory
implements IOrdered {
    private IConfigurationElement element;
    public ModuleFactoryDelegate delegate;
    private List<IModuleType> moduleTypes;
    private Expression fContextualLaunchExpr = null;

    public ModuleFactory(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            return Integer.parseInt(this.element.getAttribute("order"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public IModuleType[] getModuleTypes() {
        if (this.moduleTypes == null) {
            this.moduleTypes = ServerPlugin.getModuleTypes(this.element.getChildren("moduleType"));
        }
        IModuleType[] mt = new IModuleType[this.moduleTypes.size()];
        this.moduleTypes.toArray(mt);
        return mt;
    }

    public boolean isProjectModuleFactory() {
        return "true".equalsIgnoreCase(this.element.getAttribute("projects"));
    }

    public ModuleFactoryDelegate getDelegate(IProgressMonitor monitor) {
        block4: {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = (ModuleFactoryDelegate)this.element.createExecutableExtension("class");
                    InternalInitializer.initializeModuleFactoryDelegate(this.delegate, this, monitor);
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "ModuleFactory.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block4;
                    Trace.trace("/severe", "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public IModule[] getModules() {
        return this.getModules(null);
    }

    public IModule[] getModules(IProgressMonitor monitor) {
        try {
            IModule[] modules = this.getDelegate(monitor).getModules();
            if (this.hasInvalidModules(modules)) {
                modules = this.filter(modules);
            }
            return modules;
        }
        catch (Throwable t) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), t);
            }
            return new IModule[0];
        }
    }

    public IModule[] getModules(IProject project, IProgressMonitor monitor) {
        try {
            IModule[] modules = this.getDelegate(monitor).getModules(project);
            if (this.hasInvalidModules(modules)) {
                modules = this.filter(modules);
            }
            return modules;
        }
        catch (Throwable t) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), t);
            }
            return new IModule[0];
        }
    }

    protected Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.element.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements != null && elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    protected boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : true;
    }

    public boolean isEnabled(IProject project, IProgressMonitor monitor) {
        try {
            EvaluationContext context = new EvaluationContext(null, (Object)project);
            context.addVariable("project", (Object)project);
            return this.evalEnablementExpression((IEvaluationContext)context, this.getContextualLaunchEnablementExpression());
        }
        catch (Throwable t) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), t);
            }
            return false;
        }
    }

    public IModule findModule(String id, IProgressMonitor monitor) {
        IModule module;
        block6: {
            block5: {
                try {
                    module = this.getDelegate(monitor).findModule(id);
                    if (module != null) break block5;
                    return null;
                }
                catch (Throwable t) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "Error calling delegate " + this.toString(), t);
                    }
                    return null;
                }
            }
            this.getModuleTypes();
            if (this.moduleTypes.contains(module.getModuleType())) break block6;
            return null;
        }
        return module;
    }

    private boolean hasInvalidModules(IModule[] modules) {
        if (modules == null) {
            return false;
        }
        this.getModuleTypes();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            if (!this.moduleTypes.contains(modules[i].getModuleType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IModule[] filter(IModule[] modules) {
        if (modules == null) {
            return modules;
        }
        this.getModuleTypes();
        ArrayList<IModule> list = new ArrayList<IModule>();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            IModule m = modules[i];
            if (this.moduleTypes.contains(m.getModuleType())) {
                list.add(m);
            } else if (Trace.WARNING) {
                Trace.trace("/warning", "Invalid module returned from factory, ignored: " + m);
            }
            ++i;
        }
        IModule[] m = new IModule[list.size()];
        list.toArray(m);
        return m;
    }

    public String toString() {
        return "ModuleFactory[" + this.getId() + "]";
    }
}

