/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class StyleDeclItemFormatter
extends DefaultCSSSourceFormatter {
    private static StyleDeclItemFormatter instance;

    StyleDeclItemFormatter() {
    }

    private void appendAfterColonSpace(ICSSNode node, StringBuffer source) {
        int append;
        int length;
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        int n = preferences.getInt("postDelim");
        if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 8 || (length = this.getLastLineLength(node, source)) + n + (append = this.getFirstChildRegionLength(node)) <= preferences.getInt("lineWidth"))) {
            source.append(this.getLineDelimiter(node));
            source.append(this.getIndent(node));
            source.append(this.getIndentString());
            n = 0;
        }
        while (n-- > 0) {
            source.append(" ");
        }
    }

    private int getFirstChildRegionLength(ICSSNode node) {
        ICSSNode firstChild = node.getFirstChild();
        if (firstChild == null) {
            return 1;
        }
        int start = ((IndexedRegion)firstChild).getStartOffset();
        RegionIterator itr = new RegionIterator(node.getOwnerDocument().getModel().getStructuredDocument(), start);
        while (itr.hasNext()) {
            ITextRegion reg = itr.next();
            if (reg == null || reg.getType() == "S") continue;
            return reg.getTextLength();
        }
        return 1;
    }

    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        StringBuffer buf = new StringBuffer();
        if (node == null || attr == null) {
            return buf;
        }
        if (!"important".equalsIgnoreCase(attr.getName())) {
            return buf;
        }
        if (context != null && ((IndexedRegion)node).getEndOffset() > 0) {
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                ITextRegion prev;
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                RegionIterator it = new RegionIterator(flatNode, region);
                it.prev();
                context.start = it.hasPrev() ? ((prev = it.prev()).getType() == "S" ? it.getStructuredDocumentRegion().getStartOffset(prev) : it.getStructuredDocumentRegion().getStartOffset(region)) : it.getStructuredDocumentRegion().getStartOffset(region);
                context.end = it.getStructuredDocumentRegion().getEndOffset(region);
            } else {
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                if (region.getType() == "S") {
                    context.start = flatNode.getStartOffset(region);
                    context.end = flatNode.getEndOffset(region);
                } else {
                    context.start = flatNode.getEndOffset();
                    context.end = flatNode.getEndOffset();
                }
            }
        }
        if (insert && attr.getValue() != null && attr.getValue().length() > 0) {
            this.appendSpaceBefore(node, attr.getValue(), buf);
            buf.append(attr.getValue());
        }
        return buf;
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        int end;
        ICSSNode prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (start > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = null;
            regions = exceptFor == null ? this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy) : this.getRegions(structuredDocument, new FormatRegion(start, end - start), exceptFor, null);
            int i = 0;
            while (i < regions.length) {
                this.appendSpaceBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 2, stgy));
                ++i;
            }
        }
        if (child != null) {
            ITextRegion region;
            boolean append = true;
            if (child instanceof ICSSPrimitiveValue) {
                if (((ICSSPrimitiveValue)child).getPrimitiveType() == 32) {
                    toAppend = ",";
                } else if (((ICSSPrimitiveValue)child).getPrimitiveType() == 31) {
                    toAppend = "/";
                }
                ICSSNode prevSibling = child.getPreviousSibling();
                if (prevSibling instanceof ICSSPrimitiveValue) {
                    ITextRegion region2;
                    if (((ICSSPrimitiveValue)prevSibling).getPrimitiveType() == 31) {
                        append = false;
                    }
                    if (prevSibling instanceof CSSRegionContainer && (region2 = ((CSSRegionContainer)prevSibling).getFirstRegion()) != null && "UNKNOWN".equals(region2.getType())) {
                        append = false;
                    }
                }
            }
            if (child instanceof CSSRegionContainer && (region = ((CSSRegionContainer)child).getFirstRegion()) != null && "UNKNOWN".equals(region.getType())) {
                append = false;
            }
            if (toAppend != null && !toAppend.equals(",") && !toAppend.equals("/") && !toAppend.equals(")") && append) {
                this.appendSpaceBefore(node, toAppend, source);
            }
        }
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleDeclItemFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 2, stgy));
            ++i;
        }
        if (StyleDeclItemFormatter.needS(outside[1]) && ((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength() && toAppend != "," && toAppend != "/") {
            this.appendSpaceBefore(node, toAppend, source);
        }
    }

    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                this.appendSpaceBefore(node, regions[i], source);
                source.append(this.decoratedIdentRegion(regions[i], stgy));
                ++i;
            }
        } else {
            String priority = ((ICSSStyleDeclItem)node).getPriority();
            if (priority != null && priority.length() > 0) {
                this.appendSpaceBefore(node, priority, source);
                source.append(priority);
            }
        }
    }

    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleDeclItemFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
    }

    protected void formatPre(ICSSNode node, StringBuffer source) {
        int start = ((IndexedRegion)node).getStartOffset();
        int end = node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getFirstChild()).getStartOffset() : this.getChildInsertPos(node);
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (end > 0) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedPropNameRegion(regions[i], stgy));
                ++i;
            }
        } else {
            int append;
            int length;
            ICSSStyleDeclItem item = (ICSSStyleDeclItem)node;
            if (preferences.getInt("propNameCase") == 2) {
                source.append(item.getPropertyName().toUpperCase());
            } else {
                source.append(item.getPropertyName());
            }
            int k = preferences.getInt("preDelim");
            if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 8 || (length = this.getLastLineLength(node, source)) + k + (append = 1) <= preferences.getInt("lineWidth"))) {
                source.append(this.getLineDelimiter(node));
                source.append(this.getIndent(node));
                source.append(this.getIndentString());
                k = 0;
            }
            while (k-- > 0) {
                source.append(" ");
            }
            source.append(":");
        }
        if (node.getFirstChild() != null && (!StyleDeclItemFormatter.isCleanup() || this.getCleanupStrategy(node).isFormatSource())) {
            this.appendAfterColonSpace(node, source);
        }
    }

    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleDeclItemFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropNameRegion(regions[i], stgy));
            ++i;
        }
        if (StyleDeclItemFormatter.needS(outside[1])) {
            if (this.isIncludesPreEnd(node, region) && (!StyleDeclItemFormatter.isCleanup() || this.getCleanupStrategy(node).isFormatSource())) {
                this.appendAfterColonSpace(node, source);
            } else {
                this.appendSpaceBefore(node, outside[1], source);
            }
        }
    }

    public StringBuffer formatValue(ICSSNode node) {
        StringBuffer source = new StringBuffer();
        this.formatChildren(node, source);
        return source;
    }

    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        if (!"important".equalsIgnoreCase(attrName)) {
            return -1;
        }
        ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("important");
        if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
            return ((IndexedRegion)attr).getStartOffset();
        }
        IndexedRegion iNode = (IndexedRegion)node;
        if (iNode.getEndOffset() <= 0) {
            return -1;
        }
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(node.getOwnerDocument().getModel().getStructuredDocument(), new FormatRegion(iNode.getStartOffset(), iNode.getEndOffset() - iNode.getStartOffset()), this.getCleanupStrategy(node));
        int i = regions.length - 1;
        while (i >= 0) {
            if (regions[i].getType() == "CSS_DECLARATION_VALUE_IMPORTANT") {
                return regions[i].getStartOffset();
            }
            --i;
        }
        return iNode.getEndOffset();
    }

    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n < 0) {
            return -1;
        }
        IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
        if (flatNode != null && flatNode.getType() == "DECLARATION_DELIMITER") {
            n -= flatNode.getLength();
        }
        if (n > 0) {
            ITextRegion region;
            String important = ((ICSSStyleDeclItem)node).getPriority();
            if (important != null && important.length() > 0) {
                flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
                RegionIterator it = new RegionIterator(flatNode, flatNode.getRegionAtCharacterOffset(n - 1));
                while (it.hasPrev()) {
                    ITextRegion region2 = it.prev();
                    if (it.getStructuredDocumentRegion() != flatNode) break;
                    if (region2.getType() != "CSS_DECLARATION_VALUE_IMPORTANT") continue;
                    return it.getStructuredDocumentRegion().getStartOffset(region2);
                }
            }
            if ((region = (flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1)).getRegionAtCharacterOffset(n - 1)) != null) {
                n -= region.getLength() - region.getTextLength();
            }
            return n;
        }
        return -1;
    }

    public static synchronized StyleDeclItemFormatter getInstance() {
        if (instance == null) {
            instance = new StyleDeclItemFormatter();
        }
        return instance;
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }
}

