/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPMessageHandlers;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class HandlerChainRules
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(HandlerChain.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            AnnotationMirror annotationMirror;
            if (declaration instanceof TypeDeclaration && (annotationMirror = AnnotationUtils.getAnnotation((Declaration)declaration, SOAPMessageHandlers.class)) != null) {
                this.printFixableError(annotationMirror.getPosition(), JAXWSCoreMessages.HANDLER_CHAIN_SOAP_MESSAGE_HANDLERS);
            }
            if (declaration instanceof FieldDeclaration) {
                annotationMirror = AnnotationUtils.getAnnotation((Declaration)declaration, HandlerChain.class);
                this.printError(annotationMirror.getPosition(), JAXWSCoreMessages.HANDLER_CHAIN_ON_FIELD);
            }
            if (!(declaration instanceof MethodDeclaration)) continue;
            annotationMirror = AnnotationUtils.getAnnotation((Declaration)declaration, HandlerChain.class);
            this.printError(annotationMirror.getPosition(), JAXWSCoreMessages.HANDLER_CHAIN_ON_METHOD);
        }
    }
}

