/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetDelegateUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetException;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetUninstallConfig;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSJ2EEUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSJEEUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JAXRSFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            boolean isDynamicWebProject = JAXRSFacetDelegateUtils.isDynamicWebProject(project);
            if (isDynamicWebProject) {
                IModelProvider provider = JAXRSUtils.getModelProvider(project);
                if (provider == null) {
                    throw new JAXRSFacetException(NLS.bind((String)Messages.JAXRSFacetUninstallDelegate_ConfigErr, (Object)project.getName()));
                }
                if (!provider.validateEdit(null, null).isOK()) {
                    throw new JAXRSFacetException(NLS.bind((String)Messages.JAXRSFacetUninstallDelegate_NonUpdateableWebXML, (Object)project.getName()));
                }
            }
            ((JAXRSFacetUninstallConfig)((Object)config)).getLibrariesUninstallDelegate().execute(null);
            if (isDynamicWebProject) {
                this.uninstallJAXRSReferencesFromWebApp(project, monitor);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void uninstallJAXRSReferencesFromWebApp(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = JAXRSUtils.getModelProvider(project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            IPath ddPath = new Path("WEB-INF").append("web.xml");
            if (JAXRSJEEUtils.isWebApp25or30(webAppObj)) {
                WebApp webApp = (WebApp)webAppObj;
                org.eclipse.jst.javaee.web.Servlet servlet = JAXRSJEEUtils.findJAXRSServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJAXRSFromJavaEEWebAppOperation(project), ddPath);
            } else {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                Servlet servlet = JAXRSJ2EEUtils.findJAXRSServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJAXRSFromJ2EEWebAppOperation(project), ddPath);
            }
        }
    }

    static class RemoveJAXRSFromJ2EEWebAppOperation
    implements Runnable {
        private IProject _project;

        RemoveJAXRSFromJ2EEWebAppOperation(IProject project) {
            this._project = project;
        }

        public void run() {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            Servlet servlet = JAXRSJ2EEUtils.findJAXRSServlet(webApp);
            JAXRSJ2EEUtils.removeURLMappings(webApp, servlet);
            this.removeJAXRSServlet(webApp, servlet);
        }

        private void removeJAXRSServlet(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            webApp.getServlets().remove((Object)servlet);
        }
    }

    static class RemoveJAXRSFromJavaEEWebAppOperation
    implements Runnable {
        private IProject _project;

        RemoveJAXRSFromJavaEEWebAppOperation(IProject project) {
            this._project = project;
        }

        public void run() {
            WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            org.eclipse.jst.javaee.web.Servlet servlet = JAXRSJEEUtils.findJAXRSServlet(webApp);
            JAXRSJEEUtils.removeURLMappings(webApp, servlet);
            this.removeJAXRSServlet(webApp, servlet);
        }

        private void removeJAXRSServlet(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            webApp.getServlets().remove(servlet);
        }
    }
}

