/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.internal.project.facet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrslibraryconfig.JAXRSLibraryInternalReference;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig.SharedLibraryConfigurator;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrssharedlibraryconfig.SharedLibraryConfiguratorUtil;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetDelegateUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetException;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSJEEUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.UpdateWebXMLForJ2EE;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.UpdateWebXMLForJavaEE;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JAXRSFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel config = null;
            if (cfg == null) {
                throw new JAXRSFacetException(Messages.JAXRSFacetInstallDelegate_InternalErr);
            }
            config = (IDataModel)cfg;
            boolean isDynamicWebProject = JAXRSFacetDelegateUtils.isDynamicWebProject(project);
            if (isDynamicWebProject) {
                IModelProvider provider = JAXRSUtils.getModelProvider(project);
                if (provider == null) {
                    throw new JAXRSFacetException(NLS.bind((String)Messages.JAXRSFacetInstallDelegate_ConfigErr, (Object)project.getName()));
                }
                if (!provider.validateEdit(null, null).isOK() && !provider.validateEdit(null, null).isOK()) {
                    throw new JAXRSFacetException(NLS.bind((String)Messages.JAXRSFacetInstallDelegate_NonUpdateableWebXML, (Object)project.getName()));
                }
            }
            if (((LibraryInstallDelegate)config.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).getLibraryProviderOperationConfig() instanceof JAXRSUserLibraryProviderInstallOperationConfig || config.getProperty("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION") != null && Boolean.parseBoolean(config.getProperty("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION").toString()) || config.getProperty("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION") != null && !Boolean.parseBoolean(config.getProperty("IJAXRSFacetInstallDataModelProperties.DEPLOY_IMPLEMENTATION").toString()) && (config.getProperty("IJAXRSFacetInstallDataModelProperties.SHAREDLIBRARY") == null || config.getProperty("IJAXRSFacetInstallDataModelProperties.SHAREDLIBRARY") != null && !Boolean.parseBoolean(config.getProperty("IJAXRSFacetInstallDataModelProperties.SHAREDLIBRARY").toString()))) {
                ((LibraryInstallDelegate)config.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
            } else {
                ((LibraryInstallDelegate)config.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
                if (!this.disableLibraryConfigSelected((LibraryInstallDelegate)config.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE"))) {
                    this.createSharedLibraries(project, fv, monitor, config);
                }
            }
            if (isDynamicWebProject && config.getBooleanProperty("IJAXRSFacetInstallDataModelProperties.UPDATEDD")) {
                this.createServletAndModifyWebXML(project, config, monitor);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean disableLibraryConfigSelected(LibraryInstallDelegate property) {
        return property.getLibraryProvider().getId() != null && property.getLibraryProvider().getId().equals("jaxrs-no-op-library-provider");
    }

    private void createSharedLibraries(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor, IDataModel config) throws CoreException {
        String targetRuntimeID = config.getStringProperty("IJAXRSFacetInstallDataModelProperties.TARGETRUNTIME");
        SharedLibraryConfiguratorUtil.getInstance();
        List<SharedLibraryConfigurator> configurators = SharedLibraryConfiguratorUtil.getConfigurators();
        ILibraryProvider libref = ((LibraryInstallDelegate)config.getProperty("IJAXRSFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).getLibraryProvider();
        for (SharedLibraryConfigurator thisConfigurator : configurators) {
            if (!targetRuntimeID.equals(thisConfigurator.getRuntimeID())) continue;
            IProject earProject = this.getEARProject(config);
            Boolean addToEar = this.getAddToEar(config);
            List earProjects = (List)config.getProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECTS");
            if (earProjects != null) {
                for (IProject ear : earProjects) {
                    if (!thisConfigurator.getIsSharedLibSupported(project, ear, addToEar, libref.getId())) continue;
                    thisConfigurator.installSharedLibs(project, ear, monitor, new ArrayList<String>());
                }
                continue;
            }
            if (!thisConfigurator.getIsSharedLibSupported(project, earProject, addToEar, libref.getId())) continue;
            thisConfigurator.installSharedLibs(project, earProject, monitor, new ArrayList<String>());
            break;
        }
    }

    private IClasspathEntry getNewCPEntry(IPath path, JAXRSLibraryInternalReference lib) {
        IClasspathEntry entry = null;
        if (lib.isCheckedToBeDeployed()) {
            IClasspathAttribute depAttrib = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
            entry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])new IClasspathAttribute[]{depAttrib}, (boolean)true);
        } else {
            entry = JavaCore.newContainerEntry((IPath)path);
        }
        return entry;
    }

    private void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor) {
        IModelProvider provider = JAXRSUtils.getModelProvider(project);
        IPath webXMLPath = new Path("WEB-INF").append("web.xml");
        if (JAXRSJEEUtils.isWebApp25or30(provider.getModelObject())) {
            provider.modify((Runnable)new UpdateWebXMLForJavaEE(project, config), this.doesDDFileExist(project, webXMLPath) ? webXMLPath : IModelProvider.FORCESAVE);
        } else {
            provider.modify((Runnable)new UpdateWebXMLForJ2EE(project, config), webXMLPath);
        }
    }

    private boolean doesDDFileExist(IProject project, IPath webXMLPath) {
        return project.getProjectRelativePath().append(webXMLPath).toFile().exists();
    }

    private IProject getEARProject(IDataModel config) {
        String projName = config.getStringProperty("IJAXRSFacetInstallDataModelProperties.EARPROJECT_NAME");
        if (projName == null || "".equals(projName)) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return project;
    }

    private boolean getAddToEar(IDataModel config) {
        return config.getBooleanProperty("IJAXRSFacetInstallDataModelProperties.ADD_TO_EAR");
    }
}

