/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;

    public LocalVariableBinding(char[] name, TypeBinding type, int modifiers, boolean isArgument) {
        super(name, type, modifiers);
        if (isArgument) {
            this.tagBits |= 0x400L;
        }
    }

    public LocalVariableBinding(LocalDeclaration declaration, TypeBinding type, int modifiers, boolean isArgument) {
        this(declaration.name, type != null ? type : TypeBinding.UNKNOWN, modifiers, isArgument);
        this.declaration = declaration;
    }

    @Override
    public final int kind() {
        return 2;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuffer buffer = new StringBuffer();
        BlockScope scope = this.declaringScope;
        if (scope != null) {
            if (scope instanceof CompilationUnitScope) {
                CompilationUnitScope compilationUnitScope = (CompilationUnitScope)scope;
                buffer.append(compilationUnitScope.referenceContext.compilationUnitBinding.computeUniqueKey(false));
            } else {
                CompilationUnitBinding compilationUnitBinding;
                ReferenceContext referenceContext = null;
                MethodScope methodScope = scope instanceof MethodScope ? (MethodScope)scope : scope.enclosingMethodScope();
                referenceContext = methodScope != null ? methodScope.referenceContext : scope.enclosingCompilationUnit().scope.referenceCompilationUnit();
                if (referenceContext instanceof AbstractMethodDeclaration) {
                    MethodBinding methodBinding = ((AbstractMethodDeclaration)referenceContext).getBinding();
                    if (methodBinding != null) {
                        buffer.append(methodBinding.computeUniqueKey(false));
                    }
                } else if (referenceContext instanceof TypeDeclaration) {
                    SourceTypeBinding typeBinding = ((TypeDeclaration)referenceContext).binding;
                    if (typeBinding != null) {
                        buffer.append(((Binding)typeBinding).computeUniqueKey(false));
                    }
                } else if (referenceContext instanceof CompilationUnitDeclaration && (compilationUnitBinding = ((CompilationUnitDeclaration)referenceContext).compilationUnitBinding) != null) {
                    buffer.append(compilationUnitBinding.computeUniqueKey(false));
                }
            }
            this.getScopeKey(scope, buffer);
        }
        buffer.append('#');
        buffer.append(this.name);
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    private void getScopeKey(BlockScope scope, StringBuffer buffer) {
        int scopeIndex = scope.scopeIndex();
        if (scopeIndex != -1) {
            this.getScopeKey((BlockScope)scope.parent, buffer);
            buffer.append('#');
            buffer.append(scopeIndex);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && (this.tagBits & 0x400L) == 0L;
    }

    public final boolean isSameCompilationUnit(Scope scope) {
        return this.declaringScope.compilationUnitScope() == scope;
    }

    public void recordInitializationEndPC(int pc) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = pc;
        }
    }

    public void recordInitializationStartPC(int pc) {
        int index;
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0) {
            int previousEndPC = this.initializationPCs[(this.initializationCount - 1 << 1) + 1];
            if (previousEndPC == -1) {
                return;
            }
            if (previousEndPC == pc) {
                this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
                return;
            }
        }
        if ((index = this.initializationCount << 1) == this.initializationPCs.length) {
            this.initializationPCs = new int[this.initializationCount << 2];
            System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, index);
        }
        this.initializationPCs[index] = pc;
        this.initializationPCs[index + 1] = -1;
        ++this.initializationCount;
    }

    @Override
    public boolean isFor(AbstractVariableDeclaration variableDeclaration) {
        return variableDeclaration.equals(this.declaration);
    }

    @Override
    public String toString() {
        String s = super.toString();
        switch (this.useFlag) {
            case 1: {
                s = String.valueOf(s) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                s = String.valueOf(s) + "[pos: unused]";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "[pos: fake_used]";
            }
        }
        s = String.valueOf(s) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            s = String.valueOf(s) + "[pc: ";
            int i = 0;
            while (i < this.initializationCount) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + String.valueOf(this.initializationPCs[i << 1]) + "-" + (this.initializationPCs[(i << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(i << 1) + 1]));
                ++i;
            }
            s = String.valueOf(s) + "]";
        }
        return s;
    }
}

