/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.SystemWorkWithHistoryDialog;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.widgets.ISystemCombo;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SystemHistoryCombo
extends Composite
implements ISystemCombo,
TraverseListener,
KeyListener {
    private Combo historyCombo = null;
    private Button historyButton = null;
    private String historyKey = null;
    private String[] defaultHistory;
    private boolean readonly = false;
    private boolean autoUppercase = false;
    private int maxComboEntries;
    private static final int DEFAULT_MAX_COMBO_ENTRIES = 20;
    private static final int DEFAULT_COMBO_WIDTH = 100;
    private static final int DEFAULT_BUTTON_WIDTH = 13;
    private static final int DEFAULT_MARGIN = 1;

    public SystemHistoryCombo(Composite parent, int style, String key, boolean readonly) {
        this(parent, style, key, 20, readonly);
    }

    public SystemHistoryCombo(Composite parent, int style, String key, int maxComboEntries, boolean readonly) {
        super(parent, style);
        this.historyKey = key;
        this.readonly = readonly;
        this.prepareComposite(2);
        this.historyCombo = SystemHistoryCombo.createCombo(this, readonly);
        this.historyCombo.addKeyListener((KeyListener)this);
        this.maxComboEntries = maxComboEntries;
        this.createHistoryButton();
        String[] history = this.getHistory();
        if (history != null && history.length > 0) {
            this.setItems(history);
        }
        this.addOurButtonSelectionListener();
    }

    public Combo getCombo() {
        return this.historyCombo;
    }

    public void setWidthHint(int widthHint) {
        ((GridData)this.getLayoutData()).widthHint = widthHint + 13 + 1;
    }

    public void setAutoUpperCase(boolean enable) {
        this.autoUppercase = enable;
    }

    public Button getHistoryButton() {
        return this.historyButton;
    }

    public void setText(String text) {
        if (!this.readonly) {
            this.historyCombo.setText(text);
            this.updateHistory();
        } else {
            int selIdx = -1;
            String[] currentItems = this.historyCombo.getItems();
            String[] newItems = new String[currentItems.length + 1];
            newItems[0] = text;
            int idx = 0;
            while (selIdx == -1 && idx < currentItems.length) {
                if (text.equals(currentItems[idx])) {
                    selIdx = idx;
                } else {
                    newItems[idx + 1] = currentItems[idx];
                }
                ++idx;
            }
            if (selIdx == -1) {
                this.setItems(newItems);
                selIdx = currentItems.length;
                SystemPreferencesManager.setWidgetHistory(this.historyKey, newItems);
            }
            if (selIdx >= 0) {
                this.historyCombo.select(selIdx);
            }
        }
    }

    public String getText() {
        return this.historyCombo.getText();
    }

    public void setEnabled(boolean enabled) {
        this.historyCombo.setEnabled(enabled);
        this.historyButton.setEnabled(enabled);
    }

    public void setToolTipText(String tip) {
        this.historyCombo.setToolTipText(tip);
    }

    public void setHistoryButtonToolTipText(String tip) {
        this.historyButton.setToolTipText(tip);
    }

    public void setButtonToolTipText(String tip) {
        this.historyButton.setToolTipText(tip);
    }

    public void setTextLimit(int limit) {
        this.historyCombo.setTextLimit(limit);
    }

    public boolean setFocus() {
        return this.historyCombo.setFocus();
    }

    public void setItems(String[] items) {
        if (items != null && items.length > this.maxComboEntries) {
            String[] historySubSet = new String[this.maxComboEntries];
            System.arraycopy(items, 0, historySubSet, 0, this.maxComboEntries);
            this.historyCombo.setItems(historySubSet);
        } else {
            this.historyCombo.setItems(items);
        }
    }

    public void setDefaultHistory(String[] items) {
        this.defaultHistory = items;
        if (this.historyCombo.getItemCount() == 0) {
            this.setItems(items);
            SystemPreferencesManager.setWidgetHistory(this.historyKey, items);
        }
    }

    public void setHistoryKey(String key) {
        this.historyKey = key;
        String[] history = this.getHistory();
        if (history != null && history.length > 0) {
            this.setItems(history);
        } else {
            this.historyCombo.removeAll();
        }
    }

    public String[] getItems() {
        return this.historyCombo.getItems();
    }

    public void select(int selIdx) {
        if (selIdx >= this.historyCombo.getItemCount()) {
            return;
        }
        this.historyCombo.deselectAll();
        this.historyCombo.select(selIdx);
        this.historyCombo.clearSelection();
        Event e = new Event();
        this.historyCombo.notifyListeners(13, e);
    }

    public int select(String itemText) {
        String[] items = this.historyCombo.getItems();
        int matchIdx = -1;
        if (items == null || items.length == 0) {
            return matchIdx;
        }
        int idx = 0;
        while (matchIdx == -1 && idx < items.length) {
            if (itemText.equals(items[idx])) {
                matchIdx = idx;
            }
            ++idx;
        }
        if (matchIdx != -1) {
            this.select(matchIdx);
        }
        return matchIdx;
    }

    public void setSelectionIndex(int selIdx) {
        this.select(selIdx);
    }

    public void clearSelection() {
        this.historyCombo.clearSelection();
        this.historyCombo.deselectAll();
    }

    public void clearTextSelection() {
        String text = this.historyCombo.getText();
        this.historyCombo.deselectAll();
        this.historyCombo.setText(text);
    }

    public int getSelectionIndex() {
        return this.historyCombo.getSelectionIndex();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.historyCombo.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.historyCombo.removeSelectionListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.historyCombo.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.historyCombo.removeModifyListener(listener);
    }

    public String[] getHistory() {
        return SystemPreferencesManager.getWidgetHistory(this.historyKey);
    }

    public void updateHistory() {
        this.updateHistory(false);
    }

    public void updateHistory(boolean refresh) {
        String textValue = this.historyCombo.getText().trim();
        if (!(!this.autoUppercase || textValue.startsWith("\"") && textValue.endsWith("\""))) {
            textValue = textValue.toUpperCase();
        }
        boolean alreadyThere = false;
        String[] newHistory = null;
        if (textValue.length() > 0) {
            String[] currentHistory = this.historyCombo.getItems();
            if (currentHistory.length > 0) {
                if (!textValue.equals(currentHistory[0])) {
                    alreadyThere = false;
                    int idx = 0;
                    while (!alreadyThere && idx < currentHistory.length) {
                        if (textValue.equals(currentHistory[idx])) {
                            alreadyThere = true;
                        }
                        ++idx;
                    }
                    newHistory = alreadyThere ? new String[currentHistory.length] : new String[currentHistory.length >= this.maxComboEntries ? this.maxComboEntries : currentHistory.length + 1];
                    newHistory[0] = textValue;
                    int idx2 = 1;
                    int idx3 = 0;
                    while (idx3 < currentHistory.length && idx2 < newHistory.length) {
                        if (!textValue.equals(currentHistory[idx3])) {
                            newHistory[idx2] = currentHistory[idx3];
                            ++idx2;
                        }
                        ++idx3;
                    }
                    SystemPreferencesManager.setWidgetHistory(this.historyKey, newHistory);
                }
            } else {
                newHistory = new String[]{textValue};
                SystemPreferencesManager.setWidgetHistory(this.historyKey, newHistory);
            }
            if (refresh && newHistory != null) {
                this.setItems(newHistory);
                this.setText(textValue);
            }
        }
    }

    public void setHistory(String[] newHistory) {
        SystemPreferencesManager.setWidgetHistory(this.historyKey, newHistory);
    }

    protected Composite prepareComposite(int numColumns) {
        SystemHistoryCombo composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 114;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData(data);
        return composite;
    }

    public static Combo createCombo(Composite parent, boolean readonly) {
        Combo combo = null;
        combo = !readonly ? new Combo(parent, 4) : new Combo(parent, 12);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected void addOurButtonSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemHistoryCombo.this.historyButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        };
        this.historyButton.addSelectionListener((SelectionListener)selectionListener);
    }

    protected void historyButtonPressed() {
        SystemWorkWithHistoryDialog dlg = new SystemWorkWithHistoryDialog(this.getShell(), this.getHistory());
        if (this.defaultHistory != null) {
            dlg.setDefaultHistory(this.defaultHistory);
        }
        dlg.setBlockOnOpen(true);
        dlg.open();
        if (!dlg.wasCancelled()) {
            String value = this.historyCombo.getText();
            String[] newHistory = dlg.getHistory();
            SystemPreferencesManager.setWidgetHistory(this.historyKey, newHistory);
            this.setItems(newHistory);
            this.historyCombo.setText(value);
        }
    }

    protected Button createHistoryButton() {
        boolean isDrawn = System.getProperty("os.name").toLowerCase().startsWith("win");
        if (isDrawn) {
            this.historyButton = new Button((Composite)this, 8);
            Display display = this.getDisplay();
            final Image upArrow = new Image((Device)display, 5, 6);
            GC gc = new GC((Drawable)upArrow);
            gc.setBackground(this.historyButton.getBackground());
            gc.fillRectangle(upArrow.getBounds());
            gc.setForeground(this.historyButton.getForeground());
            gc.drawLine(0, 5, 4, 5);
            gc.drawLine(0, 4, 4, 4);
            gc.drawLine(1, 3, 3, 3);
            gc.drawLine(1, 2, 3, 2);
            gc.drawLine(2, 1, 2, 1);
            gc.drawLine(2, 0, 2, 0);
            gc.dispose();
            this.historyButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    upArrow.dispose();
                }
            });
            this.historyButton.setImage(upArrow);
        } else {
            this.historyButton = new Button((Composite)this, 4);
            this.historyButton.setAlignment(128);
        }
        this.historyButton.setToolTipText(SystemResources.RESID_WORKWITHHISTORY_BUTTON_TIP);
        this.historyButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = "";
            }

            public void getName(AccessibleEvent e) {
                e.result = SystemHistoryCombo.this.historyButton.getToolTipText();
                String prefix = null;
                Composite parent = SystemHistoryCombo.this.historyButton.getParent();
                while (parent != null && prefix == null) {
                    if (parent instanceof Group) {
                        Group group = (Group)parent;
                        prefix = group.getText();
                    }
                    parent = parent.getParent();
                }
                if (prefix != null) {
                    e.result = String.valueOf(prefix) + " " + e.result;
                }
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 13;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 20;
        this.historyButton.setLayoutData((Object)data);
        return this.historyButton;
    }

    public void setHistoryButtonHeight(int height) {
        ((GridData)this.historyButton.getLayoutData()).heightHint = height;
        ((GridData)this.historyButton.getLayoutData()).grabExcessVerticalSpace = false;
        ((GridData)this.historyButton.getLayoutData()).verticalAlignment = 2;
    }

    public void keyTraversed(TraverseEvent e) {
        int detail = e.detail;
        String s = "unknown";
        switch (detail) {
            case 64: {
                s = "Arrow Next";
                break;
            }
            case 32: {
                s = "Arrow Previous";
                break;
            }
            case 2: {
                s = "Escape";
                break;
            }
            case 4: {
                s = "Return";
                break;
            }
            case 16: {
                s = "Tab Next";
                this.historyButton.forceFocus();
                break;
            }
            case 8: {
                s = "Tab Previous";
            }
        }
        System.out.println("keyTraversed: " + s);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.stateMask == 262144 && e.keyCode == 0x1000001) {
            this.historyButtonPressed();
        }
    }
}

