/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.preferences.LanguageConfigurationContentProvider;
import org.eclipse.tm4e.languageconfiguration.internal.preferences.LanguageConfigurationLabelProvider;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.WorkingCopyLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.ColumnViewerComparator;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.LanguageConfigurationPreferencesWidget;
import org.eclipse.tm4e.languageconfiguration.internal.wizards.LanguageConfigurationImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.languageconfiguration.preferences.LanguageConfigurationPreferencePage";
    private final ILanguageConfigurationRegistryManager manager = new WorkingCopyLanguageConfigurationRegistryManager(LanguageConfigurationRegistryManager.getInstance());
    private @Nullable TableViewer definitionViewer;
    private @Nullable LanguageConfigurationPreferencesWidget infoWidget;

    public LanguageConfigurationPreferencePage() {
        this.setDescription(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_description);
    }

    protected Control createContents(@Nullable Composite ancestor) {
        LanguageConfigurationPreferencesWidget infoWidget;
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        this.createDefinitionsListContent(parent);
        assert (this.definitionViewer != null);
        this.definitionViewer.setInput((Object)this.manager);
        this.infoWidget = infoWidget = new LanguageConfigurationPreferencesWidget(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        infoWidget.setLayoutData(data);
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private void createDefinitionsListContent(Composite parent) {
        TableViewer definitionViewer;
        Label description = new Label(parent, 0);
        description.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_description2);
        description.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        ColumnViewerComparator viewerComparator = new ColumnViewerComparator();
        this.definitionViewer = definitionViewer = new TableViewer(table);
        int i = 0;
        while (i < 4) {
            TableColumn column = new TableColumn(table, 0);
            String label = switch (i) {
                case 0 -> LanguageConfigurationMessages.LanguageConfigurationPreferencePage_contentTypeName;
                case 1 -> LanguageConfigurationMessages.LanguageConfigurationPreferencePage_contentTypeId;
                case 2 -> LanguageConfigurationMessages.LanguageConfigurationPreferencePage_pluginId;
                case 3 -> LanguageConfigurationMessages.LanguageConfigurationPreferencePage_path;
                default -> throw new IllegalArgumentException("Unexpected value: " + i);
            };
            column.setText(label);
            int minWidth = this.computeMinimumColumnWidth(gc, label);
            columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
            column.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column, definitionViewer, i, viewerComparator));
            if (i == 0) {
                table.setSortColumn(column);
                table.setSortDirection(viewerComparator.getDirection());
            }
            ++i;
        }
        gc.dispose();
        definitionViewer.setLabelProvider((IBaseLabelProvider)new LanguageConfigurationLabelProvider());
        definitionViewer.setContentProvider((IContentProvider)new LanguageConfigurationContentProvider());
        definitionViewer.setComparator((ViewerComparator)viewerComparator);
        BidiUtils.applyTextDirection((Control)definitionViewer.getControl(), (String)"default");
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button definitionNewButton = new Button(buttons, 8);
        definitionNewButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_new);
        definitionNewButton.setLayoutData((Object)new GridData(768));
        definitionNewButton.addListener(13, new Listener(){

            public void handleEvent(@Nullable Event e) {
                this.add();
            }

            private void add() {
                LanguageConfigurationImportWizard wizard = new LanguageConfigurationImportWizard(false);
                wizard.setRegistryManager(LanguageConfigurationPreferencePage.this.manager);
                WizardDialog dialog = new WizardDialog(LanguageConfigurationPreferencePage.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ILanguageConfigurationDefinition created = wizard.getCreatedDefinition();
                    definitionViewer.refresh();
                    definitionViewer.setSelection((ISelection)new StructuredSelection((Object)created));
                }
            }
        });
        final Button definitionRemoveButton = new Button(buttons, 8);
        definitionRemoveButton.setText(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_remove);
        definitionRemoveButton.setLayoutData((Object)new GridData(768));
        definitionRemoveButton.addListener(13, new Listener(){

            public void handleEvent(@Nullable Event e) {
                this.remove();
            }

            private void remove() {
                Collection<ILanguageConfigurationDefinition> definitions = LanguageConfigurationPreferencePage.this.getSelectedUserDefinitions(definitionViewer);
                if (!definitions.isEmpty()) {
                    for (ILanguageConfigurationDefinition definition : definitions) {
                        LanguageConfigurationPreferencePage.this.manager.unregisterLanguageConfigurationDefinition(definition);
                    }
                    definitionViewer.refresh();
                }
            }
        });
        definitionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent e) {
                IStructuredSelection selection = definitionViewer.getStructuredSelection();
                if (!$assertionsDisabled && LanguageConfigurationPreferencePage.this.infoWidget == null) {
                    throw new AssertionError();
                }
                LanguageConfigurationPreferencePage.this.infoWidget.refresh(null, LanguageConfigurationPreferencePage.this.manager);
                if (selection.isEmpty()) {
                    return;
                }
                ILanguageConfigurationDefinition definition = (ILanguageConfigurationDefinition)selection.getFirstElement();
                if (!$assertionsDisabled && definitionRemoveButton == null) {
                    throw new AssertionError();
                }
                definitionRemoveButton.setEnabled(definition.getPluginId() == null);
                this.selectDefinition(definition);
            }

            private void selectDefinition(ILanguageConfigurationDefinition definition) {
                if (!$assertionsDisabled && LanguageConfigurationPreferencePage.this.infoWidget == null) {
                    throw new AssertionError();
                }
                LanguageConfigurationPreferencePage.this.infoWidget.refresh(definition, LanguageConfigurationPreferencePage.this.manager);
            }
        });
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private Collection<ILanguageConfigurationDefinition> getSelectedUserDefinitions(TableViewer definitionViewer) {
        IStructuredSelection selection = definitionViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        return selection.toList().stream().filter(definition -> definition.getPluginId() == null).collect(Collectors.toList());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_title);
        }
    }

    public boolean performOk() {
        try {
            this.manager.save();
        }
        catch (BackingStoreException ex) {
            LanguageConfigurationPlugin.logError((Exception)((Object)ex));
        }
        return super.performOk();
    }

    public void init(@Nullable IWorkbench workbench) {
    }
}

