/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security.preference;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rse.internal.dstore.security.preference.Element;
import org.eclipse.rse.internal.dstore.security.preference.X509CertificateElement;
import org.eclipse.swt.graphics.Image;

public class CertTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof Element) {
            return ((Element)element).getImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Element) {
            X509CertificateElement myTableElement = (X509CertificateElement)element;
            switch (columnIndex) {
                case 0: {
                    return myTableElement.getAlias();
                }
                case 1: {
                    String name = myTableElement.getSubjectName();
                    if (!(name != null && name.length() != 0 || (name = myTableElement.getSubjectUnit()) != null && name.length() != 0)) {
                        name = myTableElement.getSubjectOrg();
                    }
                    return name;
                }
                case 2: {
                    String name = myTableElement.getIssuerName();
                    if (!(name != null && name.length() != 0 || (name = myTableElement.getIssuerUnit()) != null && name.length() != 0)) {
                        name = myTableElement.getIssuerOrg();
                    }
                    return name;
                }
                case 3: {
                    return myTableElement.getNotAfter();
                }
            }
        }
        return "";
    }
}

