/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.actions;

import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.tm.terminal.view.ui.tabs.TabCommandFieldHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;

public class ToggleCommandFieldAction
extends AbstractTerminalAction {
    private ITerminalsView view = null;

    public ToggleCommandFieldAction(ITerminalsView view) {
        super(null, ToggleCommandFieldAction.class.getName(), 2);
        this.view = view;
        this.setupAction(Messages.ToggleCommandFieldAction_menu, Messages.ToggleCommandFieldAction_toolTip, UIPlugin.getImageDescriptor("ToggleCommandField_hover"), UIPlugin.getImageDescriptor("ToggleCommandField_enabled"), UIPlugin.getImageDescriptor("ToggleCommandField_disabled"), true);
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    public void run() {
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        if (handler != null) {
            handler.setCommandInputField(!handler.hasCommandInputField());
        }
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    public void updateAction(boolean aboutToShow) {
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        ITerminalViewControl target = this.getTarget();
        this.setEnabled(aboutToShow && handler != null && target != null && target.getState() == TerminalState.CONNECTED);
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    protected TabCommandFieldHandler getCommandFieldHandler() {
        CTabItem activeTabItem;
        TabCommandFieldHandler handler = null;
        TabFolderManager manager = (TabFolderManager)((Object)this.view.getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null && !activeTabItem.isDisposed()) {
            handler = manager.getTabCommandFieldHandler(activeTabItem);
        }
        return handler;
    }
}

