/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_my extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "NAf" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "Afl" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "G" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "K" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "B/." },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TT$" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u1021\u102c\u101b\u1015\u103a\u1005\u1031\u102c\u103a\u1018\u103d\u102c\u1038\u1019\u103b\u102c\u1038 \u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f \u1012\u102b\u101f\u1019\u103a\u1038" },
            { "afn", "\u1021\u102c\u1016\u1002\u1014\u103a \u1021\u102c\u1016\u1002\u102b\u1014\u102e" },
            { "all", "\u1021\u101a\u103a\u1018\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u101c\u102e\u1001\u103a" },
            { "amd", "\u1021\u102c\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1012\u101b\u1019\u103a" },
            { "ang", "\u1014\u101a\u103a\u101e\u102c\u101c\u1014\u103a \u1021\u1014\u103a\u1010\u102e\u101c\u1014\u103a \u1002\u1004\u103a\u1038\u1012\u102b\u1038" },
            { "aoa", "\u1021\u1014\u103a\u1002\u102d\u102f\u101c\u102c \u1000\u103d\u1019\u103a\u1007\u102c" },
            { "arp", "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1015\u102e\u1006\u102d\u102f (\u1041\u1049\u1048\u1043\u2013\u1041\u1049\u1048\u1045)" },
            { "ars", "\u1021\u102c\u1002\u103b\u1004\u103a\u1010\u102e\u1038\u1014\u102c\u1038 \u1015\u102e\u1006\u102d\u102f" },
            { "aud", "\u1029\u1005\u1010\u103c\u1031\u1038\u101c\u103b \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "awg", "\u1021\u101b\u1030\u1038\u1017\u102c \u1016\u101c\u102d\u102f\u101b\u1004\u103a\u1038" },
            { "azn", "\u1021\u1007\u102c\u1018\u102d\u102f\u1004\u103a\u1002\u103b\u1014\u103a \u1019\u102c\u1014\u1010\u103a" },
            { "bam", "\u1018\u1031\u102c\u1037\u1005\u1014\u102e\u1038\u101a\u102c\u1038\u1014\u103e\u1004\u1037\u103a \u101f\u102c\u1007\u102e\u1002\u102d\u102f\u1018\u102e\u1038\u1014\u102c\u1038 \u1004\u103d\u1031\u101c\u1032\u1014\u102d\u102f\u1004\u103a\u101e\u1031\u102c \u1019\u1010\u103a\u1000\u103a" },
            { "bbd", "\u1018\u102c\u1018\u1031\u1038\u1012\u102d\u102f\u1038\u1005\u103a \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "bdt", "\u1018\u1004\u103a\u1039\u1002\u101c\u102c\u1038\u1012\u1031\u1037\u101b\u103e\u103a \u1010\u102c\u1000\u102c" },
            { "bef", "\u1018\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u101a\u1019\u103a \u1016\u101b\u1014\u1037\u103a" },
            { "bgn", "\u1018\u1030\u101c\u103a\u1002\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u101c\u1000\u103a\u1016\u103a" },
            { "bhd", "\u1018\u102c\u101b\u102d\u1014\u103a\u1038 \u1012\u102e\u1014\u102c\u1038" },
            { "bif", "\u1018\u1030\u101b\u103d\u1014\u103a\u1012\u102e \u1016\u101b\u1014\u1037\u103a" },
            { "bmd", "\u1018\u102c\u1019\u103c\u1030\u1012\u102b \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "bnd", "\u1018\u101b\u1030\u1014\u102d\u102f\u1004\u103a\u1038 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "bob", "\u1018\u102d\u102f\u101c\u102e\u1038\u1017\u102e\u1038\u101a\u102c\u1038 \u1018\u102d\u102f\u101c\u102e\u1038\u1017\u102e\u101a\u102c\u1038\u1014\u102d\u102f" },
            { "bop", "\u1018\u102d\u102f\u101c\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038 \u1015\u102e\u1006\u102d\u102f" },
            { "brl", "\u1018\u101b\u102c\u1007\u102e\u1038 \u101b\u102e\u1038\u101a\u1032" },
            { "bsd", "\u1018\u101f\u102c\u1038\u1019\u102c\u1038 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "btn", "\u1018\u1030\u1010\u1014\u103a \u1021\u1036\u1002\u102b\u101c\u103a\u1011\u101b\u1014\u103a" },
            { "buk", "\u1017\u1019\u102c \u1000\u103b\u1015\u103a" },
            { "bwp", "\u1018\u1031\u102c\u1037\u1006\u103d\u102c\u1014\u102c \u1015\u102f\u101c" },
            { "byb", "\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a \u101b\u1030\u1018\u101a\u103a\u1021\u101e\u1005\u103a (\u1041\u1049\u1049\u1044\u2013\u1041\u1049\u1049\u1049)" },
            { "byn", "\u1018\u102e\u101c\u102c\u101b\u102f\u1005\u103a \u101b\u1030\u1018\u101a\u103a" },
            { "byr", "\u1018\u102e\u101c\u102c\u101b\u102f\u1007\u103a \u101b\u1030\u1018\u101a\u103a (\u1042\u1040\u1040\u1040\u2013\u1042\u1040\u1041\u1046)" },
            { "bzd", "\u1018\u101c\u102d\u1007\u103a \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "cad", "\u1000\u1014\u1031\u1012\u102b \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "cdf", "\u1000\u103d\u1014\u103a\u1002\u102d\u102f \u1016\u101b\u1014\u1037\u103a" },
            { "chf", "\u1006\u103d\u1005\u103a \u1016\u101b\u1014\u1037\u103a" },
            { "clp", "\u1001\u103b\u102e\u101c\u102e \u1015\u102e\u1006\u102d\u102f" },
            { "cnh", "\u1010\u101b\u102f\u1010\u103a \u101a\u103d\u1019\u103a (\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a)" },
            { "cny", "\u1010\u101b\u102f\u1010\u103a \u101a\u103d\u1019\u103a" },
            { "cop", "\u1000\u102d\u102f\u101c\u1036\u1018\u102e\u101a\u102c \u1015\u102e\u1006\u102d\u102f" },
            { "crc", "\u1000\u102d\u102f\u1037\u1005\u1010\u102c\u101b\u102e\u1000\u102c \u1000\u102d\u102f\u101c\u103d\u1014\u103a" },
            { "cuc", "\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1001\u103c\u102c\u1038\u1004\u103d\u1031\u101c\u1032\u101c\u103e\u101a\u103a\u1014\u102d\u102f\u1004\u103a\u101e\u1031\u102c \u1000\u103b\u1030\u1038\u1018\u102c\u1038\u1015\u102e\u1006\u102d\u102f" },
            { "cup", "\u1000\u103b\u1030\u1038\u1018\u102c\u1038 \u1015\u102e\u1006\u102d\u102f" },
            { "cve", "\u1000\u102d\u1010\u103a\u1015\u103a\u1017\u102c\u1012\u102e \u1021\u1000\u103a\u1005\u103a\u1001\u1030\u1012\u102d\u102f" },
            { "cyp", "\u1006\u102d\u102f\u1000\u103a\u1015\u101b\u1000\u103a\u1005\u103a \u1015\u1031\u102b\u1004\u103a" },
            { "czk", "\u1001\u103b\u1000\u103a \u1001\u102d\u102f\u101b\u102d\u102f\u1014\u102c" },
            { "dem", "\u1002\u103b\u102c\u1019\u100f\u102e \u1019\u1010\u103a" },
            { "djf", "\u1002\u103b\u102e\u1018\u1030\u1010\u102e \u1016\u101b\u1014\u1037\u103a" },
            { "dkk", "\u1012\u102d\u1014\u103a\u1038\u1019\u1010\u103a \u1001\u101b\u102d\u102f\u100f\u102c" },
            { "dop", "\u1012\u102d\u102f\u1019\u102e\u1014\u102e\u1000\u1014\u103a \u1015\u102e\u1006\u102d\u102f" },
            { "dzd", "\u1021\u101a\u103a\u101c\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1012\u102e\u1014\u102c" },
            { "egp", "\u1021\u102e\u1002\u103b\u1005\u103a \u1015\u1031\u102b\u1004\u103a" },
            { "ern", "\u1021\u102e\u101b\u102e\u1011\u101b\u102e\u1038\u101a\u102c\u1038 \u1014\u102c\u1037\u1001\u103a\u1016\u102c" },
            { "esp", "\u1005\u1015\u102d\u1014\u103a \u1015\u101a\u103a\u1005\u1031\u1038\u1010\u102c" },
            { "etb", "\u1021\u102e\u101e\u102e\u101a\u102d\u102f\u1038\u1015\u102e\u1038\u101a\u102c\u1038 \u1018\u102e\u1038\u101a\u102c" },
            { "eur", "\u101a\u1030\u101b\u102d\u102f" },
            { "fjd", "\u1016\u102e\u1002\u103b\u102e \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "fkp", "\u1016\u1031\u102c\u1037\u1000\u101c\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1015\u1031\u102b\u1004\u103a" },
            { "frf", "\u1015\u103c\u1004\u103a\u101e\u1005\u103a \u1016\u101b\u1014\u1037\u103a" },
            { "gbp", "\u1017\u103c\u102d\u1010\u102d\u101e\u103b\u103e \u1015\u1031\u102b\u1004\u103a" },
            { "gel", "\u1002\u103b\u1031\u102c\u103a\u1002\u103b\u102e\u101a\u102c \u101c\u102c\u1038\u101b\u102e" },
            { "ghs", "\u1002\u102b\u1014\u102c \u1006\u1032\u1012\u102e" },
            { "gip", "\u1002\u103b\u102e\u1018\u101b\u1031\u102c\u103a\u101c\u103a\u1010\u102c \u1015\u1031\u102b\u1004\u103a" },
            { "gmd", "\u1002\u1019\u103a\u1018\u102e\u101a\u102c \u1012\u102b\u101c\u102c\u1005\u102e" },
            { "gnf", "\u1002\u102e\u1014\u102e\u101b\u102c \u1016\u101b\u1014\u1037\u103a" },
            { "gtq", "\u1002\u103d\u102b\u1010\u102e\u1019\u102c\u101c\u102c \u1001\u1000\u103a\u1007\u1031\u102c\u103a\u101c\u103a" },
            { "gyd", "\u1002\u102d\u102f\u1004\u103a\u101a\u102c\u1014\u102c \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "hkd", "\u101f\u1031\u102c\u1004\u103a\u1000\u1031\u102c\u1004\u103a \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "hnl", "\u101f\u103d\u1014\u103a\u1012\u1030\u1038\u101b\u1015\u103a\u1005\u103a \u101c\u1019\u103a\u1038\u1015\u102e\u101b\u102c" },
            { "hrk", "\u1001\u101b\u102d\u102f\u1021\u1031\u1038\u101b\u103e\u102c\u1038 \u1001\u1030\u1038\u1014\u102c" },
            { "htg", "\u101f\u1031\u1010\u102e\u1002\u1030\u1038\u1021\u1031\u102c\u103a\u1012\u103a" },
            { "huf", "\u101f\u1014\u103a\u1002\u1031\u101b\u102e\u101a\u1036 \u1016\u1031\u102c\u103a\u101b\u1004\u1037\u103a\u1010\u103a" },
            { "idr", "\u1021\u1004\u103a\u1012\u102d\u102f\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u101b\u1030\u1015\u102e\u1038\u101a\u102c\u1038" },
            { "ilp", "\u1021\u1005\u1039\u1005\u101b\u1031\u1038 \u1015\u1031\u102b\u1004\u103a" },
            { "ils", "\u1021\u1005\u1039\u1005\u101b\u1031\u1038 \u101b\u103e\u1032\u1000\u101c\u103a\u1021\u101e\u1005\u103a" },
            { "inr", "\u1021\u102d\u1014\u1039\u1012\u102d\u101a \u101b\u1030\u1015\u102e\u1038" },
            { "iqd", "\u1021\u102e\u101b\u1010\u103a \u1012\u102e\u1014\u102c" },
            { "irr", "\u1021\u102e\u101b\u1014\u103a \u101b\u102e\u1021\u1031\u102c\u103a\u101c\u103a" },
            { "isk", "\u1021\u102d\u102f\u1000\u103a\u1005\u101c\u1014\u103a \u1001\u101b\u102d\u102f\u100f\u102c" },
            { "jmd", "\u1002\u103b\u1019\u1031\u1000\u102c \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "jod", "\u1002\u103b\u1031\u102c\u103a\u1012\u1014\u103a \u1012\u102e\u1014\u102c" },
            { "jpy", "\u1002\u103b\u1015\u1014\u103a \u101a\u1014\u103a\u1038" },
            { "kes", "\u1000\u1004\u103a\u100a\u102c \u101e\u103b\u103e\u102e\u101c\u1004\u103a" },
            { "kgs", "\u1000\u102c\u1002\u103b\u1005\u1039\u1005\u1010\u1014\u103a \u1006\u1031\u102c\u103a\u1019\u103a" },
            { "khr", "\u1000\u1019\u1039\u1018\u1031\u102c\u1012\u102e\u1038\u101a\u102c\u1038 \u101b\u102e\u1038\u101a\u1032" },
            { "kmf", "\u1000\u102d\u102f\u1019\u102d\u102f\u101b\u102d\u102f\u1005\u103a \u1016\u101b\u1014\u1037\u103a" },
            { "kpw", "\u1019\u103c\u1031\u102c\u1000\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038 \u101d\u1019\u103a" },
            { "krw", "\u1010\u1031\u102c\u1004\u103a\u1000\u102d\u102f\u101b\u102e\u1038\u101a\u102c\u1038 \u101d\u1019\u103a" },
            { "kwd", "\u1000\u1030\u101d\u102d\u1010\u103a \u1012\u102e\u1014\u102c" },
            { "kyd", "\u1000\u1031\u1019\u1014\u103a \u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "kzt", "\u1000\u102c\u1007\u1000\u103a\u1005\u1010\u1014\u103a \u1011\u102d\u1014\u103a\u1002\u103b\u102e" },
            { "lak", "\u101c\u102c\u1021\u102d\u102f \u1000\u1005\u103a" },
            { "lbp", "\u101c\u1000\u103a\u1018\u1014\u103d\u1014\u103a \u1015\u1031\u102b\u1004\u103a" },
            { "lkr", "\u101e\u102e\u101b\u102d\u101c\u1004\u103a\u1039\u1000\u102c \u101b\u1030\u1015\u102e\u1038" },
            { "lrd", "\u101c\u102d\u102f\u1000\u103a\u1018\u1031\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "lsl", "\u101c\u102e\u1006\u102d\u102f\u101e\u102d\u102f \u101c\u102d\u102f\u1010\u102e" },
            { "ltl", "\u101c\u1005\u103a\u101e\u1030\u101a\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038\u101c\u102e\u1010\u102c\u1038\u1005\u103a" },
            { "lvl", "\u101c\u1010\u103a\u1017\u102e\u1038\u101a\u102c\u1038\u101c\u1010\u103a" },
            { "lyd", "\u101c\u1005\u103a\u1017\u103b\u102c\u1038 \u1012\u102d\u102f\u1004\u103a\u1014\u102c" },
            { "mad", "\u1019\u102d\u102f\u101b\u102d\u102f\u1000\u102d\u102f \u1012\u101b\u1019\u103a" },
            { "mdl", "\u1019\u1031\u102c\u101c\u103a\u1012\u102d\u102f\u1017\u102c \u101c\u101a\u103a\u1021\u102d\u102f" },
            { "mga", "\u1019\u102c\u101c\u102c\u1002\u102b\u1005\u102e \u1021\u101b\u102e\u101b\u101b\u102e" },
            { "mkd", "\u1019\u1000\u103a\u1006\u102e\u1012\u102d\u102f\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1012\u102e\u1014\u102c" },
            { "mmk", "\u1019\u103c\u1014\u103a\u1019\u102c \u1000\u103b\u1015\u103a" },
            { "mnt", "\u1019\u103d\u1014\u103a\u1002\u102d\u102f\u1038\u101c\u102e\u1038\u101a\u102c\u1038 \u1011\u1030\u1038\u1002\u101b\u1001\u103a" },
            { "mop", "\u1019\u1000\u102c\u1021\u102d\u102f \u1015\u102b\u1010\u102c\u1038\u1000\u102c\u1038" },
            { "mro", "\u1019\u1031\u102c\u103a\u101b\u102e\u1010\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u1021\u1030\u1002\u102e\u1038\u101a\u102c (\u1041\u1049\u1047\u1043\u2013\u1042\u1040\u1041\u1047)" },
            { "mru", "\u1019\u1031\u102c\u103a\u101b\u102e\u1010\u1031\u1038\u1014\u102e\u1038\u101a\u1014\u103a\u1038 \u1021\u1030\u1002\u102e\u1038\u101a\u102c" },
            { "mur", "\u1019\u1031\u102c\u101b\u1005\u103a\u101b\u103e \u101b\u1030\u1015\u102e\u1038" },
            { "mvr", "\u1019\u1031\u102c\u103a\u101c\u103a\u1012\u102d\u102f\u1000\u103a \u101b\u1030\u1038\u1016\u102e\u101b\u102c" },
            { "mwk", "\u1019\u102c\u101c\u102c\u101d\u102e \u1001\u103d\u102b\u1038\u1001\u103b\u102c" },
            { "mxn", "\u1019\u1000\u103a\u1000\u1006\u102e\u1000\u102d\u102f \u1015\u102e\u1006\u102d\u102f" },
            { "myr", "\u1019\u101c\u1031\u1038\u101b\u103e\u102c\u1038 \u101b\u1004\u103a\u1038\u1002\u1005\u103a" },
            { "mzn", "\u1019\u102d\u102f\u1007\u1019\u103a\u1018\u1005\u103a \u1019\u1000\u103a\u1010\u102e\u1001\u101a\u103a\u101c\u103a" },
            { "nad", "\u1014\u1019\u102e\u1038\u1018\u102e\u1038\u101a\u102c\u1038 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "ngn", "\u1014\u102d\u102f\u1004\u103a\u1002\u103b\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1014\u102d\u102f\u1004\u103a\u1038\u101b\u102c" },
            { "nio", "\u1014\u102e\u1000\u102c\u101b\u102c\u1002\u103d\u102b \u1001\u102d\u102f\u1038\u1012\u102d\u102f\u1018\u102c" },
            { "nok", "\u1014\u1031\u102c\u103a\u101d\u1031 \u1001\u101b\u102d\u102f\u100f\u102c" },
            { "npr", "\u1014\u102e\u1015\u1031\u102b \u101b\u1030\u1015\u102e\u1038" },
            { "nzd", "\u1014\u101a\u1030\u1038\u1007\u102e\u101c\u1014\u103a \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "omr", "\u1021\u102d\u102f\u1019\u1014\u103a\u1014\u102e \u101b\u102e\u101b\u101a\u103a" },
            { "pab", "\u1015\u1014\u102c\u1038\u1019\u102c\u1038 \u1018\u101c\u103b\u1018\u102d\u102f\u1038\u1021\u102c" },
            { "pen", "\u1015\u102e\u101b\u1030\u1038 \u1006\u102d\u102f\u1038\u101c\u103a" },
            { "pgk", "\u1015\u102b\u1015\u1030\u1021\u102c \u1014\u101a\u1030\u1038\u1002\u102e\u1014\u102e \u1001\u102e\u1038\u1014\u102c" },
            { "php", "\u1016\u102d\u101c\u1005\u103a\u1015\u102d\u102f\u1004\u103a \u1015\u102e\u1006\u102d\u102f" },
            { "pkr", "\u1015\u102b\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u101b\u1030\u1015\u102e\u1038" },
            { "pln", "\u1015\u102d\u102f\u101c\u1014\u103a \u1007\u101c\u1031\u102c\u1037\u1010\u102e" },
            { "pyg", "\u1015\u102b\u101b\u102c\u1002\u103d\u1031\u1038 \u1002\u103d\u102b\u1038\u1021\u103a\u1014\u102e\u1038" },
            { "qar", "\u1000\u102c\u1010\u102c\u101b\u102e \u101b\u102e\u101b\u101a\u103a" },
            { "ron", "\u101b\u102d\u102f\u1019\u1031\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u101c\u101a\u103a\u1021\u102d\u102f" },
            { "rsd", "\u1006\u102c\u1038\u1018\u102e\u1038\u101a\u102c\u1038 \u1012\u101a\u103a\u1014\u102c\u1038" },
            { "rub", "\u101b\u102f\u101b\u103e \u101b\u1030\u1018\u101a\u103a" },
            { "rur", "\u101b\u102f\u101b\u103e \u101b\u1030\u1018\u101a\u103a (\u1041\u1049\u1049\u1041\u2013\u1041\u1049\u1049\u1048)" },
            { "rwf", "\u101b\u101d\u1014\u103a\u1012\u102b \u1016\u101b\u1014\u1037\u103a" },
            { "sar", "\u1006\u1031\u102c\u103a\u1012\u102e\u1021\u102c\u101b\u1031\u1038\u1017\u102e\u1038\u101a\u102c\u1038 \u101b\u102e\u101a\u1031\u102c\u103a\u101c\u103a" },
            { "sbd", "\u1006\u1031\u102c\u103a\u101c\u1019\u103d\u1014\u103a\u1000\u103b\u103d\u1014\u103a\u1038\u1005\u102f \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "scr", "\u1006\u1031\u1038\u101b\u103e\u1032 \u101b\u1030\u1015\u102e\u1038" },
            { "sdg", "\u1006\u1030\u1012\u1014\u103a \u1015\u1031\u102b\u1004\u103a" },
            { "sdp", "\u1006\u1030\u1012\u1014\u103a \u1015\u1031\u102b\u1004\u103a\u1021\u101f\u1031\u102c\u1004\u103a\u1038" },
            { "sek", "\u1006\u103d\u102e\u1012\u1004\u103a \u1001\u101b\u102d\u102f\u100f\u102c" },
            { "sgd", "\u1005\u1004\u103a\u1039\u1000\u102c\u1015\u1030 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "shp", "\u1005\u102d\u1014\u1037\u103a\u101f\u101a\u103a\u101c\u101a\u103a\u1014\u102c \u1015\u1031\u102b\u1004\u103a" },
            { "sll", "\u1006\u102e\u101a\u102c\u101b\u102c\u101c\u102e\u101a\u103d\u1014\u103a\u1038 \u101c\u102e\u1021\u102d\u102f\u1014\u102e" },
            { "sos", "\u1006\u102d\u102f\u1019\u102c\u101c\u102e \u101e\u103b\u103e\u102e\u101c\u1004\u103a" },
            { "srd", "\u1006\u1030\u101b\u102e\u1014\u1019\u103a\u1038 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "ssp", "\u1010\u1031\u102c\u1004\u103a\u1006\u1030\u1012\u1014\u103a \u1015\u1031\u102b\u1004\u103a" },
            { "std", "\u1006\u1031\u102c\u1004\u103a\u1010\u1030\u1019\u1031\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u101b\u1004\u103a\u1005\u102e\u1015\u102e \u1012\u102d\u102f\u1018\u101b\u102c" },
            { "stn", "\u1006\u1031\u102c\u1004\u103a\u1010\u1030\u1019\u1031\u1038\u1014\u103e\u1004\u1037\u103a \u1015\u101b\u1004\u103a\u1005\u102e\u1015\u102e \u1012\u102d\u102f\u1018\u101b\u102c (\u1042\u1040\u1041\u1048)" },
            { "sur", "\u1006\u102d\u102f\u1017\u102e\u101a\u1000\u103a \u101b\u1030\u1017\u101a\u103a" },
            { "syp", "\u1006\u102e\u1038\u101b\u102e\u1038\u101a\u102c\u1038 \u1015\u1031\u102b\u1004\u103a" },
            { "szl", "\u1006\u103d\u102c\u1007\u102e\u101c\u1014\u103a \u101c\u102e\u101c\u1014\u103a\u1038\u1002\u102e\u1014\u102e" },
            { "thb", "\u1011\u102d\u102f\u1004\u103a\u1038 \u1018\u1010\u103a" },
            { "tjs", "\u1010\u102c\u1002\u103b\u1005\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1006\u102d\u102f\u1019\u102d\u102f\u1014\u102e" },
            { "tmt", "\u1010\u102c\u1037\u1001\u103a\u1019\u1004\u103a\u1014\u1005\u1039\u1005\u1010\u1014\u103a \u1019\u102c\u1014\u1010\u103a" },
            { "tnd", "\u1010\u1030\u1014\u102e\u1038\u101b\u103e\u102c\u1038 \u1012\u102d\u102f\u1004\u103a\u1014\u102c" },
            { "top", "\u1010\u103d\u1014\u103a\u1002\u102b \u1017\u1014\u103a\u1002\u102b" },
            { "trl", "\u101b\u103e\u1031\u1038\u101f\u1031\u102c\u1004\u103a\u1038\u1010\u1030\u101b\u1000\u102e \u101c\u102d\u102f\u1004\u103a\u101b\u102c" },
            { "try", "\u1010\u1030\u101b\u1000\u102e \u101c\u102d\u102f\u1004\u103a\u101b\u102c" },
            { "ttd", "\u1011\u101b\u102e\u1014\u102e\u1012\u1010\u103a\u1014\u103e\u1004\u1037\u103a \u1010\u102d\u102f\u1018\u1000\u103a\u1002\u102d\u102f \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "twd", "\u1011\u102d\u102f\u1004\u103a\u101d\u1019\u103a \u1012\u1031\u102b\u103a\u101c\u102c\u1021\u101e\u1005\u103a" },
            { "tzs", "\u1010\u1014\u103a\u1007\u1014\u103a\u1038\u1014\u102e\u1038\u101a\u102c\u1038 \u101e\u103b\u103e\u102e\u101c\u1004\u103a" },
            { "uah", "\u101a\u1030\u1000\u101b\u102d\u1014\u103a\u1038 \u101f\u102e\u101b\u102e\u1017\u1004\u103a\u1038\u100a\u102c\u1038" },
            { "ugx", "\u101a\u1030\u1002\u1014\u1039\u1012\u102c \u101e\u103b\u103e\u102e\u101c\u1004\u103a" },
            { "usd", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "usn", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1012\u1031\u102b\u103a\u101c\u102c (\u1014\u1031\u102c\u1000\u103a\u1014\u1031\u1037)" },
            { "uss", "\u1021\u1019\u1031\u101b\u102d\u1000\u1014\u103a \u1012\u1031\u102b\u103a\u101c\u102c (\u1010\u1014\u1031\u1037\u1010\u100a\u103a\u1038)" },
            { "uyu", "\u1025\u101b\u102f\u1002\u103d\u1031\u1038 \u1015\u102e\u1006\u102d\u102f" },
            { "uzs", "\u1025\u1007\u1018\u1000\u103a\u1000\u1005\u1039\u1005\u1010\u1014\u103a \u1006\u1031\u102c\u103a\u1019\u103a" },
            { "vef", "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u102c\u1038 \u1018\u102d\u102f\u101c\u102e\u1017\u102c (\u1042\u1040\u1040\u1048\u2013\u1042\u1040\u1041\u1048)" },
            { "ves", "\u1017\u1004\u103a\u1014\u102e\u1007\u103d\u1032\u101c\u1014\u103a\u1038 \u1018\u102d\u102f\u101c\u102e\u1017\u102c" },
            { "vnd", "\u1017\u102e\u101a\u1000\u103a\u1014\u1019\u103a \u1012\u1031\u102b\u1004\u103a" },
            { "vuv", "\u1017\u1014\u103d\u102c\u1038\u1010\u1030 \u1017\u102c\u1038\u1011\u1030" },
            { "wst", "\u1006\u1019\u102d\u102f\u1021\u102c\u1038 \u1011\u102c\u1038\u101c\u102c" },
            { "xaf", "\u1000\u1004\u103a\u1019\u101b\u103d\u1014\u103a\u1038 \u1016\u101b\u1014\u1037\u103a" },
            { "xag", "\u1004\u103d\u1031" },
            { "xau", "\u101b\u103d\u103e\u1031" },
            { "xbb", "\u1025\u101b\u1031\u102c\u1015\u1004\u103d\u1031\u1000\u103c\u1031\u1038\u1005\u1036\u1014\u1005\u103a" },
            { "xcd", "\u1021\u101b\u103e\u1031\u1037\u1000\u102c\u101b\u1005\u103a\u1018\u102e\u101a\u1036 \u1012\u1031\u102b\u103a\u101c\u102c" },
            { "xdr", "\u1021\u1011\u1030\u1038\u1011\u102f\u1010\u103a\u101a\u1030\u1001\u103d\u1004\u1037\u103a" },
            { "xof", "\u1021\u1014\u1031\u102c\u1000\u103a \u1021\u102c\u1016\u101b\u102d\u1000 [CFA ]\u1016\u101b\u1014\u1037\u103a" },
            { "xpf", "[CFP] \u1016\u101b\u1014\u1037\u103a" },
            { "xpt", "\u1015\u101c\u1000\u103a\u1010\u102e\u1014\u1019\u103a" },
            { "xts", "\u1005\u1019\u103a\u1038\u101e\u1015\u103a \u1004\u103d\u1031\u1000\u103c\u1031\u1038 \u1000\u102f\u1012\u103a" },
            { "xxx", "\u1019\u101e\u102d\u101e\u102d\u102f\u1037\u1019\u101f\u102f\u1010\u103a\u1019\u101b\u103e\u102d\u101e\u1031\u102c\u1004\u103d\u1031\u1000\u103c\u1031\u1038" },
            { "yer", "\u101a\u102e\u1019\u1004\u103a\u1014\u102e \u101b\u102e\u101b\u101a\u103a" },
            { "zar", "\u1010\u1031\u102c\u1004\u103a\u1021\u102c\u1016\u101b\u102d\u1000 \u101b\u1014\u103a\u1038" },
            { "zmw", "\u1007\u1004\u103a\u1018\u102c\u1018\u103d\u1031 \u1001\u103d\u102b\u1038\u1001\u103b\u102c" },
            { "zwd", "\u1007\u1004\u103a\u1018\u102c\u1018\u103d\u1031 \u1012\u1031\u102b\u103a\u101c\u102c" },
        };
        return data;
    }
}
