import { DebugProtocol } from 'vscode-debugprotocol';
import { IVariablesResponseBody, ISetVariableResponseBody } from '../debugAdapterInterfaces';
import { Protocol as Crdp } from 'devtools-protocol';
import { IVariableContainer } from './variables';
import { VariableContext } from './chromeDebugAdapter';
import { ChromeConnection } from './chromeConnection';
/**
 * A container for managing get/set variable calls
 */
export declare class VariablesManager {
    private readonly _chromeConnection;
    private _variableHandles;
    private readonly chrome;
    constructor(_chromeConnection: ChromeConnection);
    getVariables(args: DebugProtocol.VariablesArguments): Promise<IVariablesResponseBody | undefined>;
    getVariablesForObjectId(objectId: string, evaluateName?: string, filter?: string, start?: number, count?: number): Promise<DebugProtocol.Variable[]>;
    onPaused(): void;
    createHandle(value: IVariableContainer, context?: VariableContext): number;
    setPropertyValue(objectId: string, propName: string, value: string): Promise<string>;
    private getRuntimeProperties(params);
    private getFilteredVariablesForObject(objectId, evaluateName, filter, start, count);
    private getFilteredVariablesForObjectId(objectId, evaluateName, getVarsFn, filter, start, count);
    setVariable(args: DebugProtocol.SetVariableArguments): Promise<ISetVariableResponseBody>;
    setVariableValue(callFrameId: string, scopeNumber: number, variableName: string, value: string): Promise<string>;
    createObjectVariable(name: string, object: Crdp.Runtime.RemoteObject, parentEvaluateName: string, context: VariableContext): Promise<DebugProtocol.Variable>;
    propertyDescriptorToVariable(propDesc: Crdp.Runtime.PropertyDescriptor, owningObjectId?: string, parentEvaluateName?: string): Promise<DebugProtocol.Variable>;
    private getArrayNumPropsByEval(objectId);
    private getBufferNumPropsByEval(objectId);
    private getCollectionNumPropsByEval(objectId);
    private getNumPropsByEval(objectId, getNumPropsFn);
    remoteObjectToVariable(name: string, object: Crdp.Runtime.RemoteObject, parentEvaluateName?: string, stringify?: boolean, context?: VariableContext): Promise<DebugProtocol.Variable>;
    private internalPropertyDescriptorToVariable(propDesc, parentEvaluateName);
}
