/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.splitter;

import java.text.Normalizer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.wikitext.splitter.SplittingStrategy;

public class DefaultSplittingStrategy
extends SplittingStrategy {
    private int headingCount;
    private int firstHeadingSplit = 2;
    private int headingLevel;
    private int splitLevel = 1;
    private String id;
    private String label;
    private String target;
    private final Set<String> targets = new HashSet<String>();

    @Override
    public void heading(int level, String id, String label) {
        if (level <= 0) {
            return;
        }
        this.label = label;
        this.id = id;
        this.headingLevel = level;
        ++this.headingCount;
        if (this.isSplit()) {
            this.target = this.computeSplitTarget();
        }
    }

    @Override
    public String getSplitTarget() {
        return this.target;
    }

    protected String computeSplitTarget() {
        String candidate = this.computeSplitTargetCandidate();
        Object computedTarget = candidate;
        int seed = 1;
        while (!this.targets.add((String)computedTarget)) {
            computedTarget = candidate + ++seed;
        }
        return (String)computedTarget + ".html";
    }

    protected String computeSplitTargetCandidate() {
        Object candidate = null;
        if (this.label != null && this.label.length() > 0) {
            candidate = this.stripUnsafeCharacters(this.label);
        }
        if (candidate == null && this.id != null) {
            candidate = this.stripUnsafeCharacters(this.id);
        }
        if (candidate == null || ((String)candidate).length() == 0) {
            candidate = "h" + this.headingLevel + "p" + this.headingCount;
        }
        return candidate;
    }

    protected String stripUnsafeCharacters(String candidate) {
        String safe = Normalizer.normalize(candidate, Normalizer.Form.NFD);
        safe = safe.replaceAll("\\p{IsM}+", "").replaceAll("[^a-zA-Z0-9]+", "-");
        return safe;
    }

    @Override
    public boolean isSplit() {
        return this.headingCount >= this.firstHeadingSplit && this.splitLevel >= this.headingLevel;
    }

    public int getFirstHeadingSplit() {
        return this.firstHeadingSplit;
    }

    public void setFirstHeadingSplit(int firstHeadingSplit) {
        this.firstHeadingSplit = firstHeadingSplit;
    }

    public int getSplitLevel() {
        return this.splitLevel;
    }

    public void setSplitLevel(int splitLevel) {
        this.splitLevel = splitLevel;
    }
}

