/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class CheatSheetCollectionElement
extends WorkbenchAdapter
implements IPluginContribution {
    private String pluginId;
    private String id;
    private String name;
    private CheatSheetCollectionElement parent;
    private AdaptableList cheatsheets = new AdaptableList();
    private List<CheatSheetCollectionElement> childCollections = new ArrayList<CheatSheetCollectionElement>();

    public CheatSheetCollectionElement(String pluginId, String id, String name, CheatSheetCollectionElement parent) {
        this.name = name;
        this.pluginId = pluginId;
        this.id = id;
        this.parent = parent;
    }

    public void add(IAdaptable a) {
        if (a instanceof CheatSheetElement) {
            this.cheatsheets.add(a);
        } else {
            this.childCollections.add((CheatSheetCollectionElement)a);
        }
    }

    public CheatSheetCollectionElement findChildCollection(IPath searchPath) {
        Object[] children = this.getChildren();
        String searchString = searchPath.segment(0);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            CheatSheetCollectionElement currentCategory = (CheatSheetCollectionElement)((Object)element);
            if (currentCategory.getLabel(null).equals(searchString)) {
                if (searchPath.segmentCount() == 1) {
                    return currentCategory;
                }
                return currentCategory.findChildCollection(searchPath.removeFirstSegments(1));
            }
            ++n2;
        }
        return null;
    }

    public CheatSheetElement findCheatSheet(String searchId, boolean recursive) {
        Object[] cheatsheets;
        Object[] objectArray = cheatsheets = this.getCheatSheets();
        int n = cheatsheets.length;
        int n2 = 0;
        while (n2 < n) {
            Object cheatsheet = objectArray[n2];
            CheatSheetElement currentCheatSheet = (CheatSheetElement)((Object)cheatsheet);
            if (currentCheatSheet.getID().equals(searchId)) {
                return currentCheatSheet;
            }
            ++n2;
        }
        if (!recursive) {
            return null;
        }
        for (CheatSheetCollectionElement child : this.childCollections) {
            CheatSheetElement result = child.findCheatSheet(searchId, true);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast((Object)this);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public IPath getPath() {
        if (this.parent == null) {
            return IPath.fromOSString((String)"");
        }
        return this.parent.getPath().append(this.name);
    }

    public Object[] getCheatSheets() {
        return this.cheatsheets.getChildren();
    }

    public boolean isEmpty() {
        return this.childCollections.isEmpty() && this.cheatsheets.size() == 0;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setCheatSheets(AdaptableList value) {
        this.cheatsheets = value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("CheatSheetCollection, ");
        buf.append(this.childCollections.size());
        buf.append(" children, ");
        buf.append(this.cheatsheets.size());
        buf.append(" cheatsheets");
        return buf.toString();
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public Object[] getChildren() {
        return this.childCollections.toArray();
    }

    public void add(CheatSheetCollectionElement newElement) {
        this.childCollections.add(newElement);
    }
}

