/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public abstract class Transport {
    public static final String SERVICE_NAME = Transport.class.getName();
    private static final Map<String, ProtocolRule> RULES = Map.of("http", ProtocolRule.of(System.getProperty("p2.httpRule")), "ftp", ProtocolRule.of(System.getProperty("p2.ftpRule")));
    private static final boolean SKIP_REPOSITORY_PROTOCOL_CHECK = Boolean.getBoolean("p2.skipRepositoryProtocolCheck");
    private static final Pattern ARCHIVE_URI_PATTERN = Pattern.compile("(?i)(jar|zip|archive):(.*)!/(.*)");
    private final Set<URI> loggedURIs = ConcurrentHashMap.newKeySet();

    private static IEclipsePreferences getTransportPreferences() {
        return (IEclipsePreferences)ConfigurationScope.INSTANCE.getNode("org.eclipse.equinox.p2.repository").node("protocolRules");
    }

    @Deprecated(forRemoval=true)
    public IStatus download(URI toDownload, OutputStream target, long startPos, IProgressMonitor monitor) {
        if (startPos <= 0L) {
            return this.download(toDownload, target, monitor);
        }
        throw new UnsupportedOperationException("positional downloads are actually never called from P2 code and thus disabled by default, please use the method without a position instead");
    }

    public abstract IStatus download(URI var1, OutputStream var2, IProgressMonitor var3);

    public abstract InputStream stream(URI var1, IProgressMonitor var2) throws FileNotFoundException, CoreException, AuthenticationFailedException;

    public abstract long getLastModified(URI var1, IProgressMonitor var2) throws CoreException, FileNotFoundException, AuthenticationFailedException;

    public URI getSecureLocation(URI location) throws CoreException {
        String scheme = location.getScheme();
        String canonicalScheme = scheme == null ? "null" : scheme.toLowerCase();
        ProtocolRule protocolRule = this.getProtocolRule(canonicalScheme);
        if (protocolRule != null) {
            switch (protocolRule) {
                case REDIRECT: {
                    try {
                        return new URI(canonicalScheme + "s", location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), location.getQuery(), location.getFragment());
                    }
                    catch (URISyntaxException e) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                case BLOCK: {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.RepositoryTransport_unsafeProtocolBlocked, (Object)canonicalScheme, (Object)location)));
                }
            }
            if (!SKIP_REPOSITORY_PROTOCOL_CHECK && this.loggedURIs.add(location)) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.RepositoryTransport_unsafeProtocol, (Object)canonicalScheme, (Object)location)));
            }
        } else {
            Matcher matcher = ARCHIVE_URI_PATTERN.matcher(location.toString());
            if (matcher.matches()) {
                return URI.create(matcher.group(1) + ":" + String.valueOf(this.getSecureLocation(URI.create(matcher.group(2) + "!/" + matcher.group(3)))));
            }
        }
        return location;
    }

    protected ProtocolRule getProtocolRule(String scheme) {
        ProtocolRule result = this.getProtocolRules().get(scheme);
        if (result == null) {
            result = this.getDefaultProtocolRules().get(scheme);
        }
        return result;
    }

    public Map<String, ProtocolRule> getDefaultProtocolRules() {
        return RULES;
    }

    public Map<String, ProtocolRule> getProtocolRules() {
        TreeMap<String, ProtocolRule> rules = new TreeMap<String, ProtocolRule>();
        IEclipsePreferences transportPreferences = Transport.getTransportPreferences();
        Iterator<String> iterator = RULES.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String value = transportPreferences.get(key = iterator.next(), null);
            rules.put(key, value == null ? null : ProtocolRule.of(value));
        }
        return rules;
    }

    public void setProtocolRules(Map<String, ProtocolRule> rules) {
        IEclipsePreferences transportPreferences = Transport.getTransportPreferences();
        for (Map.Entry<String, ProtocolRule> entry : rules.entrySet()) {
            String key = entry.getKey();
            ProtocolRule value = entry.getValue();
            if (value == null) {
                transportPreferences.remove(key);
                continue;
            }
            transportPreferences.put(key, value.toString().toLowerCase());
        }
        try {
            transportPreferences.flush();
        }
        catch (BackingStoreException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public static enum ProtocolRule {
        ALLOW,
        REDIRECT,
        BLOCK;


        public static ProtocolRule of(String literal) {
            if (literal == null) {
                return REDIRECT;
            }
            switch (literal) {
                case "allow": {
                    return ALLOW;
                }
                case "redirect": {
                    return REDIRECT;
                }
            }
            return BLOCK;
        }
    }
}

