/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class CommonTabLite
extends AbstractLaunchConfigurationTab {
    private static final String SETTINGS_ID = "org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG";
    private static final String BAD_CONTAINER = "bad_container_name";
    private Button fLocalRadioButton;
    private Button fSharedRadioButton;
    private Text fSharedLocationText;
    private Button fSharedLocationButton;
    private CheckboxTableViewer fFavoritesTable;
    private ModifyListener fBasicModifyListener = evt -> this.updateLaunchConfigurationDialog();

    CommonTabLite() {
    }

    @Override
    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.launch_configuration_dialog_common_tab");
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setFont(parent.getFont());
        this.createSharedConfigComponent(comp);
        this.createFavoritesComponent(comp);
    }

    private void createFavoritesComponent(Composite parent) {
        Group favComp = SWTFactory.createGroup(parent, LaunchConfigurationsMessages.CommonTab_Display_in_favorites_menu__10, 1, 1, 1808);
        this.fFavoritesTable = CheckboxTableViewer.newCheckList((Composite)favComp, (int)67618);
        Control table = this.fFavoritesTable.getControl();
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
        this.fFavoritesTable.setContentProvider((IContentProvider)new FavoritesContentProvider());
        this.fFavoritesTable.setLabelProvider((IBaseLabelProvider)new FavoritesLabelProvider());
        this.fFavoritesTable.addCheckStateListener(event -> this.updateLaunchConfigurationDialog());
    }

    private void createSharedConfigComponent(Composite parent) {
        Group group = SWTFactory.createGroup(parent, LaunchConfigurationsMessages.CommonTab_0, 3, 2, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, parent.getFont(), 3, 3, 1808, 0, 0);
        this.fLocalRadioButton = this.createRadioButton(comp, LaunchConfigurationsMessages.CommonTab_L_ocal_3);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fLocalRadioButton.setLayoutData((Object)gd);
        this.fSharedRadioButton = this.createRadioButton(comp, LaunchConfigurationsMessages.CommonTab_S_hared_4);
        this.fSharedRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTabLite.this.handleSharedRadioButtonSelected();
            }
        });
        this.fSharedLocationText = SWTFactory.createSingleText(comp, 1);
        this.fSharedLocationText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchConfigurationsMessages.CommonTab_S_hared_4;
            }
        });
        this.fSharedLocationText.addModifyListener(this.fBasicModifyListener);
        this.fSharedLocationButton = this.createPushButton(comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.fSharedLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CommonTabLite.this.handleSharedLocationButtonSelected();
            }
        });
        this.fLocalRadioButton.setSelection(true);
        this.setSharedEnabled(false);
    }

    private void handleSharedRadioButtonSelected() {
        this.setSharedEnabled(this.isShared());
        this.updateLaunchConfigurationDialog();
    }

    private void setSharedEnabled(boolean enable) {
        this.fSharedLocationText.setEnabled(enable);
        this.fSharedLocationButton.setEnabled(enable);
    }

    private String getDefaultSharedConfigLocation(ILaunchConfiguration config) {
        String path = "";
        try {
            IResource[] resources = config.getMappedResources();
            if (resources != null) {
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    IProject proj = res.getProject();
                    if (proj != null && proj.isAccessible()) {
                        return proj.getFullPath().toOSString();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return path;
    }

    private boolean isShared() {
        return this.fSharedRadioButton.getSelection();
    }

    private void handleSharedLocationButtonSelected() {
        String currentContainerString = this.fSharedLocationText.getText();
        IContainer currentContainer = this.getContainer(currentContainerString);
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, LaunchConfigurationsMessages.CommonTab_Select_a_location_for_the_launch_configuration_13);
        dialog.showClosedProjects(false);
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings(), 2);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.toOSString();
            this.fSharedLocationText.setText(containerName);
        }
    }

    private IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(CommonTabLite.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    private IContainer getContainer(String path) {
        IPath containerPath = IPath.fromOSString((String)path);
        return (IContainer)this.getWorkspaceRoot().findMember(containerPath);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean isShared = !configuration.isLocal();
        this.fSharedRadioButton.setSelection(isShared);
        this.fLocalRadioButton.setSelection(!isShared);
        this.setSharedEnabled(isShared);
        this.fSharedLocationText.setText(this.getDefaultSharedConfigLocation(configuration));
        if (isShared) {
            IContainer parent;
            String containerName = "";
            IFile file = configuration.getFile();
            if (file != null && (parent = file.getParent()) != null) {
                containerName = parent.getFullPath().toOSString();
            }
            this.fSharedLocationText.setText(containerName);
        }
        this.updateFavoritesFromConfig(configuration);
    }

    private void updateFavoritesFromConfig(ILaunchConfiguration config) {
        this.fFavoritesTable.setInput((Object)config);
        this.fFavoritesTable.setCheckedElements(new Object[0]);
        try {
            List groups = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", new ArrayList());
            if (groups.isEmpty()) {
                if (config.getAttribute("org.eclipse.debug.ui.debugFavorite", false)) {
                    groups.add("org.eclipse.debug.ui.launchGroup.debug");
                }
                if (config.getAttribute("org.eclipse.debug.ui.runFavorite", false)) {
                    groups.add("org.eclipse.debug.ui.launchGroup.run");
                }
            }
            if (!groups.isEmpty()) {
                ArrayList<LaunchGroupExtension> list = new ArrayList<LaunchGroupExtension>();
                for (String id : groups) {
                    LaunchGroupExtension extension = this.getLaunchConfigurationManager().getLaunchGroup(id);
                    if (extension == null) continue;
                    list.add(extension);
                }
                this.fFavoritesTable.setCheckedElements(list.toArray());
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private void updateConfigFromLocalShared(ILaunchConfigurationWorkingCopy config) {
        if (this.isShared()) {
            String containerPathString = this.fSharedLocationText.getText();
            IContainer container = this.getContainer(containerPathString);
            if (container == null) {
                config.setAttribute(BAD_CONTAINER, containerPathString);
            } else {
                config.setContainer(container);
            }
        } else {
            config.setContainer(null);
        }
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    private void updateConfigFromFavorites(ILaunchConfigurationWorkingCopy config) {
        try {
            ArrayList<Object> groups;
            Object[] checked = this.fFavoritesTable.getCheckedElements();
            boolean debug = config.getAttribute("org.eclipse.debug.ui.debugFavorite", false);
            boolean run = config.getAttribute("org.eclipse.debug.ui.runFavorite", false);
            if (debug || run) {
                groups = new ArrayList<Object>();
                int num = 0;
                if (debug) {
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.debug"));
                    ++num;
                }
                if (run) {
                    ++num;
                    groups.add(this.getLaunchConfigurationManager().getLaunchGroup("org.eclipse.debug.ui.launchGroup.run"));
                }
                if (num == checked.length) {
                    boolean different = false;
                    Object[] objectArray = checked;
                    int n = checked.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object c = objectArray[n2];
                        if (!groups.contains(c)) {
                            different = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!different) {
                        return;
                    }
                }
            }
            config.setAttribute("org.eclipse.debug.ui.debugFavorite", null);
            config.setAttribute("org.eclipse.debug.ui.runFavorite", null);
            groups = null;
            Object[] objectArray = checked;
            int n = checked.length;
            int n3 = 0;
            while (n3 < n) {
                Object c = objectArray[n3];
                LaunchGroupExtension group = (LaunchGroupExtension)c;
                if (groups == null) {
                    groups = new ArrayList();
                }
                groups.add(group.getIdentifier());
                ++n3;
            }
            config.setAttribute("org.eclipse.debug.ui.favoriteGroups", groups);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateLocalShared();
    }

    private boolean validateLocalShared() {
        if (this.isShared()) {
            String path = this.fSharedLocationText.getText().trim();
            IContainer container = this.getContainer(path);
            if (container == null || container.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Invalid_shared_configuration_location_14);
                return false;
            }
            if (!container.getProject().isOpen()) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Cannot_save_launch_configuration_in_a_closed_project__1);
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setContainer(null);
        this.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", config, true, true);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.updateConfigFromLocalShared(configuration);
        this.updateConfigFromFavorites(configuration);
    }

    @Override
    public String getName() {
        return LaunchConfigurationsMessages.CommonTab__Common_15;
    }

    @Override
    public String getId() {
        return "org.eclipse.debug.ui.commonTab";
    }

    @Override
    public boolean canSave() {
        return this.validateLocalShared();
    }

    @Override
    public Image getImage() {
        return DebugUITools.getImage("IMG_OBJS_COMMON_TAB");
    }

    @Override
    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    @Override
    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    class FavoritesContentProvider
    implements IStructuredContentProvider {
        FavoritesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
            ArrayList<ILaunchGroup> possibleGroups = new ArrayList<ILaunchGroup>();
            ILaunchConfiguration configuration = (ILaunchConfiguration)inputElement;
            ILaunchGroup[] iLaunchGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchGroup extension = iLaunchGroupArray[n2];
                LaunchHistory history = CommonTabLite.this.getLaunchConfigurationManager().getLaunchHistory(extension.getIdentifier());
                if (history != null && history.accepts(configuration)) {
                    possibleGroups.add(extension);
                }
                ++n2;
            }
            return possibleGroups.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class FavoritesLabelProvider
    implements ITableLabelProvider {
        private Map<Object, Image> fImages = new HashMap<Object, Image>();

        FavoritesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ImageDescriptor descriptor;
            Image image = this.fImages.get(element);
            if (image == null && (descriptor = ((LaunchGroupExtension)element).getImageDescriptor()) != null) {
                image = descriptor.createImage();
                this.fImages.put(element, image);
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = ((LaunchGroupExtension)element).getLabel();
            return DebugUIPlugin.removeAccelerators(label);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            for (Image image : this.fImages.values()) {
                image.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

