/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.ILog;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.webapp.data.CssUtil;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.WebappPreferences;
import org.eclipse.help.internal.xhtml.DynamicXHTMLProcessor;

public class PrintData
extends RequestData {
    private static final int defaultMaxConnections = 10;
    private static final int defaultMaxTopics = 500;
    private static final Pattern PATTERN_HEADING = Pattern.compile("<body.*?>[\\s]*?([^<\\s])", 42);
    private static final Pattern PATTERN_LINK = Pattern.compile("(src|href)=\"(.*?\")", 42);
    private static final Pattern PATTERN_END_HEAD = Pattern.compile("</head.*?>", 42);
    private static boolean initialized = false;
    private static int allowedConnections;
    private static int allowedMaxTopics;
    private boolean confirmed;
    private boolean isRTL;
    private AbstractHelpScope scope;

    public PrintData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        if (!initialized) {
            PrintData.initPreferences(this.preferences);
        }
        this.isRTL = UrlUtil.isRTL(request, response);
        this.scope = RequestScope.getScope(request, response, false);
        String confirmString = request.getParameter("confirmed");
        this.confirmed = confirmString != null && "true".equals(confirmString);
    }

    public String getTitle() {
        return this.getTopic().getLabel();
    }

    public String getTocHref() {
        return this.getToc().getHref();
    }

    public String getTopicHref() {
        return this.getTopic().getHref();
    }

    private static synchronized void initPreferences(WebappPreferences preferences) {
        if (initialized) {
            return;
        }
        String maxConnections = preferences.getQuickPrintMaxConnections();
        if (maxConnections == null || "".equals(maxConnections.trim())) {
            allowedConnections = 10;
        } else {
            try {
                allowedConnections = Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException e) {
                ILog.of(PrintData.class).error("Init maxConnections error. Set to default.", (Throwable)e);
                allowedConnections = 10;
            }
        }
        String maxTopics = preferences.getQuickPrintMaxTopics();
        if (maxTopics == null || "".equals(maxTopics.trim())) {
            allowedMaxTopics = 500;
        } else {
            try {
                allowedMaxTopics = Integer.parseInt(maxTopics);
            }
            catch (NumberFormatException e) {
                ILog.of(PrintData.class).error("Init maxTopics error. Set to default.", (Throwable)e);
                allowedMaxTopics = 500;
            }
        }
        initialized = true;
    }

    public void generateResources(Writer out) throws IOException, ServletException {
        if (!PrintData.getConnection()) {
            RequestDispatcher rd = this.context.getRequestDispatcher("/advanced/printError.jsp");
            this.request.setAttribute("msg", (Object)"noConnection");
            rd.forward((ServletRequest)this.request, (ServletResponse)this.response);
            return;
        }
        ITopic topic = this.getTopic();
        int topicRequested = this.topicsRequested(topic);
        if (topicRequested > allowedMaxTopics && !this.confirmed) {
            PrintData.releaseConnection();
            RequestDispatcher rd = this.context.getRequestDispatcher("/advanced/printConfirm.jsp");
            this.request.setAttribute("topicsRequested", (Object)String.valueOf(topicRequested));
            this.request.setAttribute("allowedMaxTopics", (Object)String.valueOf(allowedMaxTopics));
            rd.forward((ServletRequest)this.request, (ServletResponse)this.response);
            return;
        }
        try {
            try {
                this.generateToc(out);
                this.generateContent(out);
            }
            catch (IOException iOException) {
                RequestDispatcher rd = this.context.getRequestDispatcher("/advanced/printError.jsp");
                this.request.setAttribute("msg", (Object)"ioException");
                rd.forward((ServletRequest)this.request, (ServletResponse)this.response);
                PrintData.releaseConnection();
            }
        }
        finally {
            PrintData.releaseConnection();
        }
    }

    private static synchronized boolean getConnection() {
        if (allowedConnections > 0) {
            --allowedConnections;
            return true;
        }
        return false;
    }

    private static synchronized void releaseConnection() {
        ++allowedConnections;
    }

    private int topicsRequested(ITopic topic) {
        ITopic[] subtopics;
        int topicsRequested = 0;
        if (topic.getHref() != null && topic.getHref().length() > 0) {
            ++topicsRequested;
        }
        ITopic[] iTopicArray = subtopics = ScopeUtils.inScopeTopics((ITopic[])topic.getSubtopics(), (AbstractHelpScope)this.scope);
        int n = subtopics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic subtopic = iTopicArray[n2];
            topicsRequested += this.topicsRequested(subtopic);
            ++n2;
        }
        return topicsRequested;
    }

    private void generateToc(Writer out) throws IOException {
        int tocGenerated = 0;
        out.write("<html>\n");
        out.write("<head>\n");
        out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        out.write("<title>" + UrlUtil.htmlEncode(this.getTitle()) + "</title>\n");
        out.write("<link rel=\"stylesheet\" href=\"print.css\" charset=\"utf-8\" type=\"text/css\">\n");
        out.write("</head>\n");
        out.write("<body dir=\"" + (this.isRTL ? "right" : "left") + "\" onload=\"print()\">\n");
        out.write("<div id=\"toc\">\n");
        out.write("<h1>");
        out.write(this.getTitle());
        out.write("</h1>\n");
        out.write("<h2>");
        out.write(ServletResources.getString("TocHeading", this.request));
        out.write("</h2>\n");
        out.write("<div id=\"toc_content\">\n");
        ITopic topic = this.getTopic();
        String href = topic.getHref();
        if (href != null && href.length() > 0) {
            ++tocGenerated;
        }
        ITopic[] subtopics = ScopeUtils.inScopeTopics((ITopic[])topic.getSubtopics(), (AbstractHelpScope)this.scope);
        int i = 0;
        while (i < subtopics.length) {
            tocGenerated = this.generateToc(subtopics[i], String.valueOf(i + 1), tocGenerated, out);
            ++i;
        }
        out.write("</div>\n");
        out.write("</div>\n");
        out.write("</body>\n");
        out.write("</html>\n");
    }

    private int generateToc(ITopic topic, String sectionId, int tocGenerated, Writer out) throws IOException {
        if (tocGenerated < allowedMaxTopics) {
            out.write("<div class=\"toc_" + (sectionId.length() > 2 ? "sub" : "") + "entry\">\n");
            String hrefContent = sectionId + ". <a href=\"#section" + sectionId + "\">" + topic.getLabel() + "</a>\n";
            String href = topic.getHref();
            if (href != null && href.length() > 0) {
                ++tocGenerated;
                if (href.contains("#")) {
                    hrefContent = sectionId + ". <a href=\"" + PrintData.getAnchor(href) + "\">" + topic.getLabel() + "</a>\n";
                }
            }
            out.write(hrefContent);
            ITopic[] subtopics = ScopeUtils.inScopeTopics((ITopic[])topic.getSubtopics(), (AbstractHelpScope)this.scope);
            int i = 0;
            while (i < subtopics.length) {
                String subsectionId = sectionId + "." + (i + 1);
                tocGenerated = this.generateToc(subtopics[i], subsectionId, tocGenerated, out);
                ++i;
            }
            out.write("</div>\n");
            return tocGenerated;
        }
        return tocGenerated;
    }

    public void generateContent(Writer out) throws IOException {
        int topicsGenerated = 0;
        this.generateContent(this.getTopic(), null, topicsGenerated, new HashSet<String>(), out);
    }

    private int generateContent(ITopic topic, String sectionId, int topicsGenerated, Set<String> generated, Writer out) throws IOException {
        if (topicsGenerated < allowedMaxTopics) {
            String href = topic.getHref();
            if (href != null && href.length() > 0) {
                ++topicsGenerated;
                href = PrintData.removeAnchor(href);
                String pathHref = href.substring(0, href.lastIndexOf(47) + 1);
                String baseHref = "../topic" + pathHref;
                if (!generated.contains(href)) {
                    generated.add(href);
                    String content = this.getContent(href, this.locale);
                    if (sectionId != null) {
                        content = PrintData.injectHeading(content, sectionId);
                    }
                    content = this.normalizeHrefs(content, baseHref);
                    content = this.injectCss(content);
                    out.write(content);
                }
            }
            ITopic[] subtopics = ScopeUtils.inScopeTopics((ITopic[])topic.getSubtopics(), (AbstractHelpScope)this.scope);
            int i = 0;
            while (i < subtopics.length) {
                String subsectionId = (String)(sectionId != null ? sectionId + "." : "") + (i + 1);
                topicsGenerated = this.generateContent(subtopics[i], subsectionId, topicsGenerated, generated, out);
                ++i;
            }
            return topicsGenerated;
        }
        return topicsGenerated;
    }

    public static String injectHeading(String content, String sectionId) {
        Matcher matcher = PATTERN_HEADING.matcher(content);
        if (matcher.find()) {
            String heading = "<a id=\"section" + sectionId + "\">" + sectionId + ". </a>";
            return content.substring(0, matcher.start(1)) + heading + content.substring(matcher.start(1));
        }
        return content;
    }

    private String injectCss(String content) {
        Matcher matcher = PATTERN_END_HEAD.matcher(content);
        if (matcher.find()) {
            String css = this.getCssIncludes();
            return content.substring(0, matcher.start(0)) + css + content.substring(matcher.start(0));
        }
        return content;
    }

    private String normalizeHrefs(String content, String baseHref) {
        StringBuilder buf = new StringBuilder();
        Matcher matcher = PATTERN_LINK.matcher(content);
        int prev = 0;
        while (matcher.find()) {
            buf.append(content.substring(prev, matcher.start(2)));
            buf.append(baseHref);
            buf.append(matcher.group(2));
            prev = matcher.end();
        }
        buf.append(content.substring(prev));
        return buf.toString();
    }

    private String getContent(String href, String locale) {
        StringBuilder buf;
        block33: {
            InputStream in = HelpSystem.getHelpContent((String)href, (String)locale);
            buf = new StringBuilder();
            InputStream rawInput = null;
            if (in != null) {
                try {
                    try {
                        boolean filter;
                        String charset = HTMLDocParser.getCharsetFromHTML((InputStream)in);
                        if (charset == null) {
                            charset = "UTF-8";
                        }
                        if ((in = DynamicXHTMLProcessor.process((String)href, (InputStream)(rawInput = HelpSystem.getHelpContent((String)href, (String)locale)), (String)locale, (boolean)(filter = BaseHelpSystem.getMode() != 1))) == null) {
                            in = HelpSystem.getHelpContent((String)href, (String)locale);
                        }
                        Throwable throwable = null;
                        Object var9_12 = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));){
                            int num;
                            char[] cbuf = new char[4096];
                            while ((num = reader.read(cbuf)) > 0) {
                                buf.append(cbuf, 0, num);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        String msg = "Error retrieving print preview content for " + href;
                        ILog.of(this.getClass()).error(msg, (Throwable)e);
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            if (rawInput != null) {
                                rawInput.close();
                            }
                            break block33;
                        }
                        catch (Exception exception) {}
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        if (rawInput != null) {
                            rawInput.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    if (rawInput != null) {
                        rawInput.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return buf.toString();
    }

    private IToc getToc() {
        String tocParam = this.request.getParameter("toc");
        if (tocParam != null && tocParam.length() > 0) {
            return HelpPlugin.getTocManager().getToc(tocParam, this.getLocale());
        }
        String topicParam = this.request.getParameter("topic");
        if (topicParam != null && topicParam.length() > 0) {
            Toc[] tocs;
            if (topicParam.startsWith("/../nav/")) {
                String navPath = topicParam.substring(8);
                StringTokenizer tok = new StringTokenizer(navPath, "_");
                int index = Integer.parseInt(tok.nextToken());
                return HelpPlugin.getTocManager().getTocs(this.getLocale())[index];
            }
            Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            int n = tocs.length;
            int n2 = 0;
            while (n2 < n) {
                Toc toc = tocArray[n2];
                if (toc.getTopic(topicParam) != null) {
                    return toc;
                }
                ++n2;
            }
        }
        return null;
    }

    private ITopic getTopic() {
        Object topicParam = this.request.getParameter("topic");
        String anchorParam = this.request.getParameter("anchor");
        if (anchorParam != null) {
            topicParam = (String)topicParam + "#" + anchorParam;
        }
        if (topicParam != null && ((String)topicParam).length() > 0) {
            Toc[] tocs;
            if (((String)topicParam).startsWith("/../nav/")) {
                String navPath = ((String)topicParam).substring(8);
                StringTokenizer tok = new StringTokenizer(navPath, "_");
                int index = Integer.parseInt(tok.nextToken());
                ITopic topic = HelpPlugin.getTocManager().getTocs(this.getLocale())[index].getTopic(null);
                while (tok.hasMoreTokens()) {
                    index = Integer.parseInt(tok.nextToken());
                    topic = topic.getSubtopics()[index];
                }
                return topic;
            }
            Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
            int n = tocs.length;
            int n2 = 0;
            while (n2 < n) {
                Toc toc = tocArray[n2];
                ITopic topic = toc.getTopic((String)topicParam);
                if (topic != null) {
                    return topic;
                }
                topic = toc.getTopic(null);
                if (((String)topicParam).equals(topic.getHref())) {
                    return topic;
                }
                ++n2;
            }
            return null;
        }
        return this.getToc().getTopic(null);
    }

    private static String removeAnchor(String href) {
        int index = href.indexOf(35);
        if (index != -1) {
            return href.substring(0, index);
        }
        return href;
    }

    private static String getAnchor(String href) {
        int index = href.indexOf(35);
        if (index != -1) {
            return href.substring(index);
        }
        return "";
    }

    private String getCssIncludes() {
        ArrayList<String> css = new ArrayList<String>();
        CssUtil.addCssFiles("topic_css", css);
        return CssUtil.createCssIncludes(css, "../");
    }
}

