/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.io.IOUtils;

public class CompressUtils {
    public static void unarchive(URL archiveURL, File baseDir) throws IOException {
        if (archiveURL == null || baseDir == null) {
            return;
        }
        TarArchiveInputStream archive = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = archiveURL.openStream();){
            if (archiveURL.getFile().endsWith(".tar.gz")) {
                GzipCompressorInputStream gz = new GzipCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)gz);
            } else if (archiveURL.getFile().endsWith(".tar.xz")) {
                XZCompressorInputStream xz = new XZCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)xz);
            } else if (archiveURL.getFile().endsWith(".zip")) {
                archive = new ZipArchiveInputStream(input);
            } else {
                throw new UnsupportedCompressionAlgorithmException("Unsupported archive file extension: " + String.valueOf(archive));
            }
            try {
                CompressUtils.extractArchive(archive, baseDir);
            }
            finally {
                IOUtils.closeQuietly((InputStream)archive);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void extractArchive(ArchiveInputStream<?> in, File destination) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            TarArchiveEntry tarEntry;
            boolean symlink;
            if (!in.canReadEntryData(entry)) continue;
            File f = new File(destination, entry.getName());
            f.delete();
            boolean bl = symlink = entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink();
            if (entry.isDirectory()) {
                if (f.isDirectory() || f.mkdirs()) continue;
                throw new IOException("failed to create directory " + String.valueOf(f));
            }
            File parent = f.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + String.valueOf(parent));
            }
            if (symlink) {
                linkName = ((TarArchiveEntry)entry).getLinkName();
                Files.createSymbolicLink(f.toPath(), Paths.get((String)linkName, new String[0]), new FileAttribute[0]);
            } else {
                linkName = null;
                Object var8_9 = null;
                try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                    IOUtils.copy(in, (OutputStream)o);
                }
                catch (Throwable throwable) {
                    if (linkName == null) {
                        linkName = throwable;
                    } else if (linkName != throwable) {
                        ((Throwable)linkName).addSuppressed(throwable);
                    }
                    throw linkName;
                }
            }
            if (!(entry instanceof TarArchiveEntry)) continue;
            TarArchiveEntry tarEntry2 = (TarArchiveEntry)entry;
            f.setExecutable((tarEntry2.getMode() & 0x100) != 0);
        }
    }
}

