/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.vue;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class VueLanguageServer
extends ProcessStreamConnectionProvider {
    private static String tsserverPath = null;
    private static String vuePath = null;

    public VueLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        try {
            if (vuePath == null || tsserverPath == null) {
                this.resolvePaths();
            }
            commands.add(vuePath);
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private void resolvePaths() throws IOException {
        URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/@vue/language-server/bin/vue-language-server.js"));
        vuePath = new File(url.getPath()).getAbsolutePath();
        url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/typescript/lib"));
        tsserverPath = new File(url.getPath()).getAbsolutePath();
    }

    protected ProcessBuilder createProcessBuilder() {
        ProcessBuilder builder = super.createProcessBuilder();
        builder.environment().put("VUE_NONPOLLING_WATCHER", Boolean.toString(true));
        return builder;
    }

    public Object getInitializationOptions(URI rootUri) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        this.setWorkingDirectory(rootUri.getRawPath());
        options.put("typescript", Collections.singletonMap("tsdk", tsserverPath));
        options.put("diagnosticModel", 0);
        options.put("additionalExtensions", new String[0]);
        HashMap<String, String[]> legend = new HashMap<String, String[]>();
        legend.put("tokenTypes", new String[]{"component"});
        legend.put("tokenModifiers", new String[0]);
        options.put("semanticTokensLegend", legend);
        HashMap<String, Boolean> vue = new HashMap<String, Boolean>();
        vue.put("hybridMode", false);
        options.put("vue", vue);
        return options;
    }

    public String toString() {
        return "VUE Language Server: " + super.toString();
    }
}

