"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
const baseParse_1 = require("./baseParse");
function register(htmlLs) {
    return (pugCode) => {
        const parsed = (0, baseParse_1.baseParse)(pugCode);
        const htmlTextDocument = vscode_languageserver_textdocument_1.TextDocument.create('foo.html', 'html', 0, parsed.htmlCode);
        const sourceMap = new language_service_1.SourceMapWithDocuments(parsed.pugTextDocument, htmlTextDocument, new language_service_1.SourceMap(parsed.mappings));
        const htmlDocument = htmlLs.parseHTMLDocument(htmlTextDocument);
        return {
            ...parsed,
            htmlTextDocument,
            htmlDocument,
            map: sourceMap,
        };
    };
}
exports.register = register;
//# sourceMappingURL=pugDocument.js.map