/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Arguments for 'locations' request.
 * <p>
 * Since 1.68
 */
@SuppressWarnings("all")
public class LocationsArguments {
  /**
   * Location reference to resolve.
   */
  @NonNull
  private Integer locationReference;

  /**
   * Location reference to resolve.
   */
  @NonNull
  public Integer getLocationReference() {
    return this.locationReference;
  }

  /**
   * Location reference to resolve.
   */
  public void setLocationReference(@NonNull final Integer locationReference) {
    this.locationReference = Preconditions.checkNotNull(locationReference, "locationReference");
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("locationReference", this.locationReference);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    LocationsArguments other = (LocationsArguments) obj;
    if (this.locationReference == null) {
      if (other.locationReference != null)
        return false;
    } else if (!this.locationReference.equals(other.locationReference))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.locationReference== null) ? 0 : this.locationReference.hashCode());
  }
}
