/**
 * Copyright (c) 2025, Fabian Groffen. All rights reserved.
 *
 * See LICENSE for the license.
 */

#ifndef UTIL_H
#define UTIL_H 1

#include <ldns/ldns.h>

ldns_rdf *
util_addr2dname
(
    ldns_rdf *input,
    bool      useip6intdomain
);

ldns_rdf *
util_dname_frm_str
(
    const char *input,
    uint8_t     ndots,
    bool        useip6intdomain
);

ldns_rdf **
util_addr_frm_str
(
    ldns_resolver *res,
    const char    *input,
    uint8_t        ndots
);

#endif
