/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.SearchOption;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.0")
public final class AnnotationSupport {
    private AnnotationSupport() {
    }

    @API(status=API.Status.MAINTAINED, since="1.3")
    public static boolean isAnnotated(Optional<? extends AnnotatedElement> element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotated(element, annotationType);
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotated(element, annotationType);
    }

    @API(status=API.Status.MAINTAINED, since="1.1")
    public static <A extends Annotation> Optional<A> findAnnotation(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType);
    }

    public static <A extends Annotation> Optional<A> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(element, annotationType);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8")
    public static <A extends Annotation> Optional<A> findAnnotation(Class<?> clazz, Class<A> annotationType, SearchOption searchOption) {
        Preconditions.notNull(searchOption, "SearchOption must not be null");
        return AnnotationUtils.findAnnotation(clazz, annotationType, searchOption == SearchOption.INCLUDE_ENCLOSING_CLASSES);
    }

    @API(status=API.Status.MAINTAINED, since="1.5")
    public static <A extends Annotation> List<A> findRepeatableAnnotations(Optional<? extends AnnotatedElement> element, Class<A> annotationType) {
        return AnnotationUtils.findRepeatableAnnotations(element, annotationType);
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtils.findRepeatableAnnotations(element, annotationType);
    }

    public static List<Field> findPublicAnnotatedFields(Class<?> clazz, Class<?> fieldType, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findPublicAnnotatedFields(clazz, fieldType, annotationType);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotatedFields(clazz, annotationType, field -> true);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return AnnotationUtils.findAnnotatedFields(clazz, annotationType, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Object> findAnnotatedFieldValues(Object instance, Class<? extends Annotation> annotationType) {
        Preconditions.notNull(instance, "instance must not be null");
        List<Field> fields = AnnotationSupport.findAnnotatedFields(instance.getClass(), annotationType, ModifierSupport::isNotStatic, HierarchyTraversalMode.TOP_DOWN);
        return ReflectionUtils.readFieldValues(fields, instance);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Object> findAnnotatedFieldValues(Class<?> clazz, Class<? extends Annotation> annotationType) {
        List<Field> fields = AnnotationSupport.findAnnotatedFields(clazz, annotationType, ModifierSupport::isStatic, HierarchyTraversalMode.TOP_DOWN);
        return ReflectionUtils.readFieldValues(fields, null);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static <T> List<T> findAnnotatedFieldValues(Object instance, Class<? extends Annotation> annotationType, Class<T> fieldType) {
        Preconditions.notNull(instance, "instance must not be null");
        Preconditions.notNull(fieldType, "fieldType must not be null");
        Predicate<Field> predicate = field -> ModifierSupport.isNotStatic(field) && fieldType.isAssignableFrom(field.getType());
        List<Field> fields = AnnotationSupport.findAnnotatedFields(instance.getClass(), annotationType, predicate, HierarchyTraversalMode.TOP_DOWN);
        return ReflectionUtils.readFieldValues(fields, instance);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static <T> List<T> findAnnotatedFieldValues(Class<?> clazz, Class<? extends Annotation> annotationType, Class<T> fieldType) {
        Preconditions.notNull(fieldType, "fieldType must not be null");
        Predicate<Field> predicate = field -> ModifierSupport.isStatic(field) && fieldType.isAssignableFrom(field.getType());
        List<Field> fields = AnnotationSupport.findAnnotatedFields(clazz, annotationType, predicate, HierarchyTraversalMode.TOP_DOWN);
        return ReflectionUtils.readFieldValues(fields, null);
    }

    public static List<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return AnnotationUtils.findAnnotatedMethods(clazz, annotationType, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }
}

