/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import jlibs.core.graph.sequences.AbstractSequence;

public class ArraySequence<E>
extends AbstractSequence<E> {
    private E[] array;
    private int start;
    private int end;
    private int pos;

    public ArraySequence(E ... array) {
        this(array, 0, array.length);
    }

    public ArraySequence(E[] array, int start, int end) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        if (end > array.length) {
            throw new ArrayIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new IllegalArgumentException(String.format("start(%d) must be less than or equal to end(%d)", start, end));
        }
        this.array = array;
        this.start = start;
        this.end = end;
        this._reset();
    }

    @Override
    protected E findNext() {
        ++this.pos;
        return this.pos < this.end ? (E)this.array[this.pos] : null;
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.pos = this.start - 1;
    }

    @Override
    public ArraySequence<E> copy() {
        return new ArraySequence<E>(this.array, this.start, this.end);
    }

    @Override
    public int length() {
        return this.end - this.start;
    }
}

