/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.IOException;
import java.io.InputStream;
import org.dita.dost.exception.StopParsingException;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.writer.ImageMetadataFilter;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SvgMetadataReader
extends AbstractXMLReader {
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String SVG_ELEM = "svg";
    private static final String SVG_NS = "http://www.w3.org/2000/svg";
    private ImageMetadataFilter.Dimensions dimensions;

    @Override
    public void startDocument() throws SAXException {
        this.dimensions = new ImageMetadataFilter.Dimensions();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (SVG_NS.equals(uri) && (SVG_ELEM.equals(localName) || SVG_ELEM.equals(qName) || qName != null && qName.startsWith("svg:"))) {
            this.dimensions.width = atts.getValue(WIDTH_ATTR);
            this.dimensions.height = atts.getValue(HEIGHT_ATTR);
            throw new StopParsingException();
        }
    }

    public ImageMetadataFilter.Dimensions getDimensions() {
        return this.dimensions;
    }

    public static class EmptyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            });
        }
    }
}

