/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.tooling.builders;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.kotlin.dsl.resolver.EditorMessages;
import org.gradle.kotlin.dsl.tooling.builders.DefaultEditorPosition;
import org.gradle.kotlin.dsl.tooling.builders.DefaultEditorReport;
import org.gradle.kotlin.dsl.tooling.builders.EditorReportsBuilderKt;
import org.gradle.kotlin.dsl.tooling.models.EditorReport;
import org.gradle.kotlin.dsl.tooling.models.EditorReportSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a,\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u001a4\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b*\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000bH\u0002\u001a\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0082\u0010\u001a\u001a\u0010\u0016\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b*\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b*\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u000e*\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0082\u0010\u001a\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000eH\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0002\u001a\u0018\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020\u0004H\u0000\u001a\f\u0010(\u001a\u00020)*\u00020\u0004H\u0002\u001a\f\u0010(\u001a\u00020)*\u00020*H\u0002\"\u0018\u0010\u001c\u001a\u00020\t*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"buildEditorReportsFor", "", "Lorg/gradle/kotlin/dsl/tooling/models/EditorReport;", "scriptFile", "Ljava/io/File;", "exceptions", "Ljava/lang/Exception;", "Lkotlin/Exception;", "locationAwareHints", "", "inferEditorReportsFrom", "Lkotlin/sequences/Sequence;", "reportExceptionsNotLocatedIn", "", "Lorg/gradle/internal/exceptions/LocationAwareException;", "reports", "", "reportRuntimeExceptionsLocatedIn", "findLocationAwareExceptions", "firstLocationAwareCauseOrNull", "ex", "", "anyNotLocatedIn", "scriptPath", "", "runtimeFailuresLocatedInAndNotCausedScriptCompilation", "runtimeFailuresLocatedIn", "runtimeFailureLocatedIn", "isCausedByScriptCompilationException", "(Lorg/gradle/internal/exceptions/LocationAwareException;)Z", "messageForLocationAwareEditorHint", "failure", "wholeFileWarning", "Lorg/gradle/kotlin/dsl/tooling/builders/DefaultEditorReport;", "message", "lineWarning", "line", "", "readLinesRange", "Lkotlin/ranges/LongRange;", "countLines", "", "Ljava/io/BufferedInputStream;", "kotlin-dsl-tooling-builders"})
@SourceDebugExtension(value={"SMAP\nEditorReportsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorReportsBuilder.kt\norg/gradle/kotlin/dsl/tooling/builders/EditorReportsBuilderKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1321#2,2:220\n1255#2,2:222\n1#3:224\n*S KotlinDebug\n*F\n+ 1 EditorReportsBuilder.kt\norg/gradle/kotlin/dsl/tooling/builders/EditorReportsBuilderKt\n*L\n82#1:220,2\n108#1:222,2\n*E\n"})
public final class EditorReportsBuilderKt {
    @NotNull
    public static final List<EditorReport> buildEditorReportsFor(@Nullable File scriptFile, @NotNull List<? extends Exception> exceptions, boolean locationAwareHints) {
        List<EditorReport> list;
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        if (scriptFile == null || exceptions.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            File file = scriptFile.getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
            list = EditorReportsBuilderKt.inferEditorReportsFrom(file, (Sequence<? extends Exception>)CollectionsKt.asSequence((Iterable)exceptions), locationAwareHints);
        }
        return list;
    }

    private static final List<EditorReport> inferEditorReportsFrom(File scriptFile, Sequence<? extends Exception> exceptions, boolean locationAwareHints) {
        Sequence<LocationAwareException> locatedExceptions = EditorReportsBuilderKt.findLocationAwareExceptions(exceptions);
        List reports = new ArrayList();
        EditorReportsBuilderKt.reportExceptionsNotLocatedIn(scriptFile, locatedExceptions, reports);
        EditorReportsBuilderKt.reportRuntimeExceptionsLocatedIn(scriptFile, locatedExceptions, locationAwareHints, reports);
        return reports;
    }

    private static final void reportExceptionsNotLocatedIn(File scriptFile, Sequence<? extends LocationAwareException> exceptions, List<EditorReport> reports) {
        String string = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (EditorReportsBuilderKt.anyNotLocatedIn(exceptions, string)) {
            reports.add(EditorReportsBuilderKt.wholeFileWarning("Build configuration failed, run 'gradle tasks' for more information"));
        }
    }

    private static final void reportRuntimeExceptionsLocatedIn(File scriptFile, Sequence<? extends LocationAwareException> exceptions, boolean locationAwareHints, List<EditorReport> reports) {
        LongRange actualLinesRange = locationAwareHints ? EditorReportsBuilderKt.readLinesRange(scriptFile) : LongRange.Companion.getEMPTY();
        String string = scriptFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Sequence<LocationAwareException> $this$forEach$iv = EditorReportsBuilderKt.runtimeFailuresLocatedInAndNotCausedScriptCompilation(exceptions, string);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            LongRange longRange;
            LocationAwareException failure = (LocationAwareException)element$iv;
            boolean bl = false;
            Integer lineNumber = failure.getLineNumber();
            boolean bl2 = locationAwareHints && lineNumber != null && RangesKt.longRangeContains((ClosedRange)((ClosedRange)(longRange = actualLinesRange)), (int)(n = lineNumber.intValue())) ? reports.add(EditorReportsBuilderKt.lineWarning(EditorReportsBuilderKt.messageForLocationAwareEditorHint(failure), lineNumber)) : reports.add(EditorReportsBuilderKt.wholeFileWarning("This script caused build configuration to fail, run 'gradle tasks' for more information"));
        }
    }

    private static final Sequence<LocationAwareException> findLocationAwareExceptions(Sequence<? extends Exception> $this$findLocationAwareExceptions) {
        return SequencesKt.mapNotNull($this$findLocationAwareExceptions, (Function1)findLocationAwareExceptions.1.INSTANCE);
    }

    private static final LocationAwareException firstLocationAwareCauseOrNull(Throwable ex) {
        while (!(ex instanceof LocationAwareException)) {
            Throwable cause;
            if (ex.getCause() == null) {
                return null;
            }
            ex = cause;
        }
        return (LocationAwareException)ex;
    }

    private static final boolean anyNotLocatedIn(Sequence<? extends LocationAwareException> $this$anyNotLocatedIn, String scriptPath) {
        boolean bl;
        block1: {
            Sequence<? extends LocationAwareException> $this$any$iv = $this$anyNotLocatedIn;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                LocationAwareException it = (LocationAwareException)element$iv;
                boolean bl2 = false;
                String string = it.getMessage();
                boolean bl3 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)scriptPath, (boolean)false, (int)2, null) : false;
                if (!(!bl3)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final Sequence<LocationAwareException> runtimeFailuresLocatedInAndNotCausedScriptCompilation(Sequence<? extends Exception> $this$runtimeFailuresLocatedInAndNotCausedScriptCompilation, String scriptPath) {
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull($this$runtimeFailuresLocatedInAndNotCausedScriptCompilation, arg_0 -> EditorReportsBuilderKt.runtimeFailuresLocatedInAndNotCausedScriptCompilation$lambda$2(scriptPath, arg_0)), EditorReportsBuilderKt::runtimeFailuresLocatedInAndNotCausedScriptCompilation$lambda$3);
    }

    @NotNull
    public static final Sequence<LocationAwareException> runtimeFailuresLocatedIn(@NotNull Sequence<? extends Exception> $this$runtimeFailuresLocatedIn, @NotNull String scriptPath) {
        Intrinsics.checkNotNullParameter($this$runtimeFailuresLocatedIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        return SequencesKt.mapNotNull($this$runtimeFailuresLocatedIn, arg_0 -> EditorReportsBuilderKt.runtimeFailuresLocatedIn$lambda$4(scriptPath, arg_0));
    }

    private static final LocationAwareException runtimeFailureLocatedIn(Throwable $this$runtimeFailureLocatedIn, String scriptPath) {
        while (true) {
            Throwable next;
            if ($this$runtimeFailureLocatedIn instanceof LocationAwareException) {
                String string = ((LocationAwareException)$this$runtimeFailureLocatedIn).getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)scriptPath, (boolean)false, (int)2, null) : false;
                if (bl) {
                    return (LocationAwareException)$this$runtimeFailureLocatedIn;
                }
            }
            if ($this$runtimeFailureLocatedIn.getCause() == null) {
                return null;
            }
            String string = scriptPath;
            $this$runtimeFailureLocatedIn = next;
            scriptPath = string;
        }
    }

    private static final boolean isCausedByScriptCompilationException(LocationAwareException $this$isCausedByScriptCompilationException) {
        boolean bl;
        Throwable throwable = $this$isCausedByScriptCompilationException.getCause();
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getClass().getName(), (Object)"org.gradle.kotlin.dsl.support.ScriptCompilationException");
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String messageForLocationAwareEditorHint(LocationAwareException failure) {
        String string;
        block4: {
            Throwable cause;
            block3: {
                String string2;
                Throwable throwable = failure.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                cause = throwable;
                string = cause.getMessage();
                if (string == null) break block3;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block4;
            }
            string = EditorMessages.INSTANCE.defaultLocationAwareHintMessageFor(cause);
        }
        return string;
    }

    private static final DefaultEditorReport wholeFileWarning(String message) {
        return new DefaultEditorReport(EditorReportSeverity.WARNING, message, null, 4, null);
    }

    private static final DefaultEditorReport lineWarning(String message, int line) {
        return new DefaultEditorReport(EditorReportSeverity.WARNING, message, new DefaultEditorPosition(line, 0, 2, null));
    }

    @NotNull
    public static final LongRange readLinesRange(@NotNull File $this$readLinesRange) {
        Intrinsics.checkNotNullParameter((Object)$this$readLinesRange, (String)"<this>");
        long count = EditorReportsBuilderKt.countLines($this$readLinesRange);
        boolean bl = false;
        return count == 0L ? new LongRange(0L, 0L) : new LongRange(1L, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long countLines(File $this$countLines) {
        long l;
        Closeable closeable = new FileInputStream($this$countLines);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream input = (BufferedInputStream)closeable;
            boolean bl = false;
            l = EditorReportsBuilderKt.countLines(input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    private static final long countLines(BufferedInputStream $this$countLines) {
        byte[] buffer = new byte[8192];
        byte newLine = 10;
        long count = 0L;
        boolean noNewLineBeforeEOF = false;
        int readCount = $this$countLines.read(buffer);
        while (readCount != -1) {
            int n = readCount;
            for (int idx = 0; idx < n; ++idx) {
                if (buffer[idx] != newLine) continue;
                long l = count;
                count = l + 1L;
            }
            noNewLineBeforeEOF = buffer[readCount - 1] != newLine;
            readCount = $this$countLines.read(buffer);
        }
        if (noNewLineBeforeEOF) {
            long l = count;
            count = l + 1L;
        }
        return count;
    }

    private static final LocationAwareException runtimeFailuresLocatedInAndNotCausedScriptCompilation$lambda$2(String $scriptPath, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EditorReportsBuilderKt.runtimeFailureLocatedIn(it, $scriptPath);
    }

    private static final boolean runtimeFailuresLocatedInAndNotCausedScriptCompilation$lambda$3(LocationAwareException it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !EditorReportsBuilderKt.isCausedByScriptCompilationException(it);
    }

    private static final LocationAwareException runtimeFailuresLocatedIn$lambda$4(String $scriptPath, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EditorReportsBuilderKt.runtimeFailureLocatedIn(it, $scriptPath);
    }

    public static final /* synthetic */ LocationAwareException access$firstLocationAwareCauseOrNull(Throwable ex) {
        return EditorReportsBuilderKt.firstLocationAwareCauseOrNull(ex);
    }
}

