# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libgnomeui
VER=2.22.01
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=/devel/target/$HEX

MINOR=${VER%.*}
MINOR=${MINOR#*.}

(( $MINOR % 2 == 1 )) && UNSTABLE="-unstable"

DEPS=`/devel/src/tml/latest$UNSTABLE.sh glib atk cairo pango gtk+ libIDL ORBit2 libglade libart_lgpl libgnomecanvas gail libbonobo GConf libgnome libbonoboui gnome-vfs`

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

# Nah, this doesn't work either. Anyway, I don't think this intltool-extract stuff matters that much
# sed -e "s!='\$(top_builddir)/intltool-extract'!='perl \$(top_builddir)/intltool-extract'!" <configure >configure.tmp && mv configure.tmp configure &&

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/gnu/include -I/opt/gnuwin32/include -I/devel/dist/popt-1.10.2-tml-20050828/include' LDFLAGS='-L/opt/gnu/lib -L/opt/gnuwin32/lib -L/devel/dist/popt-1.10.2-tml-20050828/lib' CFLAGS=-O2 ./configure --enable-debug=yes --disable-gtk-doc --disable-static --prefix=c:$TARGET &&
libtoolcacheize &&
unset MY_PKG_CONFIG_PATH &&

PATH=$TARGET/bin:.libs:$PATH make install &&
PATH=$TARGET/bin:$PATH make check &&

./libgnomeui-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
