#include <libxml/tree.h>
#include <libsoup/soup-message.h>
#include <libsoup/soup-xmlrpc-message.h>

typedef struct {
	xmlDocPtr doc;
	xmlNodePtr last_node;
} HackedSoupXmlrpcMessagePrivate;
#define HACKED_SOUP_XMLRPC_MESSAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SOUP_TYPE_XMLRPC_MESSAGE, HackedSoupXmlrpcMessagePrivate))


gboolean
hacked_soup_xmlrpc_message_from_string (SoupXmlrpcMessage *message, const char *xmlstr)
{
	HackedSoupXmlrpcMessagePrivate *priv;
	xmlDocPtr newdoc;
	xmlNodePtr body;
	gboolean fault = TRUE;

	g_return_val_if_fail (SOUP_IS_XMLRPC_MESSAGE (message), FALSE);
	priv = HACKED_SOUP_XMLRPC_MESSAGE_GET_PRIVATE (message);
	g_return_val_if_fail (xmlstr != NULL, FALSE);

	xmlKeepBlanksDefault (0);
	newdoc = xmlParseMemory (xmlstr, strlen (xmlstr));
	if (!newdoc)
		goto very_bad;

	body = xmlDocGetRootElement (newdoc);
	if (!body || strcmp ((char *)body->name, "methodCall"))
		goto bad;

	body = body->children;
	if (!body || strcmp ((char *)body->name, "methodName"))
		goto bad;

	body = body->next;
	if (!body || strcmp ((char *)body->name, "params"))
		goto bad;

	body = xmlGetLastChild (body);
	if (!body)
		goto bad;

	/* body should be pointing by now to the last param */
	xmlFreeDoc (priv->doc);
	priv->doc = newdoc;
	priv->last_node = body;

	return TRUE;

bad:
	xmlFreeDoc (newdoc);
very_bad:
	return FALSE;
}
