/* cheese-main.c generated by valac, the Vala compiler
 * generated from cheese-main.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <unique/unique.h>
#include <cheese-config.h>
#include <clutter/clutter.h>
#include <gst/gst.h>
#include <gobject/gvaluecollector.h>


#define CHEESE_TYPE_MAIN (cheese_main_get_type ())
#define CHEESE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN, CheeseMain))
#define CHEESE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN, CheeseMainClass))
#define CHEESE_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN))
#define CHEESE_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN))
#define CHEESE_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN, CheeseMainClass))

typedef struct _CheeseMain CheeseMain;
typedef struct _CheeseMainClass CheeseMainClass;
typedef struct _CheeseMainPrivate CheeseMainPrivate;

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CheeseParamSpecMain CheeseParamSpecMain;

struct _CheeseMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheeseMainPrivate * priv;
};

struct _CheeseMainClass {
	GTypeClass parent_class;
	void (*finalize) (CheeseMain *self);
};

struct _CheeseParamSpecMain {
	GParamSpec parent_instance;
};


static gboolean cheese_main_verbose;
static gboolean cheese_main_verbose = FALSE;
static gboolean cheese_main_wide;
static gboolean cheese_main_wide = FALSE;
static gboolean cheese_main_version_only;
static gboolean cheese_main_version_only = FALSE;
static FILE* cheese_main_log_file;
static FILE* cheese_main_log_file = NULL;
static CheeseMainWindow* cheese_main_main_window;
static CheeseMainWindow* cheese_main_main_window = NULL;
static gpointer cheese_main_parent_class = NULL;

gpointer cheese_main_ref (gpointer instance);
void cheese_main_unref (gpointer instance);
GParamSpec* cheese_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void cheese_value_set_main (GValue* value, gpointer v_object);
void cheese_value_take_main (GValue* value, gpointer v_object);
gpointer cheese_value_get_main (const GValue* value);
GType cheese_main_get_type (void);
enum  {
	CHEESE_MAIN_DUMMY_PROPERTY
};
GType cheese_main_window_get_type (void);
static void cheese_main_print_handler (const char* text);
UniqueResponse cheese_main_unique_message_received (gint command, UniqueMessageData* msg, guint time);
CheeseMainWindow* cheese_main_window_new (void);
CheeseMainWindow* cheese_main_window_construct (GType object_type);
static UniqueResponse _cheese_main_unique_message_received_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self);
static void _cheese_main_print_handler_gprint_func (const char* text);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
gint cheese_main_main (char** args, int args_length1);
CheeseMain* cheese_main_new (void);
CheeseMain* cheese_main_construct (GType object_type);
static void cheese_main_finalize (CheeseMain* obj);

static const GOptionEntry CHEESE_MAIN_options[4] = {{"verbose", 'v', 0, G_OPTION_ARG_NONE, &cheese_main_verbose, N_ ("Be verbose"), NULL}, {"wide", 'w', 0, G_OPTION_ARG_NONE, &cheese_main_wide, N_ ("Enable wide mode"), NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &cheese_main_version_only, N_ ("Output version information and exit"), NULL}, {NULL}};


static void cheese_main_print_handler (const char* text) {
	g_return_if_fail (text != NULL);
	fputs (text, cheese_main_log_file);
	if (cheese_main_verbose) {
		fputs (text, stdout);
	}
}


UniqueResponse cheese_main_unique_message_received (gint command, UniqueMessageData* msg, guint time) {
	UniqueResponse result = 0;
	g_return_val_if_fail (msg != NULL, 0);
	if (command == UNIQUE_ACTIVATE) {
		gtk_window_set_screen ((GtkWindow*) cheese_main_main_window, unique_message_data_get_screen (msg));
		gtk_widget_activate ((GtkWidget*) cheese_main_main_window);
	}
	result = UNIQUE_RESPONSE_OK;
	return result;
}


static UniqueResponse _cheese_main_unique_message_received_unique_app_message_received (UniqueApp* _sender, gint command, UniqueMessageData* message_data, guint time_, gpointer self) {
	UniqueResponse result;
	result = cheese_main_unique_message_received (command, message_data, time_);
	return result;
}


static void _cheese_main_print_handler_gprint_func (const char* text) {
	cheese_main_print_handler (text);
}


static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
	gtk_main_quit ();
}


gint cheese_main_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_;
	CheeseMainWindow* _tmp0_;
	UniqueApp* app;
	gboolean _tmp1_;
	char* log_file_dir;
	FILE* _tmp3_;
	char* _tmp2_;
	char* _tmp4_;
	_inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	clutter_init (&args_length1, &args);
	{
		GOptionContext* context;
		context = g_option_context_new (_ ("- Take photos and videos from your webcam"));
		g_option_context_set_help_enabled (context, TRUE);
		g_option_context_add_main_entries (context, CHEESE_MAIN_options, NULL);
		g_option_context_add_group (context, gtk_get_option_group (TRUE));
		g_option_context_add_group (context, clutter_get_option_group ());
		g_option_context_add_group (context, gst_init_get_option_group ());
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, _ ("Run '%s --help' to see a full list of available command line options.\n"), args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	cheese_main_main_window = (_tmp0_ = g_object_ref_sink (cheese_main_window_new ()), _g_object_unref0 (cheese_main_main_window), _tmp0_);
	app = unique_app_new ("org.gnome.Cheese", NULL);
	if ((g_object_get (app, "is-running", &_tmp1_, NULL), _tmp1_)) {
		UniqueResponse response = 0;
		response = unique_app_send_message (app, (gint) UNIQUE_ACTIVATE, NULL);
		result = 0;
		_g_object_unref0 (app);
		return result;
	} else {
		unique_app_watch_window (app, (GtkWindow*) cheese_main_main_window);
		g_signal_connect (app, "message-received", (GCallback) _cheese_main_unique_message_received_unique_app_message_received, NULL);
	}
	g_set_application_name (_ ("Cheese"));
	gtk_window_set_default_icon_name ("cheese");
	log_file_dir = g_build_filename (g_get_home_dir (), ".config", "cheese", NULL);
	g_mkdir_with_parents (log_file_dir, 0775);
	cheese_main_log_file = (_tmp3_ = fopen (_tmp2_ = g_build_filename (log_file_dir, "cheese.log", NULL), "w"), _fclose0 (cheese_main_log_file), _tmp3_);
	_g_free0 (_tmp2_);
	g_set_print_handler (_cheese_main_print_handler_gprint_func);
	gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (), _tmp4_ = g_build_filename (PACKAGE_DATADIR, "icons", NULL));
	_g_free0 (_tmp4_);
	cheese_main_window_setup_ui (cheese_main_main_window);
	g_signal_connect ((GtkObject*) cheese_main_main_window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
	gtk_widget_show_all ((GtkWidget*) cheese_main_main_window);
	gtk_main ();
	result = 0;
	_g_object_unref0 (app);
	_g_free0 (log_file_dir);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return cheese_main_main (argv, argc);
}


CheeseMain* cheese_main_construct (GType object_type) {
	CheeseMain* self;
	self = (CheeseMain*) g_type_create_instance (object_type);
	return self;
}


CheeseMain* cheese_main_new (void) {
	return cheese_main_construct (CHEESE_TYPE_MAIN);
}


static void cheese_value_main_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void cheese_value_main_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		cheese_main_unref (value->data[0].v_pointer);
	}
}


static void cheese_value_main_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = cheese_main_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer cheese_value_main_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* cheese_value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		CheeseMain* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = cheese_main_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* cheese_value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheeseMain** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = cheese_main_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* cheese_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CheeseParamSpecMain* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CHEESE_TYPE_MAIN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer cheese_value_get_main (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHEESE_TYPE_MAIN), NULL);
	return value->data[0].v_pointer;
}


void cheese_value_set_main (GValue* value, gpointer v_object) {
	CheeseMain* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHEESE_TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHEESE_TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		cheese_main_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cheese_main_unref (old);
	}
}


void cheese_value_take_main (GValue* value, gpointer v_object) {
	CheeseMain* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHEESE_TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHEESE_TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cheese_main_unref (old);
	}
}


static void cheese_main_class_init (CheeseMainClass * klass) {
	cheese_main_parent_class = g_type_class_peek_parent (klass);
	CHEESE_MAIN_CLASS (klass)->finalize = cheese_main_finalize;
}


static void cheese_main_instance_init (CheeseMain * self) {
	self->ref_count = 1;
}


static void cheese_main_finalize (CheeseMain* obj) {
	CheeseMain * self;
	self = CHEESE_MAIN (obj);
}


GType cheese_main_get_type (void) {
	static volatile gsize cheese_main_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { cheese_value_main_init, cheese_value_main_free_value, cheese_value_main_copy_value, cheese_value_main_peek_pointer, "p", cheese_value_main_collect_value, "p", cheese_value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMain), 0, (GInstanceInitFunc) cheese_main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType cheese_main_type_id;
		cheese_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheeseMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&cheese_main_type_id__volatile, cheese_main_type_id);
	}
	return cheese_main_type_id__volatile;
}


gpointer cheese_main_ref (gpointer instance) {
	CheeseMain* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void cheese_main_unref (gpointer instance) {
	CheeseMain* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHEESE_MAIN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




