/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* e-book-backend-couchdb-factory.c - CouchDB contact backend factory.
 *
 * Copyright (C) 2009 Canonical, Ltd. (www.canonical.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 */

#ifndef __E_BOOK_BACKEND_COUCHDB_H__
#define __E_BOOK_BACKEND_COUCHDB_H__

#include <couchdb-glib.h>
#include <couchdb-document-contact.h>
#include <libedata-book/e-book-backend.h>

#define E_TYPE_BOOK_BACKEND_COUCHDB        (e_book_backend_couchdb_get_type ())
#define E_BOOK_BACKEND_COUCHDB(o)          (G_TYPE_CHECK_INSTANCE_CAST ((o), E_TYPE_BOOK_BACKEND_COUCHDB, EBookBackendCouchDB))
#define E_BOOK_BACKEND_COUCHDB_CLASS(k)    (G_TYPE_CHECK_CLASS_CAST((k), E_TYPE_BOOK_BACKEND_COUCHDB, EBookBackendCouchDBClass))
#define E_IS_BOOK_BACKEND_COUCHDB(o)       (G_TYPE_CHECK_INSTANCE_TYPE ((o), E_TYPE_BOOK_BACKEND_COUCHDB))
#define E_IS_BOOK_BACKEND_COUCHDB_CLASS(k) (G_TYPE_CHECK_CLASS_TYPE ((k), E_TYPE_BOOK_BACKEND_COUCHDB))
#define E_BOOK_BACKEND_COUCHDB_GET_CLASS(k) (G_TYPE_INSTANCE_GET_CLASS ((obj), E_TYPE_BOOK_BACKEND_COUCHDB, EBookBackenCouchDBClass))

typedef struct {
	EBookBackend parent_object;

	CouchDB *couchdb;
	char *dbname;
} EBookBackendCouchDB;

typedef struct {
	EBookBackendClass parent_class;
} EBookBackendCouchDBClass;

GType         e_book_backend_couchdb_get_type (void);
EBookBackend *e_book_backend_couchdb_new (void);

#endif
