#
# Hash table for two-dimensional integer coordinates as keys.
#
class Hash2D:

    # size of the areas; low values are more efficient for retrieving values
    # but less efficient for setting or deleting values
    __AREA_SIZE = 10


    def __init__(self):

        self.__areas = {}
        self.__is_in = {}



    def __hash(self, x, y):

        return (x - x % self.__AREA_SIZE, y - y % self.__AREA_SIZE)
    


    def set(self, x1, y1, x2, y2, value):

        self.delete(value)

        x1, x2 = min(x1, x2), max(x1, x2)
        y1, y2 = min(y1, y2), max(y1, y2)

        for x in xrange(x1, x2 + 1, self.__AREA_SIZE):
            for y in xrange(y1, y2 + 1, self.__AREA_SIZE):
                key = self.__hash(x, y)
                if (not self.__areas.has_key(key)):
                    self.__areas[key] = []
                self.__areas[key].append((value, x1, y1, x2, y2))

                if (not self.__is_in.has_key(value)): self.__is_in[value] = []
                self.__is_in[value].append((key, x1, y1, x2, y2))
            #end for
        #end for




    def get(self, x, y):

        key = self.__hash(x, y)
        ret = []

        entries = self.__areas.get(key, [])
        for value, x1, y1, x2, y2 in entries:
            if (x1 <= x <= x2 and y1 <= y <= y2): ret.append(value)

        return ret




    def delete(self, value):

        keys = self.__is_in.get(value, [])
        self.__is_in[value] = []
        for k, x1, y1, x2, y2 in keys:
            self.__areas[k].remove((value, x1, y1, x2, y2))
