/* gcp-diagnostic-tags.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-diagnostic-tags.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;
typedef struct _GcpDiagnosticTagsPrivate GcpDiagnosticTagsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_DIAGNOSTIC_COLORS (gcp_diagnostic_colors_get_type ())
#define GCP_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColors))
#define GCP_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))
#define GCP_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))

typedef struct _GcpDiagnosticColors GcpDiagnosticColors;
typedef struct _GcpDiagnosticColorsClass GcpDiagnosticColorsClass;
#define _gcp_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_colors_unref (var), NULL)))

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
typedef struct _GcpParamSpecDiagnosticTags GcpParamSpecDiagnosticTags;

struct _GcpDiagnosticTags {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpDiagnosticTagsPrivate * priv;
};

struct _GcpDiagnosticTagsClass {
	GTypeClass parent_class;
	void (*finalize) (GcpDiagnosticTags *self);
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpParamSpecDiagnosticTags {
	GParamSpec parent_instance;
};


extern GtkTextView* gcp_d_view;
GtkTextView* gcp_d_view = NULL;
extern GtkTextBuffer* gcp_d_buffer;
GtkTextBuffer* gcp_d_buffer = NULL;
extern GtkTextTag* gcp_d_infoTag;
GtkTextTag* gcp_d_infoTag = NULL;
extern GtkTextTag* gcp_d_warningTag;
GtkTextTag* gcp_d_warningTag = NULL;
extern GtkTextTag* gcp_d_errorTag;
GtkTextTag* gcp_d_errorTag = NULL;
extern GtkTextTag* gcp_d_locationTag;
GtkTextTag* gcp_d_locationTag = NULL;
extern GtkTextTag* gcp_d_fixitTag;
GtkTextTag* gcp_d_fixitTag = NULL;
static gpointer gcp_diagnostic_tags_parent_class = NULL;
static GType gcp_diagnostic_tags_type_id = 0;

gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
enum  {
	GCP_DIAGNOSTIC_TAGS_DUMMY_PROPERTY
};
static void gcp_diagnostic_tags_remove_tags (GcpDiagnosticTags* self);
static void gcp_diagnostic_tags_on_style_updated (GcpDiagnosticTags* self);
static void _gcp_diagnostic_tags_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self);
GcpDiagnosticTags* gcp_diagnostic_tags_new (GtkTextView* view);
GcpDiagnosticTags* gcp_diagnostic_tags_construct (GType object_type, GtkTextView* view);
static void gcp_diagnostic_tags_on_buffer_changed (GcpDiagnosticTags* self);
static void _gcp_diagnostic_tags_on_buffer_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_diagnostic_tags_update_tags (GcpDiagnosticTags* self);
static GtkTextTag* gcp_diagnostic_tags_ensure_tag (GcpDiagnosticTags* self, GtkTextTag** tag, const gchar* name);
static void gcp_diagnostic_tags_update_tag (GcpDiagnosticTags* self, GtkTextTag** tag, const gchar* name, GdkRGBA* col);
gpointer gcp_diagnostic_colors_ref (gpointer instance);
void gcp_diagnostic_colors_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_colors (const GValue* value);
GType gcp_diagnostic_colors_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_colors_register_type (GTypeModule * module);
GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context);
GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget);
void gcp_diagnostic_colors_get_info_color (GcpDiagnosticColors* self, GdkRGBA* result);
void gcp_diagnostic_colors_get_warning_color (GcpDiagnosticColors* self, GdkRGBA* result);
void gcp_diagnostic_colors_get_error_color (GcpDiagnosticColors* self, GdkRGBA* result);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
GtkTextTag* gcp_diagnostic_tags_get (GcpDiagnosticTags* self, GcpDiagnosticSeverity severity);
static void gcp_diagnostic_tags_remove_tag (GcpDiagnosticTags* self, GtkTextTag** tag);
GtkTextTag* gcp_diagnostic_tags_get_error_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_warning_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_info_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_location_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_fixit_tag (GcpDiagnosticTags* self);
static void gcp_diagnostic_tags_finalize (GcpDiagnosticTags* obj);


static void _gcp_diagnostic_tags_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self) {
	gcp_diagnostic_tags_on_style_updated (self);
}


static void _gcp_diagnostic_tags_on_buffer_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_diagnostic_tags_on_buffer_changed (self);
}


GcpDiagnosticTags* gcp_diagnostic_tags_construct (GType object_type, GtkTextView* view) {
	GcpDiagnosticTags* self = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (GcpDiagnosticTags*) g_type_create_instance (object_type);
	gcp_d_view = view;
	g_signal_connect ((GtkWidget*) gcp_d_view, "style-updated", (GCallback) _gcp_diagnostic_tags_on_style_updated_gtk_widget_style_updated, self);
	g_signal_connect ((GObject*) gcp_d_view, "notify::buffer", (GCallback) _gcp_diagnostic_tags_on_buffer_changed_g_object_notify, self);
	_tmp0_ = gtk_text_view_get_buffer (view);
	gcp_d_buffer = _tmp0_;
	gcp_diagnostic_tags_update_tags (self);
	return self;
}


GcpDiagnosticTags* gcp_diagnostic_tags_new (GtkTextView* view) {
	return gcp_diagnostic_tags_construct (GCP_TYPE_DIAGNOSTIC_TAGS, view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkTextTag* gcp_diagnostic_tags_ensure_tag (GcpDiagnosticTags* self, GtkTextTag** tag, const gchar* name) {
	GtkTextTag* result = NULL;
	GtkTextTag* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if ((*tag) == NULL) {
		GtkTextTag* _tmp0_ = NULL;
		GtkTextTag* _tmp1_;
		_tmp0_ = gtk_text_buffer_create_tag (gcp_d_buffer, name, NULL);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (*tag);
		*tag = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (*tag);
	result = _tmp2_;
	return result;
}


static void gcp_diagnostic_tags_update_tag (GcpDiagnosticTags* self, GtkTextTag** tag, const gchar* name, GdkRGBA* col) {
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	GdkColor bgcol;
	GtkTextTag* _tmp2_ = NULL;
	GtkTextTag* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	memset (&_tmp0_, 0, sizeof (GdkColor));
	_tmp0_.red = (guint16) ((gushort) ((*col).red * 65535));
	_tmp0_.green = (guint16) ((gushort) ((*col).green * 65535));
	_tmp0_.blue = (guint16) ((gushort) ((*col).blue * 65535));
	_tmp1_ = _tmp0_;
	bgcol = _tmp1_;
	_tmp2_ = gcp_diagnostic_tags_ensure_tag (self, tag, name);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	g_object_set (*tag, "background-gdk", &bgcol, NULL);
	g_object_set (*tag, "background-full-height", TRUE, NULL);
}


static void gcp_diagnostic_tags_update_tags (GcpDiagnosticTags* self) {
	GcpDiagnosticColors* colors = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GcpDiagnosticColors* _tmp1_ = NULL;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) gcp_d_view);
	_tmp1_ = gcp_diagnostic_colors_new (_tmp0_);
	_gcp_diagnostic_colors_unref0 (colors);
	colors = _tmp1_;
	gcp_diagnostic_colors_mix_in_widget (colors, (GtkWidget*) gcp_d_view);
	gcp_diagnostic_colors_get_info_color (colors, &_tmp2_);
	gcp_diagnostic_tags_update_tag (self, &gcp_d_infoTag, "Gcp.Info", &_tmp2_);
	gcp_diagnostic_colors_get_warning_color (colors, &_tmp3_);
	gcp_diagnostic_tags_update_tag (self, &gcp_d_warningTag, "Gcp.Warning", &_tmp3_);
	gcp_diagnostic_colors_get_error_color (colors, &_tmp4_);
	gcp_diagnostic_tags_update_tag (self, &gcp_d_errorTag, "Gcp.Error", &_tmp4_);
	if (gcp_d_locationTag == NULL) {
		GtkTextTag* _tmp5_ = NULL;
		GtkTextTag* _tmp6_;
		_tmp5_ = gtk_text_buffer_create_tag (gcp_d_buffer, "Gcp.Location", "weight", PANGO_WEIGHT_BOLD, NULL);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (gcp_d_locationTag);
		gcp_d_locationTag = _tmp6_;
	}
	if (gcp_d_fixitTag == NULL) {
		GtkTextTag* _tmp7_ = NULL;
		GtkTextTag* _tmp8_;
		_tmp7_ = gtk_text_buffer_create_tag (gcp_d_buffer, "Gcp.Fixit", "strikethrough", TRUE, NULL);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (gcp_d_fixitTag);
		gcp_d_fixitTag = _tmp8_;
	}
	_gcp_diagnostic_colors_unref0 (colors);
}


GtkTextTag* gcp_diagnostic_tags_get (GcpDiagnosticTags* self, GcpDiagnosticSeverity severity) {
	GtkTextTag* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (severity) {
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			GtkTextTag* _tmp0_;
			_tmp0_ = _g_object_ref0 (gcp_d_infoTag);
			result = _tmp0_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			GtkTextTag* _tmp1_;
			_tmp1_ = _g_object_ref0 (gcp_d_warningTag);
			result = _tmp1_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		case GCP_DIAGNOSTIC_SEVERITY_FATAL:
		{
			GtkTextTag* _tmp2_;
			_tmp2_ = _g_object_ref0 (gcp_d_errorTag);
			result = _tmp2_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static void gcp_diagnostic_tags_remove_tag (GcpDiagnosticTags* self, GtkTextTag** tag) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (gcp_d_buffer != NULL) {
		_tmp0_ = (*tag) != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextTagTable* _tmp1_ = NULL;
		_tmp1_ = gtk_text_buffer_get_tag_table (gcp_d_buffer);
		gtk_text_tag_table_remove (_tmp1_, *tag);
		_g_object_unref0 (*tag);
		*tag = NULL;
	}
}


static void gcp_diagnostic_tags_remove_tags (GcpDiagnosticTags* self) {
	g_return_if_fail (self != NULL);
	gcp_diagnostic_tags_remove_tag (self, &gcp_d_errorTag);
	gcp_diagnostic_tags_remove_tag (self, &gcp_d_warningTag);
	gcp_diagnostic_tags_remove_tag (self, &gcp_d_infoTag);
	gcp_diagnostic_tags_remove_tag (self, &gcp_d_locationTag);
	gcp_diagnostic_tags_remove_tag (self, &gcp_d_fixitTag);
}


static void gcp_diagnostic_tags_on_buffer_changed (GcpDiagnosticTags* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gcp_diagnostic_tags_remove_tags (self);
	_tmp0_ = gtk_text_view_get_buffer (gcp_d_view);
	gcp_d_buffer = _tmp0_;
	_g_object_unref0 (gcp_d_errorTag);
	gcp_d_errorTag = NULL;
	_g_object_unref0 (gcp_d_warningTag);
	gcp_d_warningTag = NULL;
	_g_object_unref0 (gcp_d_infoTag);
	gcp_d_infoTag = NULL;
	gcp_diagnostic_tags_update_tags (self);
}


static void gcp_diagnostic_tags_on_style_updated (GcpDiagnosticTags* self) {
	g_return_if_fail (self != NULL);
	gcp_diagnostic_tags_update_tags (self);
}


GtkTextTag* gcp_diagnostic_tags_get_error_tag (GcpDiagnosticTags* self) {
	GtkTextTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gcp_d_errorTag;
	return result;
}


GtkTextTag* gcp_diagnostic_tags_get_warning_tag (GcpDiagnosticTags* self) {
	GtkTextTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gcp_d_warningTag;
	return result;
}


GtkTextTag* gcp_diagnostic_tags_get_info_tag (GcpDiagnosticTags* self) {
	GtkTextTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gcp_d_infoTag;
	return result;
}


GtkTextTag* gcp_diagnostic_tags_get_location_tag (GcpDiagnosticTags* self) {
	GtkTextTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gcp_d_locationTag;
	return result;
}


GtkTextTag* gcp_diagnostic_tags_get_fixit_tag (GcpDiagnosticTags* self) {
	GtkTextTag* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gcp_d_fixitTag;
	return result;
}


static void gcp_value_diagnostic_tags_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_value_diagnostic_tags_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_diagnostic_tags_unref (value->data[0].v_pointer);
	}
}


static void gcp_value_diagnostic_tags_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_diagnostic_tags_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_value_diagnostic_tags_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_value_diagnostic_tags_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpDiagnosticTags* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_diagnostic_tags_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_value_diagnostic_tags_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpDiagnosticTags** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_diagnostic_tags_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpParamSpecDiagnosticTags* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_TYPE_DIAGNOSTIC_TAGS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_value_get_diagnostic_tags (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_TAGS), NULL);
	return value->data[0].v_pointer;
}


void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object) {
	GcpDiagnosticTags* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_TAGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_DIAGNOSTIC_TAGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_diagnostic_tags_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_diagnostic_tags_unref (old);
	}
}


void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object) {
	GcpDiagnosticTags* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_TAGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_DIAGNOSTIC_TAGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_diagnostic_tags_unref (old);
	}
}


static void gcp_diagnostic_tags_class_init (GcpDiagnosticTagsClass * klass) {
	gcp_diagnostic_tags_parent_class = g_type_class_peek_parent (klass);
	GCP_DIAGNOSTIC_TAGS_CLASS (klass)->finalize = gcp_diagnostic_tags_finalize;
}


static void gcp_diagnostic_tags_instance_init (GcpDiagnosticTags * self) {
	self->ref_count = 1;
}


static void gcp_diagnostic_tags_finalize (GcpDiagnosticTags* obj) {
	GcpDiagnosticTags * self;
	guint _tmp0_;
	self = GCP_DIAGNOSTIC_TAGS (obj);
	gcp_diagnostic_tags_remove_tags (self);
	g_signal_parse_name ("style-updated", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) gcp_d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_diagnostic_tags_on_style_updated_gtk_widget_style_updated, self);
}


GType gcp_diagnostic_tags_get_type (void) {
	return gcp_diagnostic_tags_type_id;
}


GType gcp_diagnostic_tags_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_value_diagnostic_tags_init, gcp_value_diagnostic_tags_free_value, gcp_value_diagnostic_tags_copy_value, gcp_value_diagnostic_tags_peek_pointer, "p", gcp_value_diagnostic_tags_collect_value, "p", gcp_value_diagnostic_tags_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpDiagnosticTagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_diagnostic_tags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDiagnosticTags), 0, (GInstanceInitFunc) gcp_diagnostic_tags_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_diagnostic_tags_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpDiagnosticTags", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_diagnostic_tags_type_id;
}


gpointer gcp_diagnostic_tags_ref (gpointer instance) {
	GcpDiagnosticTags* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_diagnostic_tags_unref (gpointer instance) {
	GcpDiagnosticTags* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_DIAGNOSTIC_TAGS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



