/* gcp-document.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-document.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>


#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;
typedef struct _GcpDocumentPrivate GcpDocumentPrivate;

#define GCP_TYPE_DIAGNOSTIC_SUPPORT (gcp_diagnostic_support_get_type ())
#define GCP_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupport))
#define GCP_IS_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT))
#define GCP_DIAGNOSTIC_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupportIface))

typedef struct _GcpDiagnosticSupport GcpDiagnosticSupport;
typedef struct _GcpDiagnosticSupportIface GcpDiagnosticSupportIface;

#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;

#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_DIAGNOSTIC_TYPE_FIXIT (gcp_diagnostic_fixit_get_type ())
typedef struct _GcpDiagnosticFixit GcpDiagnosticFixit;

#define GCP_SOURCE_INDEX_TYPE_ITERATOR (gcp_source_index_iterator_get_type ())
#define GCP_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIterator))
#define GCP_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))
#define GCP_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))

typedef struct _GcpSourceIndexIterator GcpSourceIndexIterator;
typedef struct _GcpSourceIndexIteratorClass GcpSourceIndexIteratorClass;

struct _GcpDocument {
	GObject parent_instance;
	GcpDocumentPrivate * priv;
};

struct _GcpDocumentClass {
	GObjectClass parent_class;
	gboolean (*get_tainted) (GcpDocument* self);
	void (*set_tainted) (GcpDocument* self, gboolean value);
};

struct _GcpDocumentPrivate {
	GeditDocument* d_document;
	gboolean d_untitled;
	gboolean d_modified;
	gchar* d_text;
	GFile* d_location;
	gboolean d_tainted;
};

struct _GcpDiagnosticSupportIface {
	GTypeInterface parent_iface;
	GcpDiagnosticTags* (*get_tags) (GcpDiagnosticSupport* self);
	void (*set_tags) (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
	GcpSourceIndex* (*get_diagnostics) (GcpDiagnosticSupport* self);
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

struct _GcpDiagnosticFixit {
	GcpSourceRange* range;
	gchar* replacement;
};


static gpointer gcp_document_parent_class = NULL;
static GType gcp_document_type_id = 0;

GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
#define GCP_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_DOCUMENT, GcpDocumentPrivate))
enum  {
	GCP_DOCUMENT_DUMMY_PROPERTY,
	GCP_DOCUMENT_TAINTED,
	GCP_DOCUMENT_LOCATION,
	GCP_DOCUMENT_TEXT,
	GCP_DOCUMENT_IS_MODIFIED,
	GCP_DOCUMENT_DOCUMENT
};
static void gcp_document_on_document_modified_changed (GcpDocument* self);
static void _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_document_on_location_changed (GcpDocument* self);
static void _gcp_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_document_on_document_changed (GcpDocument* self);
static void _gcp_document_on_document_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_document_on_document_saved (GcpDocument* self);
static void _gcp_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, void* _error_, gpointer self);
gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_diagnostic_support_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_support_register_type (GTypeModule * module);
static void gcp_document_on_diagnostic_updated (GcpDocument* self, GcpDiagnosticSupport* diagnostic);
static void _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self);
static void gcp_document_remove_marks (GcpDocument* self);
GcpDocument* gcp_document_new (GeditDocument* document);
GcpDocument* gcp_document_construct (GType object_type, GeditDocument* document);
static void gcp_document_update_modified (GcpDocument* self);
static void gcp_document_update_location (GcpDocument* self);
const gchar* gcp_document_get_info_mark_category (void);
const gchar* gcp_document_get_warning_mark_category (void);
const gchar* gcp_document_get_error_mark_category (void);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
static gboolean gcp_document_source_location (GcpDocument* self, GcpSourceLocation* location, GtkTextIter* iter);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
gchar* gcp_document_mark_category_for_severity (GcpDiagnosticSeverity severity);
static void gcp_document_mark_diagnostic_range (GcpDocument* self, GcpDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end);
GcpDiagnosticTags* gcp_diagnostic_support_get_tags (GcpDiagnosticSupport* self);
GtkTextTag* gcp_diagnostic_tags_get (GcpDiagnosticTags* self, GcpDiagnosticSeverity severity);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
static void gcp_document_mark_diagnostic (GcpDocument* self, GcpDiagnostic* diagnostic);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
GtkTextTag* gcp_diagnostic_tags_get_location_tag (GcpDiagnosticTags* self);
GType gcp_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcpDiagnosticFixit* gcp_diagnostic_fixit_dup (const GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_free (GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_copy (const GcpDiagnosticFixit* self, GcpDiagnosticFixit* dest);
void gcp_diagnostic_fixit_destroy (GcpDiagnosticFixit* self);
GcpDiagnosticFixit* gcp_diagnostic_get_fixits (GcpDiagnostic* self, int* result_length1);
GtkTextTag* gcp_diagnostic_tags_get_fixit_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_error_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_warning_tag (GcpDiagnosticTags* self);
GtkTextTag* gcp_diagnostic_tags_get_info_tag (GcpDiagnosticTags* self);
GcpSourceIndex* gcp_diagnostic_support_get_diagnostics (GcpDiagnosticSupport* self);
GType gcp_source_index_iterator_get_type (void) G_GNUC_CONST;
GType gcp_source_index_iterator_register_type (GTypeModule * module);
GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self);
gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self);
gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self);
static void gcp_document_set_location (GcpDocument* self, GFile* location);
GeditDocument* gcp_document_get_document (GcpDocument* self);
static void gcp_document_update_text (GcpDocument* self);
void gcp_document_emit_changed (GcpDocument* self);
gboolean gcp_document_get_tainted (GcpDocument* self);
void gcp_document_set_tainted (GcpDocument* self, gboolean value);
GFile* gcp_document_get_location (GcpDocument* self);
const gchar* gcp_document_get_text (GcpDocument* self);
gboolean gcp_document_get_is_modified (GcpDocument* self);
static void gcp_document_finalize (GObject* obj);
static void _vala_gcp_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_document_on_document_modified_changed (self);
}


static void _gcp_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_document_on_location_changed (self);
}


static void _gcp_document_on_document_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_document_on_document_changed (self);
}


static void _gcp_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, void* _error_, gpointer self) {
	gcp_document_on_document_saved (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self) {
	gcp_document_on_diagnostic_updated (self, _sender);
}


GcpDocument* gcp_document_construct (GType object_type, GeditDocument* document) {
	GcpDocument * self = NULL;
	GeditDocument* _tmp0_;
	gboolean _tmp1_;
	GcpDocument* _tmp2_;
	GcpDiagnosticSupport* _tmp3_;
	GcpDiagnosticSupport* diag;
	g_return_val_if_fail (document != NULL, NULL);
	self = (GcpDocument*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (document);
	_g_object_unref0 (self->priv->d_document);
	self->priv->d_document = _tmp0_;
	_tmp1_ = gedit_document_is_untitled (self->priv->d_document);
	self->priv->d_untitled = _tmp1_;
	self->priv->d_modified = FALSE;
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	gcp_document_update_modified (self);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->d_document, "modified-changed", (GCallback) _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->d_document, "changed", (GCallback) _gcp_document_on_document_changed_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object ((GObject*) self->priv->d_document, "notify::location", (GCallback) _gcp_document_on_location_changed_g_object_notify, self, 0);
	g_signal_connect_object (self->priv->d_document, "saved", (GCallback) _gcp_document_on_document_saved_gedit_document_saved, self, 0);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = NULL;
	gcp_document_update_location (self);
	_tmp2_ = self;
	_tmp3_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp2_) ? ((GcpDiagnosticSupport*) _tmp2_) : NULL);
	diag = _tmp3_;
	if (diag != NULL) {
		g_signal_connect_object (diag, "diagnostics-updated", (GCallback) _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self, 0);
	}
	_g_object_unref0 (diag);
	return self;
}


GcpDocument* gcp_document_new (GeditDocument* document) {
	return gcp_document_construct (GCP_TYPE_DOCUMENT, document);
}


static void gcp_document_remove_marks (GcpDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_document, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gcp_document_get_info_mark_category ();
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) self->priv->d_document, &start, &end, _tmp2_);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_document, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = gcp_document_get_warning_mark_category ();
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) self->priv->d_document, &start, &end, _tmp5_);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_document, &_tmp6_, &_tmp7_);
	start = _tmp6_;
	end = _tmp7_;
	_tmp8_ = gcp_document_get_error_mark_category ();
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) self->priv->d_document, &start, &end, _tmp8_);
}


static gboolean gcp_document_source_location (GcpDocument* self, GcpSourceLocation* location, GtkTextIter* iter) {
	GtkTextIter _iter = {0};
	gboolean result = FALSE;
	gint _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = gcp_source_location_get_line (location);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self->priv->d_document, &_tmp1_, _tmp0_ - 1);
	_iter = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&_iter);
	_tmp3_ = gcp_source_location_get_line (location);
	if (_tmp2_ != (_tmp3_ - 1)) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp4_ = gcp_source_location_get_column (location);
	if (_tmp4_ > 1) {
		GtkTextIter enditer = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		gboolean _tmp8_;
		gint _tmp10_;
		gint _tmp11_;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self->priv->d_document, &_tmp5_);
		enditer = _tmp5_;
		_tmp7_ = gcp_source_location_get_column (location);
		_tmp8_ = gtk_text_iter_forward_chars (&_iter, _tmp7_ - 1);
		if (!_tmp8_) {
			gboolean _tmp9_;
			_tmp9_ = gtk_text_iter_equal (&_iter, &enditer);
			_tmp6_ = !_tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = FALSE;
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		_tmp10_ = gtk_text_iter_get_line (&_iter);
		_tmp11_ = gcp_source_location_get_line (location);
		result = _tmp10_ == (_tmp11_ - 1);
		if (iter) {
			*iter = _iter;
		}
		return result;
	} else {
		result = TRUE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	if (iter) {
		*iter = _iter;
	}
}


gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter _start = {0};
	GtkTextIter _end = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GcpSourceLocation* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (range != NULL, FALSE);
	_tmp1_ = gcp_source_range_get_start (range);
	_tmp3_ = gcp_document_source_location (self, _tmp1_, &_tmp2_);
	_start = _tmp2_;
	if (_tmp3_) {
		GcpSourceLocation* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_;
		_tmp4_ = gcp_source_range_get_end (range);
		_tmp6_ = gcp_document_source_location (self, _tmp4_, &_tmp5_);
		_end = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	if (start) {
		*start = _start;
	}
	if (end) {
		*end = _end;
	}
	return result;
}


gchar* gcp_document_mark_category_for_severity (GcpDiagnosticSeverity severity) {
	gchar* result = NULL;
	switch (severity) {
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = gcp_document_get_warning_mark_category ();
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		case GCP_DIAGNOSTIC_SEVERITY_FATAL:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = gcp_document_get_error_mark_category ();
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = gcp_document_get_info_mark_category ();
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static void gcp_document_mark_diagnostic_range (GcpDocument* self, GcpDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end) {
	GcpDocument* _tmp0_;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticSupport* sup;
	GcpDiagnosticTags* _tmp2_ = NULL;
	GcpDiagnosticSeverity _tmp3_;
	GtkTextTag* _tmp4_ = NULL;
	GtkTextTag* tag;
	GcpDiagnosticSeverity _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* category;
	GtkTextIter m;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	_tmp0_ = self;
	_tmp1_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp0_) ? ((GcpDiagnosticSupport*) _tmp0_) : NULL);
	sup = _tmp1_;
	_tmp2_ = gcp_diagnostic_support_get_tags (sup);
	_tmp3_ = gcp_diagnostic_get_severity (diagnostic);
	_tmp4_ = gcp_diagnostic_tags_get (_tmp2_, _tmp3_);
	tag = _tmp4_;
	_tmp5_ = gcp_diagnostic_get_severity (diagnostic);
	_tmp6_ = gcp_document_mark_category_for_severity (_tmp5_);
	category = _tmp6_;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self->priv->d_document, tag, start, end);
	m = *start;
	_tmp7_ = gtk_text_iter_starts_line (&m);
	if (!_tmp7_) {
		gtk_text_iter_set_line_offset (&m, 0);
	}
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		gboolean alreadyhas;
		GSList* _tmp10_ = NULL;
		gboolean _tmp16_;
		if (category != NULL) {
			gint _tmp9_;
			_tmp9_ = gtk_text_iter_compare (&m, end);
			_tmp8_ = _tmp9_ <= 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		alreadyhas = FALSE;
		_tmp10_ = gtk_source_buffer_get_source_marks_at_iter ((GtkSourceBuffer*) self->priv->d_document, &m, category);
		{
			GSList* mark_collection;
			GSList* mark_it;
			mark_collection = _tmp10_;
			for (mark_it = mark_collection; mark_it != NULL; mark_it = mark_it->next) {
				GtkSourceMark* _tmp11_;
				GtkSourceMark* mark;
				_tmp11_ = _g_object_ref0 ((GtkSourceMark*) mark_it->data);
				mark = _tmp11_;
				{
					gconstpointer _tmp12_ = NULL;
					_tmp12_ = g_object_get_data ((GObject*) mark, "Gcp.Document.MarkDiagnostic");
					if (((GcpDiagnostic*) _tmp12_) == diagnostic) {
						alreadyhas = TRUE;
						_g_object_unref0 (mark);
						break;
					}
					_g_object_unref0 (mark);
				}
			}
			_g_slist_free0 (mark_collection);
		}
		if (!alreadyhas) {
			GtkSourceMark* _tmp13_ = NULL;
			GtkSourceMark* _tmp14_;
			GtkSourceMark* mark;
			GcpDiagnostic* _tmp15_;
			_tmp13_ = gtk_source_buffer_create_source_mark ((GtkSourceBuffer*) self->priv->d_document, NULL, category, &m);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			mark = _tmp14_;
			_tmp15_ = _g_object_ref0 (diagnostic);
			g_object_set_data_full ((GObject*) mark, "Gcp.Document.MarkDiagnostic", _tmp15_, g_object_unref);
			_g_object_unref0 (mark);
		}
		_tmp16_ = gtk_text_iter_forward_line (&m);
		if (!_tmp16_) {
			break;
		}
	}
	_g_free0 (category);
	_g_object_unref0 (tag);
	_g_object_unref0 (sup);
}


static void gcp_document_mark_diagnostic (GcpDocument* self, GcpDiagnostic* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpDocument* _tmp0_;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticSupport* sup;
	GcpDiagnosticTags* _tmp2_ = NULL;
	GcpDiagnosticSeverity _tmp3_;
	GtkTextTag* _tmp4_ = NULL;
	GtkTextTag* tag;
	GcpDiagnosticSeverity _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* category;
	GcpSourceLocation* _tmp19_ = NULL;
	GtkTextIter _tmp20_ = {0};
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	_tmp0_ = self;
	_tmp1_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp0_) ? ((GcpDiagnosticSupport*) _tmp0_) : NULL);
	sup = _tmp1_;
	_tmp2_ = gcp_diagnostic_support_get_tags (sup);
	_tmp3_ = gcp_diagnostic_get_severity (diagnostic);
	_tmp4_ = gcp_diagnostic_tags_get (_tmp2_, _tmp3_);
	tag = _tmp4_;
	_tmp5_ = gcp_diagnostic_get_severity (diagnostic);
	_tmp6_ = gcp_document_mark_category_for_severity (_tmp5_);
	category = _tmp6_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				GcpSourceRange** _tmp8_ = NULL;
				gint _tmp9_;
				GcpSourceRange** _tmp10_;
				gint _tmp10__length1;
				gboolean _tmp11_;
				GcpSourceRange** _tmp12_ = NULL;
				gint _tmp13_;
				GcpSourceRange** _tmp14_;
				gint _tmp14__length1;
				GtkTextIter _tmp15_ = {0};
				GtkTextIter _tmp16_ = {0};
				gboolean _tmp17_;
				gboolean _tmp18_;
				if (!_tmp7_) {
					i = i + 1;
				}
				_tmp7_ = FALSE;
				_tmp8_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) diagnostic, &_tmp9_);
				_tmp10_ = _tmp8_;
				_tmp10__length1 = _tmp9_;
				_tmp11_ = !(i < _tmp9_);
				_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_object_unref), NULL);
				if (_tmp11_) {
					break;
				}
				_tmp12_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) diagnostic, &_tmp13_);
				_tmp14_ = _tmp12_;
				_tmp14__length1 = _tmp13_;
				_tmp17_ = gcp_document_source_range (self, _tmp14_[i], &_tmp15_, &_tmp16_);
				start = _tmp15_;
				end = _tmp16_;
				_tmp18_ = !_tmp17_;
				_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_object_unref), NULL);
				if (_tmp18_) {
					continue;
				}
				gcp_document_mark_diagnostic_range (self, diagnostic, &start, &end);
			}
		}
	}
	_tmp19_ = gcp_diagnostic_get_location (diagnostic);
	_tmp21_ = gcp_document_source_location (self, _tmp19_, &_tmp20_);
	start = _tmp20_;
	if (_tmp21_) {
		gboolean _tmp22_;
		GcpDiagnosticTags* _tmp23_ = NULL;
		GtkTextTag* _tmp24_ = NULL;
		end = start;
		_tmp22_ = gtk_text_iter_ends_line (&start);
		if (!_tmp22_) {
			gtk_text_iter_forward_char (&end);
		}
		gcp_document_mark_diagnostic_range (self, diagnostic, &start, &end);
		_tmp23_ = gcp_diagnostic_support_get_tags (sup);
		_tmp24_ = gcp_diagnostic_tags_get_location_tag (_tmp23_);
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self->priv->d_document, _tmp24_, &start, &end);
	}
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				GcpDiagnosticFixit* _tmp26_ = NULL;
				gint _tmp27_;
				GcpDiagnosticFixit* _tmp28_ = NULL;
				gint _tmp29_;
				GcpSourceRange* _tmp30_;
				GcpSourceRange* r;
				GtkTextIter _tmp31_ = {0};
				GtkTextIter _tmp32_ = {0};
				gboolean _tmp33_;
				if (!_tmp25_) {
					i = i + 1;
				}
				_tmp25_ = FALSE;
				_tmp26_ = gcp_diagnostic_get_fixits (diagnostic, &_tmp27_);
				if (!(i < _tmp27_)) {
					break;
				}
				_tmp28_ = gcp_diagnostic_get_fixits (diagnostic, &_tmp29_);
				_tmp30_ = _g_object_ref0 (_tmp28_[i].range);
				r = _tmp30_;
				_tmp33_ = gcp_document_source_range (self, r, &_tmp31_, &_tmp32_);
				start = _tmp31_;
				end = _tmp32_;
				if (_tmp33_) {
					GcpDiagnosticTags* _tmp34_ = NULL;
					GtkTextTag* _tmp35_ = NULL;
					_tmp34_ = gcp_diagnostic_support_get_tags (sup);
					_tmp35_ = gcp_diagnostic_tags_get_fixit_tag (_tmp34_);
					gtk_text_buffer_apply_tag ((GtkTextBuffer*) self->priv->d_document, _tmp35_, &start, &end);
				}
				_g_object_unref0 (r);
			}
		}
	}
	_g_free0 (category);
	_g_object_unref0 (tag);
	_g_object_unref0 (sup);
}


static void gcp_document_on_diagnostic_updated (GcpDocument* self, GcpDiagnosticSupport* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GcpDiagnosticTags* _tmp2_ = NULL;
	GtkTextTag* _tmp3_ = NULL;
	GcpDiagnosticTags* _tmp4_ = NULL;
	GtkTextTag* _tmp5_ = NULL;
	GcpDiagnosticTags* _tmp6_ = NULL;
	GtkTextTag* _tmp7_ = NULL;
	GcpDiagnosticTags* _tmp8_ = NULL;
	GtkTextTag* _tmp9_ = NULL;
	GcpDiagnosticTags* _tmp10_ = NULL;
	GtkTextTag* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_document, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gcp_diagnostic_support_get_tags (diagnostic);
	_tmp3_ = gcp_diagnostic_tags_get_error_tag (_tmp2_);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_document, _tmp3_, &start, &end);
	_tmp4_ = gcp_diagnostic_support_get_tags (diagnostic);
	_tmp5_ = gcp_diagnostic_tags_get_warning_tag (_tmp4_);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_document, _tmp5_, &start, &end);
	_tmp6_ = gcp_diagnostic_support_get_tags (diagnostic);
	_tmp7_ = gcp_diagnostic_tags_get_info_tag (_tmp6_);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_document, _tmp7_, &start, &end);
	_tmp8_ = gcp_diagnostic_support_get_tags (diagnostic);
	_tmp9_ = gcp_diagnostic_tags_get_location_tag (_tmp8_);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_document, _tmp9_, &start, &end);
	_tmp10_ = gcp_diagnostic_support_get_tags (diagnostic);
	_tmp11_ = gcp_diagnostic_tags_get_fixit_tag (_tmp10_);
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_document, _tmp11_, &start, &end);
	gcp_document_remove_marks (self);
	{
		GcpSourceIndex* _tmp12_ = NULL;
		GcpSourceIndexIterator* _tmp13_ = NULL;
		GcpSourceIndexIterator* _diag_it;
		_tmp12_ = gcp_diagnostic_support_get_diagnostics (diagnostic);
		_tmp13_ = gcp_source_index_iterator (_tmp12_);
		_diag_it = _tmp13_;
		while (TRUE) {
			gboolean _tmp14_;
			gpointer _tmp15_ = NULL;
			GcpDiagnostic* diag;
			_tmp14_ = gcp_source_index_iterator_next (_diag_it);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = gcp_source_index_iterator_get (_diag_it);
			diag = (GcpDiagnostic*) _tmp15_;
			gcp_document_mark_diagnostic (self, diag);
			_g_object_unref0 (diag);
		}
		_g_object_unref0 (_diag_it);
	}
}


static void gcp_document_set_location (GcpDocument* self, GFile* location) {
	GFile* _tmp0_;
	GFile* prev;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	if (location == self->priv->d_location) {
		return;
	}
	_tmp0_ = _g_object_ref0 (self->priv->d_location);
	prev = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = _tmp1_;
	if ((prev == NULL) != (self->priv->d_location == NULL)) {
		g_signal_emit_by_name (self, "location-changed", prev);
	} else {
		gboolean _tmp2_ = FALSE;
		if (prev != NULL) {
			gboolean _tmp3_;
			_tmp3_ = g_file_equal (prev, self->priv->d_location);
			_tmp2_ = !_tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			g_signal_emit_by_name (self, "location-changed", prev);
		}
	}
	_g_object_unref0 (prev);
}


static void gcp_document_update_location (GcpDocument* self) {
	GeditDocument* _tmp0_ = NULL;
	gboolean _tmp1_;
	GeditDocument* _tmp2_ = NULL;
	gboolean _tmp3_;
	GeditDocument* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcp_document_get_document (self);
	_tmp1_ = gedit_document_is_untitled (_tmp0_);
	if (_tmp1_) {
		gcp_document_set_location (self, NULL);
		return;
	}
	_tmp2_ = gcp_document_get_document (self);
	_tmp3_ = gedit_document_is_local (_tmp2_);
	if (!_tmp3_) {
		gcp_document_set_location (self, NULL);
		return;
	}
	_tmp4_ = gcp_document_get_document (self);
	_tmp5_ = gedit_document_get_location (_tmp4_);
	_tmp6_ = _tmp5_;
	gcp_document_set_location (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
}


static void gcp_document_update_modified (GcpDocument* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) self->priv->d_document);
	if (self->priv->d_modified == _tmp0_) {
		return;
	}
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	self->priv->d_modified = !self->priv->d_modified;
	if (self->priv->d_modified) {
		gcp_document_update_text (self);
	} else {
		gcp_document_emit_changed (self);
	}
}


void gcp_document_emit_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	self->priv->d_tainted = TRUE;
	g_signal_emit_by_name (self, "changed");
}


static void gcp_document_update_text (GcpDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_document, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self->priv->d_document, &start, &end, TRUE);
	_g_free0 (self->priv->d_text);
	self->priv->d_text = _tmp2_;
	gcp_document_emit_changed (self);
}


static void gcp_document_on_document_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->d_modified) {
		gcp_document_update_text (self);
	}
}


static void gcp_document_on_document_modified_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_update_modified (self);
}


static void gcp_document_on_location_changed (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_update_location (self);
}


static void gcp_document_on_document_saved (GcpDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_document_emit_changed (self);
}


const gchar* gcp_document_get_error_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.ErrorCategory";
	return result;
}


const gchar* gcp_document_get_warning_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.WarningCategory";
	return result;
}


const gchar* gcp_document_get_info_mark_category (void) {
	const gchar* result;
	result = "Gcp.Document.InfoCategory";
	return result;
}


gboolean gcp_document_get_tainted (GcpDocument* self) {
	return GCP_DOCUMENT_GET_CLASS (self)->get_tainted (self);
}


static gboolean gcp_document_real_get_tainted (GcpDocument* base) {
	gboolean result;
	GcpDocument* self;
	self = base;
	result = self->priv->d_tainted;
	return result;
}


void gcp_document_set_tainted (GcpDocument* self, gboolean value) {
	GCP_DOCUMENT_GET_CLASS (self)->set_tainted (self, value);
}


static void gcp_document_real_set_tainted (GcpDocument* base, gboolean value) {
	GcpDocument* self;
	self = base;
	self->priv->d_tainted = FALSE;
	g_object_notify ((GObject *) self, "tainted");
}


GFile* gcp_document_get_location (GcpDocument* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_location;
	return result;
}


const gchar* gcp_document_get_text (GcpDocument* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_text;
	return result;
}


gboolean gcp_document_get_is_modified (GcpDocument* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_modified;
	return result;
}


GeditDocument* gcp_document_get_document (GcpDocument* self) {
	GeditDocument* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_document;
	return result;
}


static void gcp_document_class_init (GcpDocumentClass * klass) {
	gcp_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpDocumentPrivate));
	GCP_DOCUMENT_CLASS (klass)->get_tainted = gcp_document_real_get_tainted;
	GCP_DOCUMENT_CLASS (klass)->set_tainted = gcp_document_real_set_tainted;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_TAINTED, g_param_spec_boolean ("tainted", "tainted", "tainted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_IS_MODIFIED, g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DOCUMENT_DOCUMENT, g_param_spec_object ("document", "document", "document", gedit_document_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("location_changed", GCP_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_FILE);
	g_signal_new ("changed", GCP_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gcp_document_instance_init (GcpDocument * self) {
	self->priv = GCP_DOCUMENT_GET_PRIVATE (self);
}


static void gcp_document_finalize (GObject* obj) {
	GcpDocument * self;
	guint _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GcpDocument* _tmp5_;
	GcpDiagnosticSupport* _tmp6_;
	GcpDiagnosticSupport* diag;
	self = GCP_DOCUMENT (obj);
	g_signal_parse_name ("modified-changed", GTK_TYPE_TEXT_BUFFER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self->priv->d_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self);
	g_signal_parse_name ("notify::location", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->d_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _gcp_document_on_location_changed_g_object_notify, self);
	g_signal_parse_name ("changed", GTK_TYPE_TEXT_BUFFER, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self->priv->d_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gcp_document_on_document_changed_gtk_text_buffer_changed, self);
	g_signal_parse_name ("saved", gedit_document_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->d_document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gcp_document_on_document_saved_gedit_document_saved, self);
	_tmp5_ = self;
	_tmp6_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp5_) ? ((GcpDiagnosticSupport*) _tmp5_) : NULL);
	diag = _tmp6_;
	if (diag != NULL) {
		guint _tmp7_;
		g_signal_parse_name ("diagnostics-updated", GCP_TYPE_DIAGNOSTIC_SUPPORT, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (diag, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gcp_document_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self);
		gcp_document_remove_marks (self);
	}
	_g_object_unref0 (diag);
	_g_object_unref0 (self->priv->d_document);
	_g_free0 (self->priv->d_text);
	_g_object_unref0 (self->priv->d_location);
	G_OBJECT_CLASS (gcp_document_parent_class)->finalize (obj);
}


GType gcp_document_get_type (void) {
	return gcp_document_type_id;
}


GType gcp_document_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDocument), 0, (GInstanceInitFunc) gcp_document_instance_init, NULL };
	gcp_document_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpDocument", &g_define_type_info, 0);
	return gcp_document_type_id;
}


static void _vala_gcp_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpDocument * self;
	self = GCP_DOCUMENT (object);
	switch (property_id) {
		case GCP_DOCUMENT_TAINTED:
		g_value_set_boolean (value, gcp_document_get_tainted (self));
		break;
		case GCP_DOCUMENT_LOCATION:
		g_value_set_object (value, gcp_document_get_location (self));
		break;
		case GCP_DOCUMENT_TEXT:
		g_value_set_string (value, gcp_document_get_text (self));
		break;
		case GCP_DOCUMENT_IS_MODIFIED:
		g_value_set_boolean (value, gcp_document_get_is_modified (self));
		break;
		case GCP_DOCUMENT_DOCUMENT:
		g_value_set_object (value, gcp_document_get_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpDocument * self;
	self = GCP_DOCUMENT (object);
	switch (property_id) {
		case GCP_DOCUMENT_TAINTED:
		gcp_document_set_tainted (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



