/* gcp-source-index.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-source-index.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>


#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;
typedef struct _GcpSourceIndexPrivate GcpSourceIndexPrivate;

#define GCP_SOURCE_INDEX_TYPE_WRAPPER (gcp_source_index_wrapper_get_type ())
#define GCP_SOURCE_INDEX_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_WRAPPER, GcpSourceIndexWrapper))
#define GCP_SOURCE_INDEX_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_WRAPPER, GcpSourceIndexWrapperClass))
#define GCP_SOURCE_INDEX_IS_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_WRAPPER))
#define GCP_SOURCE_INDEX_IS_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_WRAPPER))
#define GCP_SOURCE_INDEX_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_WRAPPER, GcpSourceIndexWrapperClass))

typedef struct _GcpSourceIndexWrapper GcpSourceIndexWrapper;
typedef struct _GcpSourceIndexWrapperClass GcpSourceIndexWrapperClass;

#define GCP_SOURCE_INDEX_TYPE_FIND_FLAGS (gcp_source_index_find_flags_get_type ())
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;
typedef struct _GcpSourceIndexWrapperPrivate GcpSourceIndexWrapperPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_SOURCE_INDEX_TYPE_ITERATOR (gcp_source_index_iterator_get_type ())
#define GCP_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIterator))
#define GCP_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))
#define GCP_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))

typedef struct _GcpSourceIndexIterator GcpSourceIndexIterator;
typedef struct _GcpSourceIndexIteratorClass GcpSourceIndexIteratorClass;
typedef struct _GcpSourceIndexIteratorPrivate GcpSourceIndexIteratorPrivate;

struct _GcpSourceIndex {
	GObject parent_instance;
	GcpSourceIndexPrivate * priv;
};

struct _GcpSourceIndexClass {
	GObjectClass parent_class;
};

struct _GcpSourceIndexPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GSequence* d_index;
};

typedef enum  {
	GCP_SOURCE_INDEX_FIND_FLAGS_NONE = 0,
	GCP_SOURCE_INDEX_FIND_FLAGS_LINE_ONLY = 1 << 0,
	GCP_SOURCE_INDEX_FIND_FLAGS_INNER_MOST = 1 << 1
} GcpSourceIndexFindFlags;

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

typedef void (*GcpSourceIndexWrapEachFunc) (GcpSourceIndexWrapper* wrapper, void* user_data);
struct _GcpSourceIndexWrapper {
	GObject parent_instance;
	GcpSourceIndexWrapperPrivate * priv;
	GcpSourceRangeSupport* obj;
	GcpSourceRange* range;
	gint idx;
	gboolean encapsulated;
};

struct _GcpSourceIndexWrapperClass {
	GObjectClass parent_class;
};

struct _GcpSourceIndexIterator {
	GObject parent_instance;
	GcpSourceIndexIteratorPrivate * priv;
};

struct _GcpSourceIndexIteratorClass {
	GObjectClass parent_class;
};

struct _GcpSourceIndexIteratorPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GSequenceIter* d_iter;
	gboolean d_first;
};


static gpointer gcp_source_index_parent_class = NULL;
static gpointer gcp_source_index_wrapper_parent_class = NULL;
static GType gcp_source_index_wrapper_type_id = 0;
static gpointer gcp_source_index_iterator_parent_class = NULL;
static GType gcp_source_index_iterator_type_id = 0;
static GType gcp_source_index_type_id = 0;

GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_source_index_wrapper_get_type (void) G_GNUC_CONST;
GType gcp_source_index_wrapper_register_type (GTypeModule * module);
#define GCP_SOURCE_INDEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexPrivate))
enum  {
	GCP_SOURCE_INDEX_DUMMY_PROPERTY,
	GCP_SOURCE_INDEX_T_TYPE,
	GCP_SOURCE_INDEX_T_DUP_FUNC,
	GCP_SOURCE_INDEX_T_DESTROY_FUNC,
	GCP_SOURCE_INDEX_LENGTH
};
static GType gcp_source_index_find_flags_get_type (void) G_GNUC_UNUSED;
GcpSourceIndex* gcp_source_index_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GcpSourceIndex* gcp_source_index_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
void gcp_source_index_add (GcpSourceIndex* self, GcpSourceRangeSupport* range);
static void gcp_source_index_wrap_each (GcpSourceIndex* self, GcpSourceRangeSupport* range, GcpSourceIndexWrapEachFunc func, void* func_target);
static void _lambda1_ (GcpSourceIndexWrapper* wrapper, GcpSourceIndex* self);
static gint gcp_source_index_compare_func (GcpSourceIndex* self, GcpSourceIndexWrapper* a, GcpSourceIndexWrapper* b);
static gint _gcp_source_index_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
gboolean gcp_source_range_contains_range (GcpSourceRange* self, GcpSourceRange* range);
static void __lambda1__gcp_source_index_wrap_each_func (GcpSourceIndexWrapper* wrapper, gpointer self);
gpointer gcp_source_index_get (GcpSourceIndex* self, gint idx);
static GSequenceIter* gcp_source_index_find_iter (GcpSourceIndex* self, GcpSourceIndexWrapper* wrapper);
gint gcp_source_range_compare_to (GcpSourceRange* self, GcpSourceRange* other);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
GcpSourceIndexWrapper* gcp_source_index_wrapper_new (GcpSourceRangeSupport* obj, GcpSourceRange* range, gint idx);
GcpSourceIndexWrapper* gcp_source_index_wrapper_construct (GType object_type, GcpSourceRangeSupport* obj, GcpSourceRange* range, gint idx);
void gcp_source_index_remove (GcpSourceIndex* self, GcpSourceRangeSupport* range);
static void _lambda2_ (GcpSourceIndexWrapper* wrapper, GcpSourceIndex* self);
static void __lambda2__gcp_source_index_wrap_each_func (GcpSourceIndexWrapper* wrapper, gpointer self);
gpointer* gcp_source_index_find_at_line (GcpSourceIndex* self, gint line, int* result_length1);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
static gpointer* gcp_source_index_find_at_priv (GcpSourceIndex* self, GcpSourceLocation* location, GcpSourceIndexFindFlags flags, int* result_length1);
GcpSourceLocation* gcp_source_location_new (GFile* file, gint line, gint column);
GcpSourceLocation* gcp_source_location_construct (GType object_type, GFile* file, gint line, gint column);
gpointer* gcp_source_index_find_at (GcpSourceIndex* self, GcpSourceLocation* location, int* result_length1);
gpointer gcp_source_index_find_inner_at (GcpSourceIndex* self, GcpSourceLocation* location);
static gboolean gcp_source_index_find_at_condition (GcpSourceIndex* self, GcpSourceIndexWrapper* wrapper, GcpSourceLocation* location, GcpSourceIndexFindFlags flags);
gboolean gcp_source_range_contains_line (GcpSourceRange* self, gint line);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gboolean gcp_source_range_contains_location (GcpSourceRange* self, GcpSourceLocation* location);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
void gcp_source_index_clear (GcpSourceIndex* self);
GType gcp_source_index_iterator_get_type (void) G_GNUC_CONST;
GType gcp_source_index_iterator_register_type (GTypeModule * module);
GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self);
GcpSourceIndexIterator* gcp_source_index_iterator_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GSequenceIter* iter);
GcpSourceIndexIterator* gcp_source_index_iterator_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GSequenceIter* iter);
gint gcp_source_index_get_length (GcpSourceIndex* self);
enum  {
	GCP_SOURCE_INDEX_WRAPPER_DUMMY_PROPERTY
};
static void gcp_source_index_wrapper_finalize (GObject* obj);
#define GCP_SOURCE_INDEX_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorPrivate))
enum  {
	GCP_SOURCE_INDEX_ITERATOR_DUMMY_PROPERTY,
	GCP_SOURCE_INDEX_ITERATOR_T_TYPE,
	GCP_SOURCE_INDEX_ITERATOR_T_DUP_FUNC,
	GCP_SOURCE_INDEX_ITERATOR_T_DESTROY_FUNC
};
gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self);
gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self);
static void gcp_source_index_iterator_finalize (GObject* obj);
static void _vala_gcp_source_index_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_source_index_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gcp_source_index_finalize (GObject* obj);
static void _vala_gcp_source_index_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_source_index_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType gcp_source_index_find_flags_get_type (void) {
	static volatile gsize gcp_source_index_find_flags_type_id__volatile = 0;
	if (g_once_init_enter (&gcp_source_index_find_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{GCP_SOURCE_INDEX_FIND_FLAGS_NONE, "GCP_SOURCE_INDEX_FIND_FLAGS_NONE", "none"}, {GCP_SOURCE_INDEX_FIND_FLAGS_LINE_ONLY, "GCP_SOURCE_INDEX_FIND_FLAGS_LINE_ONLY", "line-only"}, {GCP_SOURCE_INDEX_FIND_FLAGS_INNER_MOST, "GCP_SOURCE_INDEX_FIND_FLAGS_INNER_MOST", "inner-most"}, {0, NULL, NULL}};
		GType gcp_source_index_find_flags_type_id;
		gcp_source_index_find_flags_type_id = g_flags_register_static ("GcpSourceIndexFindFlags", values);
		g_once_init_leave (&gcp_source_index_find_flags_type_id__volatile, gcp_source_index_find_flags_type_id);
	}
	return gcp_source_index_find_flags_type_id__volatile;
}


GcpSourceIndex* gcp_source_index_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func) {
	GcpSourceIndex * self = NULL;
	GSequence* _tmp0_ = NULL;
	self = (GcpSourceIndex*) g_object_new (object_type, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	_tmp0_ = g_sequence_new (NULL);
	_g_sequence_free0 (self->priv->d_index);
	self->priv->d_index = _tmp0_;
	return self;
}


GcpSourceIndex* gcp_source_index_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func) {
	return gcp_source_index_construct (GCP_TYPE_SOURCE_INDEX, t_type, t_dup_func, t_destroy_func);
}


static gint _gcp_source_index_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = gcp_source_index_compare_func (self, a, b);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda1_ (GcpSourceIndexWrapper* wrapper, GcpSourceIndex* self) {
	GSequenceIter* _tmp0_ = NULL;
	GSequenceIter* iter;
	GSequenceIter* prev;
	GcpSourceIndexWrapper* _tmp6_;
	GSequenceIter* _tmp7_ = NULL;
	g_return_if_fail (wrapper != NULL);
	_tmp0_ = g_sequence_search (self->priv->d_index, wrapper, _gcp_source_index_compare_func_gcompare_data_func, self);
	iter = _tmp0_;
	prev = iter;
	while (TRUE) {
		gboolean _tmp1_;
		GSequenceIter* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		gconstpointer _tmp5_ = NULL;
		_tmp1_ = g_sequence_iter_is_begin (prev);
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = g_sequence_iter_prev (prev);
		prev = _tmp2_;
		_tmp3_ = g_sequence_get (prev);
		_tmp4_ = gcp_source_range_contains_range (((GcpSourceIndexWrapper*) _tmp3_)->range, wrapper->range);
		if (_tmp4_) {
			wrapper->encapsulated = TRUE;
			break;
		}
		_tmp5_ = g_sequence_get (prev);
		if (!((GcpSourceIndexWrapper*) _tmp5_)->encapsulated) {
			break;
		}
	}
	_tmp6_ = _g_object_ref0 (wrapper);
	_tmp7_ = g_sequence_insert_before (iter, _tmp6_);
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gconstpointer _tmp12_ = NULL;
		GSequenceIter* _tmp13_ = NULL;
		_tmp9_ = g_sequence_iter_is_end (iter);
		if (!_tmp9_) {
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_;
			_tmp10_ = g_sequence_get (iter);
			_tmp11_ = gcp_source_range_contains_range (wrapper->range, ((GcpSourceIndexWrapper*) _tmp10_)->range);
			_tmp8_ = _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp12_ = g_sequence_get (iter);
		((GcpSourceIndexWrapper*) _tmp12_)->encapsulated = TRUE;
		_tmp13_ = g_sequence_iter_next (iter);
		iter = _tmp13_;
	}
}


static void __lambda1__gcp_source_index_wrap_each_func (GcpSourceIndexWrapper* wrapper, gpointer self) {
	_lambda1_ (wrapper, self);
}


void gcp_source_index_add (GcpSourceIndex* self, GcpSourceRangeSupport* range) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	gcp_source_index_wrap_each (self, range, __lambda1__gcp_source_index_wrap_each_func, self);
}


gpointer gcp_source_index_get (GcpSourceIndex* self, gint idx) {
	gpointer result = NULL;
	GSequenceIter* _tmp0_ = NULL;
	GSequenceIter* iter;
	gconstpointer _tmp1_ = NULL;
	gpointer _tmp2_;
	gconstpointer _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_sequence_get_iter_at_pos (self->priv->d_index, idx);
	iter = _tmp0_;
	if (iter == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_sequence_get (iter);
	_tmp2_ = (_tmp3_ = (gconstpointer) ((GcpSourceIndexWrapper*) _tmp1_)->obj, ((_tmp3_ == NULL) || (self->priv->t_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->t_dup_func ((gpointer) _tmp3_));
	result = _tmp2_;
	return result;
}


static GSequenceIter* gcp_source_index_find_iter (GcpSourceIndex* self, GcpSourceIndexWrapper* wrapper) {
	GSequenceIter* result = NULL;
	GSequenceIter* iter = NULL;
	GSequenceIter* _tmp0_ = NULL;
	GSequenceIter* _tmp12_ = NULL;
	gconstpointer _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (wrapper != NULL, NULL);
	_tmp0_ = g_sequence_search (self->priv->d_index, wrapper, _gcp_source_index_compare_func_gcompare_data_func, self);
	iter = _tmp0_;
	if (iter == NULL) {
		result = NULL;
		return result;
	}
	while (TRUE) {
		gboolean _tmp1_;
		GSequenceIter* _tmp2_ = NULL;
		GSequenceIter* prev;
		gconstpointer _tmp3_ = NULL;
		gint _tmp4_;
		_tmp1_ = g_sequence_iter_is_begin (iter);
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = g_sequence_iter_prev (iter);
		prev = _tmp2_;
		_tmp3_ = g_sequence_get (prev);
		_tmp4_ = gcp_source_range_compare_to (((GcpSourceIndexWrapper*) _tmp3_)->range, wrapper->range);
		if (_tmp4_ != 0) {
			break;
		}
		iter = prev;
	}
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		GSequenceIter* _tmp11_ = NULL;
		_tmp7_ = g_sequence_iter_is_end (iter);
		if (!_tmp7_) {
			gconstpointer _tmp8_ = NULL;
			gint _tmp9_;
			_tmp8_ = g_sequence_get (iter);
			_tmp9_ = gcp_source_range_compare_to (((GcpSourceIndexWrapper*) _tmp8_)->range, wrapper->range);
			_tmp6_ = _tmp9_ == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gconstpointer _tmp10_ = NULL;
			_tmp10_ = g_sequence_get (iter);
			_tmp5_ = ((GcpSourceIndexWrapper*) _tmp10_)->obj != wrapper->obj;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp11_ = g_sequence_iter_next (iter);
		iter = _tmp11_;
	}
	_tmp13_ = g_sequence_get (iter);
	if (((GcpSourceIndexWrapper*) _tmp13_)->obj == wrapper->obj) {
		_tmp12_ = iter;
	} else {
		_tmp12_ = NULL;
	}
	result = _tmp12_;
	return result;
}


static void gcp_source_index_wrap_each (GcpSourceIndex* self, GcpSourceRangeSupport* range, GcpSourceIndexWrapEachFunc func, void* func_target) {
	GcpSourceRange** _tmp0_ = NULL;
	gint _tmp1_;
	GcpSourceRange** ranges;
	gint ranges_length1;
	gint _ranges_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_tmp0_ = gcp_source_range_support_get_ranges (range, &_tmp1_);
	ranges = _tmp0_;
	ranges_length1 = _tmp1_;
	_ranges_size_ = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				GcpSourceIndexWrapper* _tmp3_ = NULL;
				GcpSourceIndexWrapper* _tmp4_;
				if (!_tmp2_) {
					i = i + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ranges_length1)) {
					break;
				}
				_tmp3_ = gcp_source_index_wrapper_new (range, ranges[i], i);
				_tmp4_ = _tmp3_;
				func (_tmp4_, func_target);
				_g_object_unref0 (_tmp4_);
			}
		}
	}
	ranges = (_vala_array_free (ranges, ranges_length1, (GDestroyNotify) g_object_unref), NULL);
}


static void _lambda2_ (GcpSourceIndexWrapper* wrapper, GcpSourceIndex* self) {
	GSequenceIter* iter = NULL;
	GSequenceIter* _tmp0_ = NULL;
	g_return_if_fail (wrapper != NULL);
	_tmp0_ = gcp_source_index_find_iter (self, wrapper);
	iter = _tmp0_;
	if (iter != NULL) {
		g_sequence_remove (iter);
	}
}


static void __lambda2__gcp_source_index_wrap_each_func (GcpSourceIndexWrapper* wrapper, gpointer self) {
	_lambda2_ (wrapper, self);
}


void gcp_source_index_remove (GcpSourceIndex* self, GcpSourceRangeSupport* range) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	gcp_source_index_wrap_each (self, range, __lambda2__gcp_source_index_wrap_each_func, self);
}


gpointer* gcp_source_index_find_at_line (GcpSourceIndex* self, gint line, int* result_length1) {
	gpointer* result = NULL;
	GcpSourceLocation* _tmp0_ = NULL;
	GcpSourceLocation* _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_ = NULL;
	gpointer* _tmp4_;
	gpointer* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gcp_source_location_new (NULL, line, 0);
	_tmp1_ = _tmp0_;
	_tmp3_ = gcp_source_index_find_at_priv (self, _tmp1_, GCP_SOURCE_INDEX_FIND_FLAGS_LINE_ONLY, &_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	_tmp5_ = _tmp4_;
	*result_length1 = _tmp2_;
	result = _tmp5_;
	return result;
}


gpointer* gcp_source_index_find_at (GcpSourceIndex* self, GcpSourceLocation* location, int* result_length1) {
	gpointer* result = NULL;
	gint _tmp0_;
	gpointer* _tmp1_ = NULL;
	gpointer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp1_ = gcp_source_index_find_at_priv (self, location, GCP_SOURCE_INDEX_FIND_FLAGS_NONE, &_tmp0_);
	_tmp2_ = _tmp1_;
	*result_length1 = _tmp0_;
	result = _tmp2_;
	return result;
}


gpointer gcp_source_index_find_inner_at (GcpSourceIndex* self, GcpSourceLocation* location) {
	gpointer result = NULL;
	gint _tmp0_;
	gpointer* _tmp1_ = NULL;
	gpointer* ret;
	gint ret_length1;
	gint _ret_size_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp1_ = gcp_source_index_find_at_priv (self, location, GCP_SOURCE_INDEX_FIND_FLAGS_INNER_MOST, &_tmp0_);
	ret = _tmp1_;
	ret_length1 = _tmp0_;
	_ret_size_ = _tmp0_;
	if (ret_length1 == 0) {
		result = NULL;
		ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) self->priv->t_destroy_func), NULL);
		return result;
	} else {
		gpointer _tmp2_;
		_tmp2_ = ret[0];
		ret[0] = NULL;
		result = _tmp2_;
		ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) self->priv->t_destroy_func), NULL);
		return result;
	}
	ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) self->priv->t_destroy_func), NULL);
}


static gboolean gcp_source_index_find_at_condition (GcpSourceIndex* self, GcpSourceIndexWrapper* wrapper, GcpSourceLocation* location, GcpSourceIndexFindFlags flags) {
	gboolean result = FALSE;
	gboolean lineonly;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wrapper != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	lineonly = (flags & GCP_SOURCE_INDEX_FIND_FLAGS_LINE_ONLY) != 0;
	if (lineonly) {
		gint _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = gcp_source_location_get_line (location);
		_tmp3_ = gcp_source_range_contains_line (wrapper->range, _tmp2_);
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (!lineonly) {
			gboolean _tmp5_;
			_tmp5_ = gcp_source_range_contains_location (wrapper->range, location);
			_tmp4_ = _tmp5_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gpointer* gcp_source_index_find_at_priv (GcpSourceIndex* self, GcpSourceLocation* location, GcpSourceIndexFindFlags flags, int* result_length1) {
	gpointer* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* ret;
	GSequenceIter* iter = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* uniq;
	GcpSourceRange* _tmp2_ = NULL;
	GcpSourceRange* _tmp3_;
	GcpSourceIndexWrapper* _tmp4_ = NULL;
	GcpSourceIndexWrapper* _tmp5_;
	GSequenceIter* _tmp6_ = NULL;
	gboolean _tmp19_;
	gint _tmp48_;
	gpointer* _tmp49_ = NULL;
	gpointer* _tmp50_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = gee_linked_list_new (self->priv->t_type, (GBoxedCopyFunc) self->priv->t_dup_func, self->priv->t_destroy_func, NULL);
	ret = _tmp0_;
	_tmp1_ = gee_hash_map_new (self->priv->t_type, (GBoxedCopyFunc) self->priv->t_dup_func, self->priv->t_destroy_func, G_TYPE_BOOLEAN, NULL, NULL, g_direct_hash, g_direct_equal, NULL);
	uniq = _tmp1_;
	_tmp2_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) location);
	_tmp3_ = _tmp2_;
	_tmp4_ = gcp_source_index_wrapper_new ((GcpSourceRangeSupport*) location, _tmp3_, 0);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_sequence_search (self->priv->d_index, _tmp5_, _gcp_source_index_compare_func_gcompare_data_func, self);
	iter = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	if ((flags & GCP_SOURCE_INDEX_FIND_FLAGS_INNER_MOST) != 0) {
		gpointer* _tmp17_ = NULL;
		gpointer* _tmp18_;
		while (TRUE) {
			gboolean _tmp7_;
			GSequenceIter* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			gboolean _tmp10_;
			_tmp7_ = g_sequence_iter_is_begin (iter);
			if (!(!_tmp7_)) {
				break;
			}
			_tmp8_ = g_sequence_iter_prev (iter);
			iter = _tmp8_;
			_tmp9_ = g_sequence_get (iter);
			_tmp10_ = gcp_source_index_find_at_condition (self, (GcpSourceIndexWrapper*) _tmp9_, location, flags);
			if (_tmp10_) {
				gconstpointer _tmp11_ = NULL;
				gpointer _tmp12_;
				gconstpointer _tmp13_;
				gpointer* _tmp14_ = NULL;
				gpointer* _tmp15_;
				_tmp11_ = g_sequence_get (iter);
				_tmp12_ = (_tmp13_ = ((GcpSourceIndexWrapper*) _tmp11_)->obj, ((_tmp13_ == NULL) || (self->priv->t_dup_func == NULL)) ? ((gpointer) _tmp13_) : self->priv->t_dup_func ((gpointer) _tmp13_));
				_tmp14_ = g_new0 (gpointer, 1);
				_tmp14_[0] = _tmp12_;
				_tmp15_ = _tmp14_;
				*result_length1 = 1;
				result = _tmp15_;
				_g_object_unref0 (uniq);
				_g_object_unref0 (ret);
				return result;
			} else {
				gconstpointer _tmp16_ = NULL;
				_tmp16_ = g_sequence_get (iter);
				if (!((GcpSourceIndexWrapper*) _tmp16_)->encapsulated) {
					break;
				}
			}
		}
		_tmp17_ = g_new0 (gpointer, 0);
		_tmp18_ = _tmp17_;
		*result_length1 = 0;
		result = _tmp18_;
		_g_object_unref0 (uniq);
		_g_object_unref0 (ret);
		return result;
	}
	_tmp19_ = g_sequence_iter_is_begin (iter);
	if (!_tmp19_) {
		GSequenceIter* _tmp20_ = NULL;
		GSequenceIter* prev;
		_tmp20_ = g_sequence_iter_prev (iter);
		prev = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			gconstpointer _tmp22_ = NULL;
			gboolean _tmp23_;
			gconstpointer _tmp25_ = NULL;
			gpointer _tmp26_;
			gconstpointer _tmp27_;
			gpointer val;
			gboolean _tmp28_ = FALSE;
			gconstpointer _tmp29_ = NULL;
			gboolean _tmp30_;
			gboolean _tmp32_;
			GSequenceIter* _tmp33_ = NULL;
			_tmp22_ = g_sequence_get (prev);
			_tmp23_ = gcp_source_index_find_at_condition (self, (GcpSourceIndexWrapper*) _tmp22_, location, flags);
			if (_tmp23_) {
				_tmp21_ = TRUE;
			} else {
				gconstpointer _tmp24_ = NULL;
				_tmp24_ = g_sequence_get (prev);
				_tmp21_ = ((GcpSourceIndexWrapper*) _tmp24_)->encapsulated;
			}
			if (!_tmp21_) {
				break;
			}
			_tmp25_ = g_sequence_get (prev);
			_tmp26_ = (_tmp27_ = (gconstpointer) ((GcpSourceIndexWrapper*) _tmp25_)->obj, ((_tmp27_ == NULL) || (self->priv->t_dup_func == NULL)) ? ((gpointer) _tmp27_) : self->priv->t_dup_func ((gpointer) _tmp27_));
			val = _tmp26_;
			_tmp29_ = g_sequence_get (prev);
			_tmp30_ = gcp_source_index_find_at_condition (self, (GcpSourceIndexWrapper*) _tmp29_, location, flags);
			if (_tmp30_) {
				gboolean _tmp31_;
				_tmp31_ = gee_abstract_map_has_key ((GeeAbstractMap*) uniq, val);
				_tmp28_ = !_tmp31_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gee_abstract_list_insert ((GeeAbstractList*) ret, 0, val);
				gee_abstract_map_set ((GeeAbstractMap*) uniq, val, GINT_TO_POINTER (TRUE));
			}
			_tmp32_ = g_sequence_iter_is_begin (prev);
			if (_tmp32_) {
				((val == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (val = (self->priv->t_destroy_func (val), NULL));
				break;
			}
			_tmp33_ = g_sequence_iter_prev (prev);
			prev = _tmp33_;
			((val == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (val = (self->priv->t_destroy_func (val), NULL));
		}
	}
	while (TRUE) {
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_;
		gconstpointer _tmp40_ = NULL;
		gpointer _tmp41_;
		gconstpointer _tmp42_;
		gpointer val;
		gboolean _tmp43_ = FALSE;
		gconstpointer _tmp44_ = NULL;
		gboolean _tmp45_;
		GSequenceIter* _tmp47_ = NULL;
		_tmp35_ = g_sequence_iter_is_end (iter);
		if (!_tmp35_) {
			gboolean _tmp36_ = FALSE;
			gconstpointer _tmp37_ = NULL;
			gboolean _tmp38_;
			_tmp37_ = g_sequence_get (iter);
			_tmp38_ = gcp_source_index_find_at_condition (self, (GcpSourceIndexWrapper*) _tmp37_, location, flags);
			if (_tmp38_) {
				_tmp36_ = TRUE;
			} else {
				gconstpointer _tmp39_ = NULL;
				_tmp39_ = g_sequence_get (iter);
				_tmp36_ = ((GcpSourceIndexWrapper*) _tmp39_)->encapsulated;
			}
			_tmp34_ = _tmp36_;
		} else {
			_tmp34_ = FALSE;
		}
		if (!_tmp34_) {
			break;
		}
		_tmp40_ = g_sequence_get (iter);
		_tmp41_ = (_tmp42_ = (gconstpointer) ((GcpSourceIndexWrapper*) _tmp40_)->obj, ((_tmp42_ == NULL) || (self->priv->t_dup_func == NULL)) ? ((gpointer) _tmp42_) : self->priv->t_dup_func ((gpointer) _tmp42_));
		val = _tmp41_;
		_tmp44_ = g_sequence_get (iter);
		_tmp45_ = gcp_source_index_find_at_condition (self, (GcpSourceIndexWrapper*) _tmp44_, location, flags);
		if (_tmp45_) {
			gboolean _tmp46_;
			_tmp46_ = gee_abstract_map_has_key ((GeeAbstractMap*) uniq, val);
			_tmp43_ = !_tmp46_;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			gee_abstract_collection_add ((GeeAbstractCollection*) ret, val);
			gee_abstract_map_set ((GeeAbstractMap*) uniq, val, GINT_TO_POINTER (TRUE));
		}
		_tmp47_ = g_sequence_iter_next (iter);
		iter = _tmp47_;
		((val == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (val = (self->priv->t_destroy_func (val), NULL));
	}
	_tmp49_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) ret, &_tmp48_);
	_tmp50_ = _tmp49_;
	*result_length1 = _tmp48_;
	result = _tmp50_;
	_g_object_unref0 (uniq);
	_g_object_unref0 (ret);
	return result;
}


void gcp_source_index_clear (GcpSourceIndex* self) {
	GSequenceIter* _tmp0_ = NULL;
	GSequenceIter* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_sequence_get_begin_iter (self->priv->d_index);
	_tmp1_ = g_sequence_get_end_iter (self->priv->d_index);
	g_sequence_remove_range (_tmp0_, _tmp1_);
}


static gint gcp_source_index_compare_func (GcpSourceIndex* self, GcpSourceIndexWrapper* a, GcpSourceIndexWrapper* b) {
	gint result = 0;
	GcpSourceRange* _tmp0_;
	GcpSourceRange* ra;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* rb;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (a->range);
	ra = _tmp0_;
	_tmp1_ = _g_object_ref0 (b->range);
	rb = _tmp1_;
	_tmp2_ = gcp_source_range_compare_to (ra, rb);
	result = _tmp2_;
	_g_object_unref0 (rb);
	_g_object_unref0 (ra);
	return result;
}


GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self) {
	GcpSourceIndexIterator* result = NULL;
	GSequenceIter* _tmp0_ = NULL;
	GcpSourceIndexIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_sequence_get_begin_iter (self->priv->d_index);
	_tmp1_ = gcp_source_index_iterator_new (self->priv->t_type, (GBoxedCopyFunc) self->priv->t_dup_func, self->priv->t_destroy_func, _tmp0_);
	result = _tmp1_;
	return result;
}


gint gcp_source_index_get_length (GcpSourceIndex* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_sequence_get_length (self->priv->d_index);
	result = _tmp0_;
	return result;
}


GcpSourceIndexWrapper* gcp_source_index_wrapper_construct (GType object_type, GcpSourceRangeSupport* obj, GcpSourceRange* range, gint idx) {
	GcpSourceIndexWrapper * self = NULL;
	GcpSourceRangeSupport* _tmp0_;
	GcpSourceRange* _tmp1_;
	g_return_val_if_fail (obj != NULL, NULL);
	g_return_val_if_fail (range != NULL, NULL);
	self = (GcpSourceIndexWrapper*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (obj);
	_g_object_unref0 (self->obj);
	self->obj = _tmp0_;
	_tmp1_ = _g_object_ref0 (range);
	_g_object_unref0 (self->range);
	self->range = _tmp1_;
	self->idx = idx;
	self->encapsulated = FALSE;
	return self;
}


GcpSourceIndexWrapper* gcp_source_index_wrapper_new (GcpSourceRangeSupport* obj, GcpSourceRange* range, gint idx) {
	return gcp_source_index_wrapper_construct (GCP_SOURCE_INDEX_TYPE_WRAPPER, obj, range, idx);
}


static void gcp_source_index_wrapper_class_init (GcpSourceIndexWrapperClass * klass) {
	gcp_source_index_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gcp_source_index_wrapper_finalize;
}


static void gcp_source_index_wrapper_instance_init (GcpSourceIndexWrapper * self) {
}


static void gcp_source_index_wrapper_finalize (GObject* obj) {
	GcpSourceIndexWrapper * self;
	self = GCP_SOURCE_INDEX_WRAPPER (obj);
	_g_object_unref0 (self->obj);
	_g_object_unref0 (self->range);
	G_OBJECT_CLASS (gcp_source_index_wrapper_parent_class)->finalize (obj);
}


GType gcp_source_index_wrapper_get_type (void) {
	return gcp_source_index_wrapper_type_id;
}


GType gcp_source_index_wrapper_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpSourceIndexWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_source_index_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpSourceIndexWrapper), 0, (GInstanceInitFunc) gcp_source_index_wrapper_instance_init, NULL };
	gcp_source_index_wrapper_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpSourceIndexWrapper", &g_define_type_info, 0);
	return gcp_source_index_wrapper_type_id;
}


GcpSourceIndexIterator* gcp_source_index_iterator_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GSequenceIter* iter) {
	GcpSourceIndexIterator * self = NULL;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GcpSourceIndexIterator*) g_object_new (object_type, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	self->priv->d_iter = iter;
	self->priv->d_first = TRUE;
	return self;
}


GcpSourceIndexIterator* gcp_source_index_iterator_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GSequenceIter* iter) {
	return gcp_source_index_iterator_construct (GCP_SOURCE_INDEX_TYPE_ITERATOR, t_type, t_dup_func, t_destroy_func, iter);
}


gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self) {
	gboolean result = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->d_first) {
		self->priv->d_first = FALSE;
	} else {
		gboolean _tmp0_;
		_tmp0_ = g_sequence_iter_is_end (self->priv->d_iter);
		if (!_tmp0_) {
			GSequenceIter* _tmp1_ = NULL;
			_tmp1_ = g_sequence_iter_next (self->priv->d_iter);
			self->priv->d_iter = _tmp1_;
		}
	}
	_tmp2_ = g_sequence_iter_is_end (self->priv->d_iter);
	result = !_tmp2_;
	return result;
}


gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self) {
	gpointer result = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_;
	gconstpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_sequence_get (self->priv->d_iter);
	_tmp1_ = (_tmp2_ = (gconstpointer) ((GcpSourceIndexWrapper*) _tmp0_)->obj, ((_tmp2_ == NULL) || (self->priv->t_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->t_dup_func ((gpointer) _tmp2_));
	result = _tmp1_;
	return result;
}


static void gcp_source_index_iterator_class_init (GcpSourceIndexIteratorClass * klass) {
	gcp_source_index_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpSourceIndexIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_source_index_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_source_index_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_source_index_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_ITERATOR_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_ITERATOR_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_ITERATOR_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gcp_source_index_iterator_instance_init (GcpSourceIndexIterator * self) {
	self->priv = GCP_SOURCE_INDEX_ITERATOR_GET_PRIVATE (self);
}


static void gcp_source_index_iterator_finalize (GObject* obj) {
	GcpSourceIndexIterator * self;
	self = GCP_SOURCE_INDEX_ITERATOR (obj);
	G_OBJECT_CLASS (gcp_source_index_iterator_parent_class)->finalize (obj);
}


GType gcp_source_index_iterator_get_type (void) {
	return gcp_source_index_iterator_type_id;
}


GType gcp_source_index_iterator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpSourceIndexIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_source_index_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpSourceIndexIterator), 0, (GInstanceInitFunc) gcp_source_index_iterator_instance_init, NULL };
	gcp_source_index_iterator_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpSourceIndexIterator", &g_define_type_info, 0);
	return gcp_source_index_iterator_type_id;
}


static void _vala_gcp_source_index_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpSourceIndexIterator * self;
	self = GCP_SOURCE_INDEX_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_source_index_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpSourceIndexIterator * self;
	self = GCP_SOURCE_INDEX_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GCP_SOURCE_INDEX_ITERATOR_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case GCP_SOURCE_INDEX_ITERATOR_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case GCP_SOURCE_INDEX_ITERATOR_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gcp_source_index_class_init (GcpSourceIndexClass * klass) {
	gcp_source_index_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpSourceIndexPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_source_index_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_source_index_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_source_index_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_INDEX_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_source_index_instance_init (GcpSourceIndex * self) {
	self->priv = GCP_SOURCE_INDEX_GET_PRIVATE (self);
}


static void gcp_source_index_finalize (GObject* obj) {
	GcpSourceIndex * self;
	self = GCP_SOURCE_INDEX (obj);
	_g_sequence_free0 (self->priv->d_index);
	G_OBJECT_CLASS (gcp_source_index_parent_class)->finalize (obj);
}


GType gcp_source_index_get_type (void) {
	return gcp_source_index_type_id;
}


GType gcp_source_index_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpSourceIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_source_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpSourceIndex), 0, (GInstanceInitFunc) gcp_source_index_instance_init, NULL };
	gcp_source_index_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpSourceIndex", &g_define_type_info, 0);
	return gcp_source_index_type_id;
}


static void _vala_gcp_source_index_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpSourceIndex * self;
	self = GCP_SOURCE_INDEX (object);
	switch (property_id) {
		case GCP_SOURCE_INDEX_LENGTH:
		g_value_set_int (value, gcp_source_index_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_source_index_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpSourceIndex * self;
	self = GCP_SOURCE_INDEX (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GCP_SOURCE_INDEX_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case GCP_SOURCE_INDEX_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case GCP_SOURCE_INDEX_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



