/* gcp-diagnostic.c generated by valac 0.14.0, the Vala compiler
 * generated from gcp-diagnostic.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;
typedef struct _GcpDiagnosticPrivate GcpDiagnosticPrivate;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_DIAGNOSTIC_TYPE_FIXIT (gcp_diagnostic_fixit_get_type ())
typedef struct _GcpDiagnosticFixit GcpDiagnosticFixit;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

struct _GcpDiagnostic {
	GObject parent_instance;
	GcpDiagnosticPrivate * priv;
};

struct _GcpDiagnosticClass {
	GObjectClass parent_class;
};

struct _GcpDiagnosticFixit {
	GcpSourceRange* range;
	gchar* replacement;
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpDiagnosticPrivate {
	GcpSourceLocation* d_location;
	GcpSourceRange** d_ranges;
	gint d_ranges_length1;
	gint _d_ranges_size_;
	GcpSourceRange** d_rangesAndLocation;
	gint d_rangesAndLocation_length1;
	gint _d_rangesAndLocation_size_;
	GcpDiagnosticFixit* d_fixits;
	gint d_fixits_length1;
	gint _d_fixits_size_;
	GcpDiagnosticSeverity d_severity;
	gchar* d_message;
};


static gpointer gcp_diagnostic_parent_class = NULL;
static GcpSourceRangeSupportIface* gcp_diagnostic_gcp_source_range_support_parent_iface = NULL;
static GType gcp_diagnostic_type_id = 0;

GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
GType gcp_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcpDiagnosticFixit* gcp_diagnostic_fixit_dup (const GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_free (GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_copy (const GcpDiagnosticFixit* self, GcpDiagnosticFixit* dest);
void gcp_diagnostic_fixit_destroy (GcpDiagnosticFixit* self);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
#define GCP_DIAGNOSTIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticPrivate))
enum  {
	GCP_DIAGNOSTIC_DUMMY_PROPERTY,
	GCP_DIAGNOSTIC_LOCATION,
	GCP_DIAGNOSTIC_RANGE,
	GCP_DIAGNOSTIC_SEVERITY,
	GCP_DIAGNOSTIC_MESSAGE
};
gchar* gcp_diagnostic_severity_to_string (GcpDiagnosticSeverity self);
static void _vala_GcpDiagnosticFixit_array_free (GcpDiagnosticFixit* array, gint array_length);
GcpDiagnostic* gcp_diagnostic_new (GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
GcpDiagnostic* gcp_diagnostic_construct (GType object_type, GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
static GcpSourceRange** _vala_array_dup2 (GcpSourceRange** self, int length);
static GcpDiagnosticFixit* _vala_array_dup3 (GcpDiagnosticFixit* self, int length);
static gchar* gcp_diagnostic_loc_string (GcpDiagnostic* self);
gchar* gcp_source_range_to_string (GcpSourceRange* self);
gchar* gcp_source_location_to_string (GcpSourceLocation* self);
gchar* gcp_diagnostic_to_string (GcpDiagnostic* self);
gchar* gcp_diagnostic_to_markup (GcpDiagnostic* self, gboolean include_severity);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
static GcpSourceRange** _vala_array_dup4 (GcpSourceRange** self, int length);
GcpDiagnosticFixit* gcp_diagnostic_get_fixits (GcpDiagnostic* self, int* result_length1);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
const gchar* gcp_diagnostic_get_message (GcpDiagnostic* self);
static void gcp_diagnostic_finalize (GObject* obj);
static void _vala_gcp_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* gcp_diagnostic_severity_to_string (GcpDiagnosticSeverity self) {
	gchar* result = NULL;
	switch (self) {
		case GCP_DIAGNOSTIC_SEVERITY_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Info");
			result = _tmp1_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Warning");
			result = _tmp2_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Error");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Unknown");
			result = _tmp4_;
			return result;
		}
	}
}


GType gcp_diagnostic_severity_get_type (void) {
	static volatile gsize gcp_diagnostic_severity_type_id__volatile = 0;
	if (g_once_init_enter (&gcp_diagnostic_severity_type_id__volatile)) {
		static const GEnumValue values[] = {{GCP_DIAGNOSTIC_SEVERITY_NONE, "GCP_DIAGNOSTIC_SEVERITY_NONE", "none"}, {GCP_DIAGNOSTIC_SEVERITY_INFO, "GCP_DIAGNOSTIC_SEVERITY_INFO", "info"}, {GCP_DIAGNOSTIC_SEVERITY_WARNING, "GCP_DIAGNOSTIC_SEVERITY_WARNING", "warning"}, {GCP_DIAGNOSTIC_SEVERITY_ERROR, "GCP_DIAGNOSTIC_SEVERITY_ERROR", "error"}, {GCP_DIAGNOSTIC_SEVERITY_FATAL, "GCP_DIAGNOSTIC_SEVERITY_FATAL", "fatal"}, {GCP_DIAGNOSTIC_SEVERITY_NUM, "GCP_DIAGNOSTIC_SEVERITY_NUM", "num"}, {0, NULL, NULL}};
		GType gcp_diagnostic_severity_type_id;
		gcp_diagnostic_severity_type_id = g_enum_register_static ("GcpDiagnosticSeverity", values);
		g_once_init_leave (&gcp_diagnostic_severity_type_id__volatile, gcp_diagnostic_severity_type_id);
	}
	return gcp_diagnostic_severity_type_id__volatile;
}


static void _vala_GcpDiagnosticFixit_array_free (GcpDiagnosticFixit* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gcp_diagnostic_fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GcpSourceRange** _vala_array_dup2 (GcpSourceRange** self, int length) {
	GcpSourceRange** result;
	int i;
	result = g_new0 (GcpSourceRange*, length + 1);
	for (i = 0; i < length; i++) {
		GcpSourceRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static GcpDiagnosticFixit* _vala_array_dup3 (GcpDiagnosticFixit* self, int length) {
	GcpDiagnosticFixit* result;
	int i;
	result = g_new0 (GcpDiagnosticFixit, length);
	for (i = 0; i < length; i++) {
		GcpDiagnosticFixit _tmp0_ = {0};
		gcp_diagnostic_fixit_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


GcpDiagnostic* gcp_diagnostic_construct (GType object_type, GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
	GcpDiagnostic * self = NULL;
	GcpDiagnosticSeverity _tmp0_;
	GcpSourceLocation* _tmp1_;
	GcpSourceLocation* _tmp2_;
	GcpSourceRange** _tmp3_;
	gint _tmp3__length1;
	GcpSourceRange** _tmp4_;
	gint _tmp4__length1;
	GcpDiagnosticFixit* _tmp5_;
	gint _tmp5__length1;
	GcpDiagnosticFixit* _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (location != NULL, NULL);
	g_return_val_if_fail (message != NULL, NULL);
	self = (GcpDiagnostic*) g_object_new (object_type, NULL);
	_tmp0_ = severity;
	self->priv->d_severity = _tmp0_;
	_tmp1_ = location;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = _tmp2_;
	_tmp3_ = ranges;
	_tmp3__length1 = ranges_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->priv->d_ranges = (_vala_array_free (self->priv->d_ranges, self->priv->d_ranges_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_ranges = _tmp4_;
	self->priv->d_ranges_length1 = _tmp4__length1;
	self->priv->_d_ranges_size_ = self->priv->d_ranges_length1;
	_tmp5_ = fixits;
	_tmp5__length1 = fixits_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->priv->d_fixits = (_vala_GcpDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
	self->priv->d_fixits = _tmp6_;
	self->priv->d_fixits_length1 = _tmp6__length1;
	self->priv->_d_fixits_size_ = self->priv->d_fixits_length1;
	_tmp7_ = message;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->d_message);
	self->priv->d_message = _tmp8_;
	return self;
}


GcpDiagnostic* gcp_diagnostic_new (GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
	return gcp_diagnostic_construct (GCP_TYPE_DIAGNOSTIC, severity, location, ranges, ranges_length1, fixits, fixits_length1, message);
}


static gchar* gcp_diagnostic_loc_string (GcpDiagnostic* self) {
	gchar* result = NULL;
	GcpSourceRange** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_ = NULL;
	gchar** r;
	gint r_length1;
	gint _r_size_;
	GcpSourceLocation* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* loc;
	gchar** _tmp19_;
	gint _tmp19__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_ranges;
	_tmp0__length1 = self->priv->d_ranges_length1;
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
	r = _tmp1_;
	r_length1 = _tmp0__length1;
	_r_size_ = r_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GcpSourceRange** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				GcpSourceRange** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				GcpSourceRange* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->d_ranges;
				_tmp6__length1 = self->priv->d_ranges_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = r;
				_tmp7__length1 = r_length1;
				_tmp8_ = i;
				_tmp9_ = self->priv->d_ranges;
				_tmp9__length1 = self->priv->d_ranges_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = gcp_source_range_to_string (_tmp11_);
				_g_free0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp12_;
				_tmp13_ = _tmp7_[_tmp8_];
			}
		}
	}
	_tmp14_ = self->priv->d_location;
	_tmp15_ = gcp_source_location_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf ("%s", _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	loc = _tmp18_;
	_tmp19_ = r;
	_tmp19__length1 = r_length1;
	if (_tmp19__length1 > 0) {
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp20_ = r;
		_tmp20__length1 = r_length1;
		_tmp21_ = g_strjoinv (", ", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = loc;
		_tmp24_ = g_strdup_printf ("%s at %s", _tmp22_, _tmp23_);
		_g_free0 (loc);
		loc = _tmp24_;
		_g_free0 (_tmp22_);
	}
	result = loc;
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* gcp_diagnostic_to_string (GcpDiagnostic* self) {
	gchar* result = NULL;
	GcpDiagnosticSeverity _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_severity;
	_tmp1_ = gcp_diagnostic_severity_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gcp_diagnostic_loc_string (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->d_message;
	_tmp6_ = g_strdup_printf ("%s %s: %s", _tmp2_, _tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}


gchar* gcp_diagnostic_to_markup (GcpDiagnostic* self, gboolean include_severity) {
	gchar* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = include_severity;
	if (_tmp0_) {
		GcpDiagnosticSeverity _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp1_ = self->priv->d_severity;
		_tmp2_ = gcp_diagnostic_severity_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gcp_diagnostic_loc_string (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->d_message;
		_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("<b>%s</b> %s: %s", _tmp3_, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		result = _tmp10_;
		return result;
	} else {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = gcp_diagnostic_loc_string (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->d_message;
		_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) (-1));
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s: %s", _tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		result = _tmp17_;
		return result;
	}
}


GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self) {
	GcpSourceLocation* result;
	GcpSourceLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	result = _tmp0_;
	return result;
}


static GcpSourceRange* gcp_diagnostic_real_get_range (GcpSourceRangeSupport* base) {
	GcpSourceRange* result;
	GcpDiagnostic* self;
	GcpSourceLocation* _tmp0_;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_;
	self = (GcpDiagnostic*) base;
	_tmp0_ = self->priv->d_location;
	_tmp1_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GcpSourceRange** _vala_array_dup4 (GcpSourceRange** self, int length) {
	GcpSourceRange** result;
	int i;
	result = g_new0 (GcpSourceRange*, length + 1);
	for (i = 0; i < length; i++) {
		GcpSourceRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static GcpSourceRange** gcp_diagnostic_real_get_ranges (GcpSourceRangeSupport* base, int* result_length1) {
	GcpSourceRange** result;
	GcpDiagnostic* self;
	GcpSourceRange** _tmp0_;
	gint _tmp0__length1;
	GcpSourceRange** _tmp20_;
	gint _tmp20__length1;
	GcpSourceRange** _tmp21_;
	gint _tmp21__length1;
	GcpSourceRange** _tmp22_;
	gint _tmp22__length1;
	self = (GcpDiagnostic*) base;
	_tmp0_ = self->priv->d_rangesAndLocation;
	_tmp0__length1 = self->priv->d_rangesAndLocation_length1;
	if (_tmp0_ == NULL) {
		GcpSourceRange** _tmp1_;
		gint _tmp1__length1;
		GcpSourceRange** _tmp2_ = NULL;
		GcpSourceRange** _tmp3_;
		gint _tmp3__length1;
		GcpSourceLocation* _tmp4_;
		GcpSourceRange* _tmp5_;
		GcpSourceRange* _tmp6_;
		GcpSourceRange* _tmp7_;
		_tmp1_ = self->priv->d_ranges;
		_tmp1__length1 = self->priv->d_ranges_length1;
		_tmp2_ = g_new0 (GcpSourceRange*, (_tmp1__length1 + 1) + 1);
		self->priv->d_rangesAndLocation = (_vala_array_free (self->priv->d_rangesAndLocation, self->priv->d_rangesAndLocation_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->d_rangesAndLocation = _tmp2_;
		self->priv->d_rangesAndLocation_length1 = _tmp1__length1 + 1;
		self->priv->_d_rangesAndLocation_size_ = self->priv->d_rangesAndLocation_length1;
		_tmp3_ = self->priv->d_rangesAndLocation;
		_tmp3__length1 = self->priv->d_rangesAndLocation_length1;
		_tmp4_ = self->priv->d_location;
		_tmp5_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp6_;
		_tmp7_ = _tmp3_[0];
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					GcpSourceRange** _tmp12_;
					gint _tmp12__length1;
					GcpSourceRange** _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					GcpSourceRange** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					GcpSourceRange* _tmp17_;
					GcpSourceRange* _tmp18_;
					GcpSourceRange* _tmp19_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = self->priv->d_ranges;
					_tmp12__length1 = self->priv->d_ranges_length1;
					if (!(_tmp11_ < _tmp12__length1)) {
						break;
					}
					_tmp13_ = self->priv->d_rangesAndLocation;
					_tmp13__length1 = self->priv->d_rangesAndLocation_length1;
					_tmp14_ = i;
					_tmp15_ = self->priv->d_ranges;
					_tmp15__length1 = self->priv->d_ranges_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_g_object_unref0 (_tmp13_[_tmp14_ + 1]);
					_tmp13_[_tmp14_ + 1] = _tmp18_;
					_tmp19_ = _tmp13_[_tmp14_ + 1];
				}
			}
		}
	}
	_tmp20_ = self->priv->d_rangesAndLocation;
	_tmp20__length1 = self->priv->d_rangesAndLocation_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _tmp21__length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	return result;
}


GcpDiagnosticFixit* gcp_diagnostic_get_fixits (GcpDiagnostic* self, int* result_length1) {
	GcpDiagnosticFixit* result;
	GcpDiagnosticFixit* _tmp0_;
	gint _tmp0__length1;
	GcpDiagnosticFixit* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_fixits;
	_tmp0__length1 = self->priv->d_fixits_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self) {
	GcpDiagnosticSeverity result;
	GcpDiagnosticSeverity _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->d_severity;
	result = _tmp0_;
	return result;
}


const gchar* gcp_diagnostic_get_message (GcpDiagnostic* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_message;
	result = _tmp0_;
	return result;
}


void gcp_diagnostic_fixit_copy (const GcpDiagnosticFixit* self, GcpDiagnosticFixit* dest) {
	GcpSourceRange* _tmp0_;
	GcpSourceRange* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = (*self).range;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).range);
	(*dest).range = _tmp1_;
	_tmp2_ = (*self).replacement;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).replacement);
	(*dest).replacement = _tmp3_;
}


void gcp_diagnostic_fixit_destroy (GcpDiagnosticFixit* self) {
	_g_object_unref0 ((*self).range);
	_g_free0 ((*self).replacement);
}


GcpDiagnosticFixit* gcp_diagnostic_fixit_dup (const GcpDiagnosticFixit* self) {
	GcpDiagnosticFixit* dup;
	dup = g_new0 (GcpDiagnosticFixit, 1);
	gcp_diagnostic_fixit_copy (self, dup);
	return dup;
}


void gcp_diagnostic_fixit_free (GcpDiagnosticFixit* self) {
	gcp_diagnostic_fixit_destroy (self);
	g_free (self);
}


GType gcp_diagnostic_fixit_get_type (void) {
	static volatile gsize gcp_diagnostic_fixit_type_id__volatile = 0;
	if (g_once_init_enter (&gcp_diagnostic_fixit_type_id__volatile)) {
		GType gcp_diagnostic_fixit_type_id;
		gcp_diagnostic_fixit_type_id = g_boxed_type_register_static ("GcpDiagnosticFixit", (GBoxedCopyFunc) gcp_diagnostic_fixit_dup, (GBoxedFreeFunc) gcp_diagnostic_fixit_free);
		g_once_init_leave (&gcp_diagnostic_fixit_type_id__volatile, gcp_diagnostic_fixit_type_id);
	}
	return gcp_diagnostic_fixit_type_id__volatile;
}


static void gcp_diagnostic_class_init (GcpDiagnosticClass * klass) {
	gcp_diagnostic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpDiagnosticPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_diagnostic_get_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_diagnostic_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DIAGNOSTIC_LOCATION, g_param_spec_object ("location", "location", "location", GCP_TYPE_SOURCE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_DIAGNOSTIC_RANGE, "range");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DIAGNOSTIC_SEVERITY, g_param_spec_enum ("severity", "severity", "severity", GCP_DIAGNOSTIC_TYPE_SEVERITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_DIAGNOSTIC_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_diagnostic_gcp_source_range_support_interface_init (GcpSourceRangeSupportIface * iface) {
	gcp_diagnostic_gcp_source_range_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_range = gcp_diagnostic_real_get_range;
	iface->get_ranges = gcp_diagnostic_real_get_ranges;
}


static void gcp_diagnostic_instance_init (GcpDiagnostic * self) {
	self->priv = GCP_DIAGNOSTIC_GET_PRIVATE (self);
}


static void gcp_diagnostic_finalize (GObject* obj) {
	GcpDiagnostic * self;
	self = GCP_DIAGNOSTIC (obj);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_ranges = (_vala_array_free (self->priv->d_ranges, self->priv->d_ranges_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_rangesAndLocation = (_vala_array_free (self->priv->d_rangesAndLocation, self->priv->d_rangesAndLocation_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_fixits = (_vala_GcpDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
	_g_free0 (self->priv->d_message);
	G_OBJECT_CLASS (gcp_diagnostic_parent_class)->finalize (obj);
}


GType gcp_diagnostic_get_type (void) {
	return gcp_diagnostic_type_id;
}


GType gcp_diagnostic_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpDiagnosticClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_diagnostic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDiagnostic), 0, (GInstanceInitFunc) gcp_diagnostic_instance_init, NULL };
	static const GInterfaceInfo gcp_source_range_support_info = { (GInterfaceInitFunc) gcp_diagnostic_gcp_source_range_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gcp_diagnostic_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpDiagnostic", &g_define_type_info, 0);
	g_type_module_add_interface (module, gcp_diagnostic_type_id, GCP_TYPE_SOURCE_RANGE_SUPPORT, &gcp_source_range_support_info);
	return gcp_diagnostic_type_id;
}


static void _vala_gcp_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpDiagnostic * self;
	self = GCP_DIAGNOSTIC (object);
	switch (property_id) {
		case GCP_DIAGNOSTIC_LOCATION:
		g_value_set_object (value, gcp_diagnostic_get_location (self));
		break;
		case GCP_DIAGNOSTIC_RANGE:
		g_value_take_object (value, gcp_source_range_support_get_range ((GcpSourceRangeSupport*) self));
		break;
		case GCP_DIAGNOSTIC_SEVERITY:
		g_value_set_enum (value, gcp_diagnostic_get_severity (self));
		break;
		case GCP_DIAGNOSTIC_MESSAGE:
		g_value_set_string (value, gcp_diagnostic_get_message (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



