// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DRAGCONTEXT_H
#define _GDKMM_DRAGCONTEXT_H

#include <glibmm.h>

/* $Id: dragcontext.hg,v 1.14 2002/12/29 00:43:08 murrayc Exp $ */

/* dragcontext.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/color.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/bitmap.h>
#include <glibmm/object.h>
#include <gdk/gdkdnd.h>
#include <glibmm/listhandle.h>
#include <gtkmm/stockid.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDragContext GdkDragContext;
typedef struct _GdkDragContextClass GdkDragContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class DragContext_Class; } // namespace Gdk
namespace Gtk
{
  class Widget;
} /* namespace Gtk */

//typedef struct _GdkAtom            *GdkAtom;

namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%DragAction operator|(DragAction, DragAction)</tt><br>
 * <tt>%DragAction operator&(DragAction, DragAction)</tt><br>
 * <tt>%DragAction operator^(DragAction, DragAction)</tt><br>
 * <tt>%DragAction operator~(DragAction)</tt><br>
 * <tt>%DragAction& operator|=(DragAction&, DragAction)</tt><br>
 * <tt>%DragAction& operator&=(DragAction&, DragAction)</tt><br>
 * <tt>%DragAction& operator^=(DragAction&, DragAction)</tt><br>
 */
enum DragAction
{
  ACTION_DEFAULT = 1 << 0,
  ACTION_COPY = 1 << 1,
  ACTION_MOVE = 1 << 2,
  ACTION_LINK = 1 << 3,
  ACTION_PRIVATE = 1 << 4,
  ACTION_ASK = 1 << 5
};

/** @ingroup gdkmmEnums */
inline DragAction operator|(DragAction lhs, DragAction rhs)
  { return static_cast<DragAction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline DragAction operator&(DragAction lhs, DragAction rhs)
  { return static_cast<DragAction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline DragAction operator^(DragAction lhs, DragAction rhs)
  { return static_cast<DragAction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline DragAction operator~(DragAction flags)
  { return static_cast<DragAction>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline DragAction& operator|=(DragAction& lhs, DragAction rhs)
  { return (lhs = static_cast<DragAction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline DragAction& operator&=(DragAction& lhs, DragAction rhs)
  { return (lhs = static_cast<DragAction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline DragAction& operator^=(DragAction& lhs, DragAction rhs)
  { return (lhs = static_cast<DragAction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::DragAction> : public Glib::Value_Flags<Gdk::DragAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum DragProtocol
{
  DRAG_PROTO_MOTIF,
  DRAG_PROTO_XDND,
  DRAG_PROTO_NONE,
  DRAG_PROTO_WIN32_DROPFILES,
  DRAG_PROTO_OLE2,
  DRAG_PROTO_LOCAL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::DragProtocol> : public Glib::Value_Enum<Gdk::DragProtocol>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class DragContext : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DragContext CppObjectType;
  typedef DragContext_Class CppClassType;
  typedef GdkDragContext BaseObjectType;
  typedef GdkDragContextClass BaseClassType;

private:
  friend class DragContext_Class;
  static CppClassType dragcontext_class_;

  // noncopyable
  DragContext(const DragContext&);
  DragContext& operator=(const DragContext&);

protected:
  explicit DragContext(const Glib::ConstructParams& construct_params);
  explicit DragContext(GdkDragContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DragContext();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDragContext*       gobj()       { return reinterpret_cast<GdkDragContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDragContext* gobj() const { return reinterpret_cast<GdkDragContext*>(gobject_); }

  GdkDragContext* gobj_copy();

private:

  
protected:
  DragContext();

public:
  
  static Glib::RefPtr<DragContext> create();


  /** Selects one of the actions offered by the drag source.
   * 
   * This function is called by the drag destination in response to
   * gdk_drag_motion() called by the drag source.
   * @param context A Gdk::DragContext.
   * @param action The selected action which will be taken when a drop happens, 
   * or 0 to indicate that a drop will not be accepted.
   * @param time_ The timestamp for this operation.
   */
  void drag_status(DragAction action, guint32 time);
  
  /** Accepts or rejects a drop. 
   * 
   * This function is called by the drag destination in response
   * to a drop initiated by the drag source.
   * @param context A Gdk::DragContext.
   * @param ok <tt>true</tt> if the drop is accepted.
   * @param time_ The timestamp for this operation.
   */
  void drop_reply(bool ok, guint32 time);
  
  /** Ends the drag operation after a drop.
   * 
   * This function is called by the drag destination.
   * @param context A Gtk::DragContext.
   * @param success <tt>true</tt> if the data was successfully received.
   * @param time_ The timestamp for this operation.
   */
  void drop_finish(bool success, guint32 time);
  
  /** Returns the selection atom for the current source window.
   * @param context A Gdk::DragContext.
   * @return The selection atom.
   */
  GdkAtom get_selection();

  
  void drag_finish(bool success, bool del, guint32 time);
  //Gtk::Widget* get_source_widget() - see Gtk::Widget::drag_get_source_widget()

  // void set_icon(Gtk::Widget* widget, int hot_x, int hot_y) - see Gtk::Widget::set_as_icon().
  
  void set_icon(const Glib::RefPtr<Gdk::Colormap>& colormap, const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask, int hot_x, int hot_y);
  
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, int hot_x, int hot_y);

  // First argument was changed from StockID to ustring to avoid 
  // cross-dependence between gdkmm and gtkmm.
  // See http://bugzilla.gnome.org/show_bug.cgi?id=79124 for details
  
  void set_icon(const Glib::ustring& stock_id, int hot_x, int hot_y);
  
  void set_icon();

  DragProtocol get_protocol() const;
  bool get_is_source() const;
  DragAction get_actions() const;
  DragAction get_suggested_action() const;
  DragAction get_action() const;
  guint32 get_start_time() const;

  void find_window_for_screen(const Glib::RefPtr<Window>& drag_window, const Glib::RefPtr<Screen>& screen, int x_root, int y_root, Glib::RefPtr<Window>& dest_window, GdkDragProtocol* protocol);
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::DragContext */
  Glib::RefPtr<Gdk::DragContext> wrap(GdkDragContext* object, bool take_copy = false);
}


#endif /* _GDKMM_DRAGCONTEXT_H */

