
#include <libgnomecanvasmm/rich-text.h>
#include <libgnomecanvasmm/private/rich-text_p.h>

/* $Id: rich-text.ccg,v 1.2 2002/02/24 20:41:19 murrayc Exp $ */

/* rich-text.cc
 *
 * Copyright (C) 2002 The libgnomecanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gnome
{

namespace Canvas
{

RichText::RichText (Group& parent,
                    double x, double y, 
                    const Glib::ustring& text)
  : Item (GNOME_CANVAS_ITEM (g_object_new (get_type (), NULL)))
{
  item_construct (parent);
  set ("x", x, 
       "y", y, 
       "text", text.c_str (), 
       NULL);
}

RichText::RichText (Group& parent)
  : Item (GNOME_CANVAS_ITEM (g_object_new (get_type (), NULL)))
{
  item_construct (parent);
}

}

}


namespace
{


void RichText_signal_tag_changed_callback(GnomeCanvasRichText*, GtkTextTag* tag,void* data)
{
  using namespace Gnome::Canvas;
  typedef SigC::Slot1<void,const Glib::RefPtr<Gtk::TextTag>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(tag, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo RichText_signal_tag_changed_info =
{
  "tag_changed",
  (GCallback) &RichText_signal_tag_changed_callback,
  (GCallback) &RichText_signal_tag_changed_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::Canvas::RichText* wrap(GnomeCanvasRichText* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::RichText *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType RichText_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_rich_text_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void RichText_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->tag_changed = &tag_changed_callback;
}


void RichText_Class::tag_changed_callback(GnomeCanvasRichText* self, GtkTextTag* tag)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_tag_changed(Glib::wrap(tag, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->tag_changed)
      (*base->tag_changed)(self, tag);
  }
}


Glib::ObjectBase* RichText_Class::wrap_new(GObject* o)
{
  return manage(new RichText((GnomeCanvasRichText*)(o)));
}


/* The implementation: */

RichText::RichText(GnomeCanvasRichText* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

RichText::~RichText()
{
  destroy_();
}

RichText::CppClassType RichText::richtext_class_; //Initialize static member.

GType RichText::get_type()
{
  return richtext_class_.get_type();
}

GType RichText::get_base_type()
{
  return gnome_canvas_rich_text_get_type();
}

void RichText::cut_clipboard()
{
  gnome_canvas_rich_text_cut_clipboard(gobj());
}

void RichText::copy_clipboard()
{
  gnome_canvas_rich_text_copy_clipboard(gobj());
}

void RichText::paste_clipboard()
{
  gnome_canvas_rich_text_paste_clipboard(gobj());
}

void RichText::set_buffer(const Glib::RefPtr<Gtk::TextBuffer>& buffer)
{
  gnome_canvas_rich_text_set_buffer(gobj(), Glib::unwrap(buffer));
}

Glib::RefPtr<Gtk::TextBuffer> RichText::get_buffer() const
{
  return Glib::wrap(gnome_canvas_rich_text_get_buffer(const_cast<GnomeCanvasRichText*>(gobj())));
}

void RichText::get_iter_location(const Gtk::TextIter& iter, Gdk::Rectangle& location)
{
  gnome_canvas_rich_text_get_iter_location(gobj(), (iter).gobj(), (location).gobj());
}

void RichText::get_iter_at_location(Gtk::TextIter& iter, int x, int y)
{
  gnome_canvas_rich_text_get_iter_at_location(gobj(), (iter).gobj(), x, y);
}


Glib::SignalProxy1<void,const Glib::RefPtr<Gtk::TextTag>&> RichText::signal_tag_changed()
{
  return Glib::SignalProxy1<void,const Glib::RefPtr<Gtk::TextTag>&>(this, &RichText_signal_tag_changed_info);
}


Glib::PropertyProxy<Glib::ustring> RichText::property_text()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}

Glib::PropertyProxy<double> RichText::property_x()
{
  return Glib::PropertyProxy<double>(this, "x");
}

Glib::PropertyProxy<double> RichText::property_y()
{
  return Glib::PropertyProxy<double>(this, "y");
}

Glib::PropertyProxy<double> RichText::property_width()
{
  return Glib::PropertyProxy<double>(this, "width");
}

Glib::PropertyProxy<double> RichText::property_height()
{
  return Glib::PropertyProxy<double>(this, "height");
}

Glib::PropertyProxy<bool> RichText::property_editable()
{
  return Glib::PropertyProxy<bool>(this, "editable");
}

Glib::PropertyProxy<bool> RichText::property_visible()
{
  return Glib::PropertyProxy<bool>(this, "visible");
}

Glib::PropertyProxy<bool> RichText::property_cursor_visible()
{
  return Glib::PropertyProxy<bool>(this, "cursor_visible");
}

Glib::PropertyProxy<bool> RichText::property_cursor_blink()
{
  return Glib::PropertyProxy<bool>(this, "cursor_blink");
}

Glib::PropertyProxy<bool> RichText::property_grow_height()
{
  return Glib::PropertyProxy<bool>(this, "grow_height");
}

Glib::PropertyProxy<Gtk::WrapMode> RichText::property_wrap_mode()
{
  return Glib::PropertyProxy<Gtk::WrapMode>(this, "wrap_mode");
}

Glib::PropertyProxy<Gtk::Justification> RichText::property_justification()
{
  return Glib::PropertyProxy<Gtk::Justification>(this, "justification");
}

Glib::PropertyProxy<Gtk::DirectionType> RichText::property_direction()
{
  return Glib::PropertyProxy<Gtk::DirectionType>(this, "direction");
}

Glib::PropertyProxy<Gtk::AnchorType> RichText::property_anchor()
{
  return Glib::PropertyProxy<Gtk::AnchorType>(this, "anchor");
}

Glib::PropertyProxy<int> RichText::property_pixels_above_lines()
{
  return Glib::PropertyProxy<int>(this, "pixels_above_lines");
}

Glib::PropertyProxy<int> RichText::property_pixels_below_lines()
{
  return Glib::PropertyProxy<int>(this, "pixels_below_lines");
}

Glib::PropertyProxy<int> RichText::property_pixels_inside_wrap()
{
  return Glib::PropertyProxy<int>(this, "pixels_inside_wrap");
}

Glib::PropertyProxy<int> RichText::property_left_margin()
{
  return Glib::PropertyProxy<int>(this, "left_margin");
}

Glib::PropertyProxy<int> RichText::property_right_margin()
{
  return Glib::PropertyProxy<int>(this, "right_margin");
}

Glib::PropertyProxy<int> RichText::property_indent()
{
  return Glib::PropertyProxy<int>(this, "indent");
}


void Gnome::Canvas::RichText::on_tag_changed(const Glib::RefPtr<Gtk::TextTag>& tag)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->tag_changed)
    (*base->tag_changed)(gobj(),Glib::unwrap(tag));
}


} // namespace Canvas

} // namespace Gnome

