/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * A GtkPlug window is a top-level window that can be made available to a
 * separate process from the one that created it. The separate process uses a
 * GtkSocket to access the widget just as if it were local.
 */
public class Plug extends Window {

    public Plug(Handle handle) {
        super(handle);
    }

    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    public static Plug getPlug(Handle handle) {
        if (handle == null)
            return null;

        Plug obj = (Plug) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new Plug(handle);

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_plug_get_type());
    }

    native static final protected int gtk_plug_get_type();

    native static final protected Handle gtk_plug_new(int socketId);

    native static final protected void gtk_plug_construct(Handle plug,
            int socketId);

    native static final protected int gtk_plug_get_id(Handle plug);

}
