/* object-selector-priv.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __OBJECT_SELECTOR_PRIV__
#define __OBJECT_SELECTOR_PRIV_

#include <config.h>

G_BEGIN_DECLS

/* structure for private data */
struct _ObjectSelectorPriv {
	ConfManager          *conf;
	ObjectDescriptorMode  mode;
	GtkTreeView          *treeview;
	GObject              *selection;

	GSList               *objects_infos;  /* list of ObjectInfo structures */
	GSList               *managers_infos; /* list of ManagerInfo structures */

	GSList               *weak_ref_objects;
	GSList               *inner_logic; /* list of InnerObjectLogic structs */
};


typedef gchar     *(*GetInfoFunc) (GObject *obj);
typedef GdkPixbuf *(*GetIconFunc) (GObject *obj);
typedef GSList    *(*GetColsFunc) (GObject *obj, guint nbcols);
#define GET_INFO_FUNC(x) ((GetInfoFunc) x)
#define GET_ICON_FUNC(x) ((GetIconFunc) x)
#define GET_COLS_FUNC(x) ((GetColsFunc) x)


/* 
 * holds information on how to create the columns of a particular object 
 */
typedef struct _ObjectInfo {
	GType          type;
	GetIconFunc    get_icon;
	GetInfoFunc    get_name;
	GetInfoFunc    get_cmp_name;
	GetColsFunc    get_cols;
} ObjectInfo;
#define OBJECT_INFO(x) ((ObjectInfo *) x)

/*
 * holds the information for a "manager" object: an object which can create
 * sub objects
 */
typedef struct _ManagerInfo {
	GObject          *manager;
	const ObjectInfo *manager_info;  /* the pointed struct is managed in 'objects_infos' */
	GSList           *children_info; /* the pointed struct are managed in 'objects_infos' */
	GSList           *signals;       /* list of ManagerSignal structs */
} ManagerInfo;
#define MANAGER_INFO(x) ((ManagerInfo *) x)

/* structure to hold the reference of a signal handler */
typedef struct _ManagerSignal {
	gulong                sigid;
	const gchar          *signal_name; /* string managed by InnerObjectLogic */
	GType                 managed_object_type;
} ManagerSignal;
#define MANAGER_SIGNAL(x) ((ManagerSignal *) x)


/* structure to hold a representation of what to do when a new object
   has been created and inserted into the tree. For example if the selected
   mode contains OBJECT_SELECTOR_DBFIELDS and a new table has been created,
   we need to connect the "field_created" signal to fetch DbField objects creation */
typedef struct _InnerObjectLogic 
{
	ObjectDescriptorMode ifmode;
	const ObjectInfo    *manager_info;
	gchar               *child_creation_signal_name;
	gchar               *child_destroy_signal_name;
	const ObjectInfo    *child_info;
} InnerObjectLogic;
#define INNER_OBJECT_LOGIC(x) ((InnerObjectLogic*) x)


void object_selector_add_manager_class (ObjectSelector * os,
					ObjectDescriptorMode ifmode,
					const ObjectInfo *manager_info,
					const gchar *child_creation_signal_name,
					const gchar *child_destroy_signal_name,
					const ObjectInfo *child_info);


void object_selector_add_object (ObjectSelector * os, 
				 GtkTreeIter *parent_iter, 
				 GObject *parent,    /* can be NULL */
				 GObject *obj,       /* NOT NULL */
				 ObjectInfo *oinfo,  /* can be NULL */
				 GtkTreeIter *obj_iter, gboolean sort);

void object_selector_add_manager (ObjectSelector * os, GObject *manager, const ObjectInfo *manager_info);



/* 
 * finds an object which can store children_type objects as sub category in the tree 
 */
GtkTreePath *object_selector_find_model_path (GtkTreeModel *model, GObject *obj, GType children_type);
ObjectInfo  *object_selector_find_object_info (ObjectSelector *os, const ObjectInfo *info);

G_END_DECLS

#endif



