/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.datastructures.MultipleQueuesStructure;
import com.sun.electric.tool.util.concurrent.datastructures.WorkStealingStructure;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.utils.ConcurrentCollectionFactory;

public class Scheduler {
    public static IStructure<PTask> createScheduler(SchedulingStrategy strategy, int numOfThreads) throws UnknownSchedulerException {
        IStructure result = null;
        if (strategy.equals((Object)SchedulingStrategy.queue)) {
            result = ConcurrentCollectionFactory.createLockFreeQueue();
        } else if (strategy.equals((Object)SchedulingStrategy.stack)) {
            result = ConcurrentCollectionFactory.createLockFreeStack();
        } else if (strategy.equals((Object)SchedulingStrategy.workStealing)) {
            result = WorkStealingStructure.createForThreadPool(numOfThreads);
        } else if (strategy.equals((Object)SchedulingStrategy.multipleQueues)) {
            result = new MultipleQueuesStructure(numOfThreads);
        } else if (strategy.equals((Object)SchedulingStrategy.fcQueue)) {
            result = ConcurrentCollectionFactory.createFCQueue();
        } else {
            throw new UnknownSchedulerException();
        }
        return result;
    }

    public static String getAvailableScheduler() {
        StringBuilder builder = new StringBuilder();
        for (SchedulingStrategy strategy : SchedulingStrategy.values()) {
            builder.append(strategy.toString());
            builder.append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public static enum SchedulingStrategy {
        queue,
        stack,
        workStealing,
        multipleQueues,
        fcQueue;

    }

    public static class UnknownSchedulerException
    extends Exception {
    }
}

