/***************************************************************************
                          funcdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <dlfcn.h>
#include <qfileinfo.h>
#include <qlistbox.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qdir.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kcolorbtn.h>
#include <kmessagebox.h>
#include <kio/netaccess.h>
#include "funcdlg.h"
#include "kpldoc.h"
#include "symboldlg.h"
#include "utils.h"
#include "funitem.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"

FuncDlg::FuncDlg(QWidget* _parent, KplDoc* model, FunItem* fd0) :
 KDialogBase(Plain, i18n("Function"),
             Help | Ok | Apply | Cancel | User1, Ok, _parent, 0,
             true, false, i18n("&Export")),
 m(model), fd(fd0)
{
  fdt = new FunItem(*fd);
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "y(x)", frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(fd->pathy.isLocalFile() ?
                                           fd->pathy.path() :
                                           fd->pathy.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Range"), frame));
  grid = new QGridLayout(g->layout(), 3, 5, spacingHint());
  grid->addWidget(new QLabel("xmin", g), 0, 0);
  grid->addWidget(exMin = new KplDoubleEdit(fd->tmin, g), 0, 1);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid->addWidget(new QLabel("xmax", g), 0, 3);
  grid->addWidget(exMax = new KplDoubleEdit(fd->tmax, g), 0, 4);
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 8)
  l->setFont(QFont("Symbol", 12, QFont::Normal, false));
#else
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
#endif
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("x", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  grid->addWidget(exStep = new KplDoubleEdit(fd->dt, g), 1, 1);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, g), 2, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 2, 3);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, g), 2, 4);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Representation"), frame));
  grid = new QGridLayout(g->layout(), 2, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(fd->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  bSymb->setFixedWidth(50);
  grid->addWidget(bSymb, 0, 2);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * fd->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), g), 1, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 1, 5);
  colData->setMinimumWidth(50);
#if KDE_VERSION == 303
  connect(this, SIGNAL(helpClicked()), SLOT(slotHelp2()));
#else
  setHelp("SEC-FUNC");
#endif
  Utils::setSize(this, "FuncDialog");
}

FuncDlg::~FuncDlg()
{
  Utils::saveSize(this, "FuncDialog");
  delete fdt;
}

void FuncDlg::getFunc(QWidget* parent, QLineEdit* name, QLineEdit* func)
{
  QFileInfo fi(name->text());
  QString path = fi.dirPath(true) + "/" + fi.baseName() + ".def";
  QFile f(path);
  if (f.open(IO_ReadOnly)) {
    ChooseFuncDlg dlg(parent, &f, func);
    dlg.exec();
  } else
    KMessageBox::error(parent,
                       i18n("while trying to open module definition file"));
}

bool FuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = exMin->value();
  fdt->tmax = exMax->value();
  fdt->dt = exStep->value();
  fdt->pathy = fileName->text();
  fdt->namey = func->text();
  if (fdt->hmody)
    dlclose(fdt->hmody);
  if (FunItem::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                           &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  fdt->relsiz = 0.01 * eRelSize->interpretedValue();
  return true;
}

void FuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
    else
      *fdt = *fd;
  }
}

void FuncDlg::slotFile()
{
  Utils::getFile(fileName, m);
}

void FuncDlg::slotFunc()
{
  getFunc(this, fileName, func);
}

void FuncDlg::slotGetParameter()
{
  Utils::getPar(this, fdt->py, m);
}

void FuncDlg::slotEditParameter()
{
  EditParameterDlg dlg(this, m, fdt->py, fileName->text(), func->text(), true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void FuncDlg::slotSaveParameter()
{
  Utils::saveFunPar(this, fdt->py, m);
}

void FuncDlg::slotUser1()
{
  if (getTemp()) {
    KURL url;
    if (Utils::getWriteURL(this, url, "*.dat\n*", m)) {
      QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile())
          m->copyTmp(url);
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void FuncDlg::slotOk()
{
  getValues(true);
}

void FuncDlg::slotApply()
{
  getValues(false);
}

void FuncDlg::slotHelp2()
{
#if KDE_VERSION == 303
  kapp->startServiceByDesktopName("konqueror", QString("help:/kpl/func.html"),
                                  0, 0, 0, "", true);
#endif
}

ParFuncDlg::ParFuncDlg(QWidget* _parent, KplDoc* model, ParFunItem* fd0) :
 KDialogBase(Plain, i18n("Parametric function"),
             Help | Ok | Apply | Cancel | User1, Ok, _parent, 0,
             true, false, i18n("&Export")),
 m(model), fd(fd0)
{
  fdt = new ParFunItem(*fd);
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "x(t)", frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileNamex = new QLineEdit(fd->pathx.isLocalFile() ?
                                            fd->pathx.path() :
                                            fd->pathx.url(), g));
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFilex()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcx = new QLineEdit(fd->namex, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncx()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameterx()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameterx()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, "y(t)", frame));
  grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 0, 1);
  hbox->addWidget(fileNamey = new QLineEdit(fd->pathy.isLocalFile() ?
                                            fd->pathy.path() :
                                            fd->pathy.url(), g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFiley()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(funcy = new QLineEdit(fd->namey, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFuncy()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParametery()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParametery()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Range"), frame));
  grid = new QGridLayout(g->layout(), 3, 5, spacingHint());
  grid->addWidget(new QLabel("tmin", g), 0, 0);
  grid->addWidget(etMin = new KplDoubleEdit(fd->tmin, g), 0, 1);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 2);
  grid->addWidget(new QLabel("tmax", g), 0, 3);
  grid->addWidget(etMax = new KplDoubleEdit(fd->tmax, g), 0, 4);
  grid->addLayout(hbox = new QHBoxLayout(1), 1, 0);
  QLabel* l = new QLabel("D", g);
#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 8)
  l->setFont(QFont("Symbol", 12, QFont::Normal, false));
#else
  l->setFont(QFont("Symbol", 12, QFont::Normal, false, QFont::AnyCharSet));
#endif
  hbox->addWidget(l);
  hbox->addWidget(new QLabel("t", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  grid->addWidget(etStep = new KplDoubleEdit(fd->dt, g), 1, 1);
  grid->addWidget(new QLabel(i18n("x normalization"), g), 2, 0);
  grid->addWidget(efx = new KplDoubleEdit(fd->fx, g), 2, 1);
  grid->addWidget(new QLabel(i18n("y normalization"), g), 2, 3);
  grid->addWidget(efy = new KplDoubleEdit(fd->fy, g), 2, 4);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Representation"),
                                    frame));
  grid = new QGridLayout(g->layout(), 2, 6, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(fd->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  bSymb->setFixedWidth(50);
  grid->addWidget(bSymb, 0, 2);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * fd->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), g), 1, 4);
  grid->addWidget(colData = new KColorButton(fd->color, g), 1, 5);
  colData->setMinimumWidth(50);
#if KDE_VERSION == 303
  connect(this, SIGNAL(helpClicked()), SLOT(slotHelp2()));
#else
  setHelp("SEC-PARFUNC");
#endif
  Utils::setSize(this, "ParFuncDialog");
}

ParFuncDlg::~ParFuncDlg()
{
  Utils::saveSize(this, "ParFuncDialog");
  delete fdt;
}

bool ParFuncDlg::getTemp()
{
  fdt->fx = efx->value();
  fdt->fy = efy->value();
  fdt->tmin = etMin->value();
  fdt->tmax = etMax->value();
  fdt->dt = etStep->value();
  fdt->pathx = fileNamex->text();
  fdt->namex = funcx->text();
  if (fdt->hmodx)
    dlclose(fdt->hmodx);
  if (FunItem::getFuncAddr(fdt->pathx.path(), fdt->namex, &fdt->hmodx,
                           &fdt->fktx))
    return false;
  fdt->pathy = fileNamey->text();
  fdt->namey = funcy->text();
  if (fdt->hmody)
    dlclose(fdt->hmody);
  if (FunItem::getFuncAddr(fdt->pathy.path(), fdt->namey, &fdt->hmody,
                           &fdt->fkty))
    return false;
  fdt->color = colData->color().rgb();
  fdt->symb = symb->interpretedValue();
  fdt->relsiz = 0.01 * eRelSize->interpretedValue();
  return true;
}

void ParFuncDlg::getValues(bool ok)
{
  if (getTemp()) {
    *fd = *fdt;
    m->setModified();
    m->backupItems();
    if (ok)
      accept();
  }
}

void ParFuncDlg::slotFilex()
{
  Utils::getFile(fileNamex, m);
}

void ParFuncDlg::slotFiley()
{
  Utils::getFile(fileNamey, m);
}

void ParFuncDlg::slotFuncx()
{
  FuncDlg::getFunc(this, fileNamex, funcx);
}

void ParFuncDlg::slotFuncy()
{
  FuncDlg::getFunc(this, fileNamey, funcy);
}

void ParFuncDlg::slotGetParameterx()
{
  Utils::getPar(this, fdt->px, m);
}

void ParFuncDlg::slotGetParametery()
{
  Utils::getPar(this, fdt->py, m);
}

void ParFuncDlg::slotEditParameterx()
{
  EditParameterDlg dlg(this, m, fdt->px, fileNamex->text(), funcx->text(),
                       true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void ParFuncDlg::slotEditParametery()
{
  EditParameterDlg dlg(this, m, fdt->py, fileNamey->text(), funcy->text(),
                       true);
  connect(&dlg, SIGNAL(applyClicked()), SLOT(slotApply()));
  dlg.exec();
}

void ParFuncDlg::slotSaveParameterx()
{
  Utils::saveFunPar(this, fdt->px, m);
}

void ParFuncDlg::slotSaveParametery()
{
  Utils::saveFunPar(this, fdt->py, m);
}

void ParFuncDlg::slotUser1()
{
  if (getTemp()) {
    KURL url;
    if (Utils::getWriteURL(this, url, "*.dat\n*", m)) {
      QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
      if (f.open(IO_WriteOnly)) {
        QTextStream ts(&f);
        fdt->exportTable(ts, m);
        f.close();
        m->setCurrentDir(url);
        if (!url.isLocalFile())
          m->copyTmp(url);
      } else
        KMessageBox::error(this, i18n("while trying to open"));
    }
  }
}

void ParFuncDlg::slotOk()
{
  getValues(true);
}

void ParFuncDlg::slotApply()
{
  getValues(false);
}

void ParFuncDlg::slotHelp2()
{
#if KDE_VERSION == 303
  kapp->startServiceByDesktopName("konqueror",
                                  QString("help:/kpl/parfunc.html"),
                                  0, 0, 0, "", true);
#endif
}
