/***************************************************************************
                          kpldoubleedit.cpp  -  description
                             -------------------
    begin                : Tue Aug 15 2000
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpldoubleedit.h"
#include <qvalidator.h>

KplDoubleEdit::KplDoubleEdit(double val, QWidget* _parent,
                             const char* format) :
 QLineEdit(_parent), frm(format)
{
  validator = new QDoubleValidator::QDoubleValidator(this);
  validator->setDecimals(16);
  setValidator(validator);
  setValue(val);
}

KplDoubleEdit::KplDoubleEdit(double val, double minVal, double maxVal,
                             QWidget* _parent, const char* format) :
 QLineEdit(_parent), frm(format)
{
  validator = new QDoubleValidator::QDoubleValidator(minVal, maxVal, 16, this);
  setValidator(validator);
  setValue(val);
}

KplDoubleEdit::~KplDoubleEdit()
{
  delete validator;
}

double KplDoubleEdit::setValue(double val)
{
  QString s;
  setText(s.sprintf(frm, val));
  return value();
}

double KplDoubleEdit::value()
{
  QString s = text();
  double val = s.toDouble();
  if (validator->bottom() || validator->top())
    val = QMAX(QMIN(val, validator->top()), validator->bottom());
  setText(s.sprintf(frm, val));
  return val;
}

void KplDoubleEdit::setBottom(double bottom)
{
  validator->setBottom(bottom);
}

void KplDoubleEdit::focusOutEvent(QFocusEvent* e)
{
  value();
  QLineEdit::focusOutEvent(e);
}
