/***************************************************************************
                          lineitem.h  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LINEITEM_H
#define LINEITEM_H

#include <arrowitem.h>

/**
  * Line item class. Class for line decoration items.
  * @author Werner Stille
  */
class LineItem : public ArrowItem
{
public: 
  /** Constructor */
  LineItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  LineItem(Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param aut pointer to structure containing autoplot settings.
    */
  LineItem(KSimpleConfig* plo, Kpl::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param symb line type.
    * @param color color for arrow.
    * @param x x start position in cm.
    * @param y y start position in cm.
    * @param dir direction in degree.
    * @param len total length in cm.
    * @param relSize relative size of text.
    */
  LineItem(bool active, int symb, const QString& color,
           double x, double y, double dir, double len, double relSize);
  /** Destructor */
  ~LineItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(KplCheckListItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
  virtual KplItem* copy() const;

protected:
  int symb;

  friend class LineDlg;
};

#endif
