/***************************************************************************
                          rootdlg.cpp  -  description
                             -------------------
    begin                : Sam Jan 25 2003
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "fitpack.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "rootdlg.h"
#include "splineitem.h"
#include "utils.h"

RootDlg::RootDlg(QWidget* _parent, KplDoc* model, SplineItem* spl0) :
 KDialogBase(Plain, i18n("Roots"), Help | Close | User1,  Close, _parent, 0,
             true, true, i18n("&Export")), m(model), spl(spl0)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QHBoxLayout* hbox = new QHBoxLayout(vbox, spacingHint());
  hbox->addWidget(new QLabel(i18n("Condition"), frame));
  hbox->addWidget(eCond = new QComboBox(false, frame));
  QStringList list;
  list << "y(x) - c = 0" << "y'(x) - c = 0" << "y\"(x) - c = 0"
       << i18n("Minimum") << i18n("Maximum");
  eCond->insertStringList(list);
  connect(eCond, SIGNAL(activated(int)), SLOT(findRoots()));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(new QLabel("c", frame));
  hbox->addWidget(eOff = new KplDoubleEdit(0.0, frame, m->options()->format,
                                           m->options()->prec));
  eOff->setMinimumWidth(eOff->fontMetrics().width(m->number(-1.0e-123 /
                                                            3.0)) + 3);
  hbox->addWidget(update = new QPushButton(i18n("&Update"), frame));
  connect(update, SIGNAL(clicked()), SLOT(findRoots()));
  vbox->addWidget(table = new QTable(0, 4, frame));
  table->horizontalHeader()->setLabel(0, "x");
  table->horizontalHeader()->setLabel(1, "y(x)");
  table->horizontalHeader()->setLabel(2, "y'(x)");
  table->horizontalHeader()->setLabel(3, "y\"(x)");
  for (int i = 0; i < 4; ++i)
    table->setColumnStretchable(i, true);
  table->setMinimumHeight(100);
  setHelp("SEC-ROOTS");
  findRoots();
}

RootDlg::~RootDlg()
{
}

void RootDlg::findRoots()
{
  int nz, ier;
  int mest = 3 * spl->nk;
  QArray<double> zero(mest);
  int cond = eCond->currentItem();
  bool extrema = (cond > 2);
  update->setDisabled(extrema);
  double offset = extrema ? 0.0 : eOff->value();
  FitPack::sproot(spl->t.data(), spl->nk, spl->c.data(), zero.data(), mest,
                  &nz, &ier, extrema ? 1 : cond, offset);
  int count = 0;
  if (nz) {
    table->setNumRows(nz);
    char frm = m->options()->format;
    int prec = m->options()->prec;
    for (int i = 0; i < nz; ++i) {
      double y[3];
      for (int j = 0; j < 3; ++j)
        FitPack::splder(spl->t.data(), spl->nk, spl->c.data(), 3, j, &zero[i],
                        &y[j], 1, &ier);
      bool insert = true;
      switch (cond) {
        case 3:
          insert = (y[2] > 0.0);
          break;
        case 4:
          insert = (y[2] < 0.0);
      }
      if (insert) {
        table->setItem(count, 0, new QTableItem(table, QTableItem::Never,
                       QString::number(zero[i], frm, prec)));
        for (int j = 0; j < 3; ++j)
          table->setItem(count, j + 1, new QTableItem(table, QTableItem::Never,
                         QString::number(y[j], frm, prec)));
        ++count;
      }
    }
  }
  table->setNumRows(count);
  enableButton(User1, count);
}

void RootDlg::slotUser1()
{
  KURL url;
  if (Utils::getWriteURL(this, url, "*.dat\n*", m)) {
    QFile f(url.isLocalFile() ? url.path() : m->tmpFile());
    if (f.open(IO_WriteOnly)) {
      QTextStream ts(&f);
      for (int i = 0; i < table->numRows(); ++i)
        for (int j = 0; j < 4; ++j)
          ts << table->text(i, j)
             << ((j == 3) ? QString("\n") : m->separator());
      f.close();
      m->setCurrentDir(url);
      if (!url.isLocalFile())
        m->copyTmp(url);
    } else
      KMessageBox::error(this, i18n("while trying to open"));
  }
}
